/******************************************************************************
*
* Persistence of Vision Raytracer version 3.1
*
* Balls.pov
*
* This sample file is a part of the depth of field control plug-in
* and should be rendered at 640x480 resolution
*
******************************************************************************/

#include "colors.inc"
#include "DOF.INC"

camera {
   perspective
   location     <-30, 10, 20>
   up           y
   right        -4/3 * x
   look_at      <0, 0, 0>
   angle        15
   DoF(<-30, 10, 20>, 160, 15, <0, 0, 0>, <3, 1, -4>, <-6, 1, 4>)
   blur_samples 30
   variance     1/256
   confidence   0.999
}

light_source {
   <-300, 500, 200>
   color White*.6
    }
light_source {
   <100, 500, 600>
   color White*.6
    }

plane {y, 0
   pigment {checker color White color Black}
   }

sphere {<1, 1, 1>, 1
   pigment {color rgbf <0, 0, 1, 1>}
   finish {phong 1.3 phong_size 100 reflection 0.3}
   interior {ior 1.2}
   }

sphere {<3, 1, -4>, 1
   pigment {color Green}
   normal {leopard bump_size 3 scale 0.3}
   finish {phong 1.3 phong_size 100 reflection 1}
   }
   

sphere {<-6, 1, 4>, 1
   pigment {color Red}
   finish {phong .3 phong_size 1 reflection 0.1}
   }
