/******************************************************************************
* DoF INCLUDE FILE FOR PERSISTENCE OF VISION 3.1
*
* Depth of Field control plug-in V. 1.0
*
*
* Created by Francois Dispot, 15 July 1998
* Calculation formulas from "Chasseur d'Images" #198 (11/1997)
*
* See "DoF.txt" for more information.
*
******************************************************************************/

#local _DoF_tempver = version;
#version 3.1;

#macro DoF(
   Location, //the "location" vector
   Width,    //in pixels; decrease to narrow the sharpness zone
   Angle,    //in degrees
   LookAt,   //the look_at vector
   Plane1,   //1st sharp point
   Plane2    //2nd sharp point
   )

#render "Depth of Field control plug-in V 1.0\n"

#local Unary= vnormalize(LookAt-Location);
#local Alpha= vdot(Unary, Plane1-Location); //1st sharp distance
#local Beta = vdot(Unary, Plane2-Location); //last sharp distance
#if (Alpha = Beta)
   debug ("   Both control points are at the same distance\n")
   error
   #end
#if (Alpha <= 0)
   debug ("   1st control point is behind camera\n")
   error
   #end
#if (Beta <= 0)
   debug ("   2nd control point is behind camera\n")
   error
   #end
#local d=2/(1/Alpha+1/Beta);        //distance to focal point
#local H=2/(1/Alpha-1/Beta);        //Hyperfocal distance
#local F=18/tan(radians(Angle/2));  //Equivalent focal length (in mm) in 35mm
#local e=36/Width;                  //Diameter of confusion center is 1 pixel, in 35mm film mm.

#local A=e*H/F;                     //Aperture (in units, NOT f-stops)
#local FocalPoint=Location+d*Unary; //(in units)

#debug concat("   aperture ", str(A, 0, 3), "\n")
#debug concat("   focal_point <", str(FocalPoint.x, 0, 3), ", ", str(FocalPoint.y, 0, 3), ", ", str(FocalPoint.z, 0, 3), ">\n")

aperture A
focal_point FocalPoint

#end

#version _DoF_tempver;
