//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 3 lights, 13 textures and 42 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  Moray V3.01 For Windows (c) 1991-1998 Lutz + Kretzschmar
//  Altered for V3.1 syntax by Mark King <MarkFKing@csi.com>

//  Copyright Mark King October 1998
//

// Scene Includes

#include "sky.inc"  // Just for something to be reflected in the gold and ink bottle
#include "DoF.inc"  // For easier calculation depth of field settings.

// End Scene Includes

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 2.2
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 25.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  2
  }
}


camera {
  location  <-42.449, -82.370, 34.804>
  direction <0.0,     0.0,  1.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  angle 30
  look_at   <-14.897, -18.536, 1.852>
  // Focal blur settings needed for DoF.inc
  // focal_point  <-14.897, -18.536, 1.852> // Always Lookat
  // aperture     1.0
  DoF(<-42.449, -82.370, 34.804>, 320, 30, <-14.897, -18.536, 1.852>, <-14.0, -22.0, 1.852>, <-14.0, -16.0, 1.852>)   
  blur_samples 100      // 22
  confidence   0.999    // 0.5
  variance     1/255    //0.02
}


//
// *******  L I G H T S *******
//

light_source {
  <200.000, -100.000, 100.000>
  color  rgb<2.000, 2.000, 2.000>
  area_light <16.000, 0.000, 0.000>, <0.000, 16.000, 0>, 4, 4
  adaptive 1
  jitter
  rotate 45*x
}


light_source {
  <0.000, 178.240, 50.000>
  color  rgb <0.698, 0.698, 0.698>
  spotlight
    point_at  <-0.075, 177.282, 49.722>
    falloff   15.00  // outer radius (in deg)
      radius    4.33  // inner radius
}


light_source {
  <0.000, 0.000, 100.000>
  color rgb <1.000, 1.000, 1.000>
  shadowless
  fade_distance  50.0
  fade_power 2.0
  media_attenuation on
}


//
// ********  TEXTURES  *******
//

#include "bible_0.inc"

//
// ********  OBJECTS  *******
//

// The sheet of paper with text

box { 
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Letter_Tex
  }
  scale <13.5, 17.5, 0.05>
  rotate 22.793627*z
  translate  <-23.912964, -27.516287, -6.175823>
}

//
// Include file contains 'RotSwp001'
// Used in Pen_Body below
//

#include "bible_1.inc"
#declare RotSwp001 = object {
  RotSwp001_Raw
  texture {
    Lid_Tex
  }
}

// Declare the components of the pen

#declare Pen_Body = union {
  cylinder { // Cylndr10
    <0,0,1>, <0,0,0>, 1 
    texture {
      Gold_Metal
    }
    scale <0.218582, 0.21858, 0.1>
    translate  14.4*z
  }
  cylinder { // Cylndr11
    <0,0,1>, <0,0,0>, 1 
    texture {
      Gold_Metal
    }
    scale <0.755, 0.755, 0.1>
    translate  -0.1*z
  }
  object { RotSwp001 }
}

#declare Pen_Lid = union {
  sphere { // Sphere003
    <0,0,0>,1
    texture {
      Lid_Tex
    }
    scale 0.75
    translate  -11.0*z
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    texture {
      Lid_Tex_1
    }
    scale <0.75, 0.75, 11.0>
    translate  -11.2*z
  }
  cylinder { // Cylndr12
    <0,0,1>, <0,0,0>, 1 
    texture {
      Gold_Metal
    }
    scale <0.755, 0.755, 0.1>
    translate  -11.2*z
  }
  cylinder { // Cylndr13
    <0,0,1>, <0,0,0>, 1 
    texture {
      Gold_Metal
    }
    scale <0.755, 0.755, 0.1>
    translate  -0.22*z
  }
}

#declare Pen_Clip = difference {
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 1.0>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.630455>
    translate  <0.0, 0.649092, 0.643498>
  }
  scale <1.0, 1.0, 9.0>
}

#declare Clip = union {
  object { Pen_Clip }
  sphere { // Sphere004
    <0,0,0>,1
    scale <0.5, 0.2, 0.3>
    translate  <0.0, -0.307982, 8.669228>
  }
  texture {
    Gold_Metal
  }
  scale <0.750019, 0.750019, 1.0>
  rotate -180.0*z
  translate  <0.0, 0.708639, -11.20105>
}

// Assemble the whole pen and position it

union { 
  object { Pen_Body }
  object { Pen_Lid }
  object { Clip }
  scale <1.3333, 1.3333, 1.0>
  rotate <-91.031662, -62.900021, -131.852127>
  translate  <-18.278362, -21.862355, -5.173182>
}

// Now for the Bible

#declare Front_Cover = union {
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 33.0>
    rotate -90.0*x
    translate  <11.0, -16.5, 0.0>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 33.0>
    rotate -90.0*x
    translate  <-11.0, -16.5, 0.0>
  }
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 22.0>
    rotate -90.0*y
    translate  <11.0, -16.5, 0.0>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 22.0>
    rotate -90.0*y
    translate  <11.0, 16.5, 0.0>
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <11.0, 16.5, 0.2>
  }
  sphere { // Sphere4
    <0,0,0>,1
    scale 0.2
    translate  <11.0, -16.5, 0.0>
  }
  sphere { // Sphere3
    <0,0,0>,1
    scale 0.2
    translate  <-11.0, -16.5, 0.0>
  }
  sphere { // Sphere2
    <0,0,0>,1
    scale 0.2
    translate  <11.0, 16.5, 0.0>
  }
  sphere { // Sphere001
    <0,0,0>,1
    scale 0.2
    translate  <-11.0, 16.5, 0.0>
  }
  texture {
    Bible02
  }
  translate  0.2*z
}

#declare Back_Cover = union {
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 33.0>
    rotate -90.0*x
    translate  <11.0, -16.5, 0.0>
  }
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 33.0>
    rotate -90.0*x
    translate  <-11.0, -16.5, 0.0>
  }
  cylinder { // Cylndr6
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 22.0>
    rotate -90.0*y
    translate  <11.0, -16.5, 0.0>
  }
  cylinder { // Cylndr7
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 22.0>
    rotate -90.0*y
    translate  <11.0, 16.5, 0.0>
  }
  box { // Cube2
    <-1, -1, -1>, <1, 1, 1>
    scale <11.0, 16.5, 0.2>
  }
  sphere { // Sphere5
    <0,0,0>,1
    scale 0.2
    translate  <11.0, -16.5, 0.0>
  }
  sphere { // Sphere6
    <0,0,0>,1
    scale 0.2
    translate  <-11.0, -16.5, 0.0>
  }
  sphere { // Sphere7
    <0,0,0>,1
    scale 0.2
    translate  <11.0, 16.5, 0.0>
  }
  sphere { // Sphere8
    <0,0,0>,1
    scale 0.2
    translate  <-11.0, 16.5, 0.0>
  }
  texture {
    Bible01
  }
  translate  -6.0*z
}

#declare Spine = prism {
  linear_sweep
  cubic_spline
  0.0,-33.4
  18  // control points
  <-0.238187, -3.057168>,
  <-0.611549, 0.0>,
  <-0.27452, 2.643126>,
  <-0.129647, 3.25049>,
  <0.081634, 3.137189>,
  <0.270129, 3.128141>,
  <0.670766, 3.180407>,
  <0.552203, 2.987673>,
  <0.0539, 2.899224>,
  <-0.0678, 2.636306>,
  <-0.411549, 0.0>,
  <-0.151577, -2.525945>,
  <0.638184, -3.001525>,
  <0.660461, -3.268664>,
  <0.080766, -3.173405>,
  <-0.238187, -3.057168>,
  <-0.611549, 0.0>,
  <-0.27452, 2.643126>
  rotate -x*90
  texture {
    Spine_Tex
  }
  scale <1.0, 1.015851, 1.0>
  rotate -90.0*x
  translate  <-11.713469, -16.7, -2.9495>
}

// Include contains 'Pages'
#include "bible_2.inc"

#declare Pages = object {
  Pages_Raw
  texture {
    Page_Tex
  }
  scale <1.0, 1.015851, 1.0>
  rotate -90.0*x
  translate  <-11.713469, -16.217792, -2.9495>
}


// The whole Bible put together

union {
  object { Front_Cover }
  object { Back_Cover }
  object { Spine }
  object { Pages }
}

// A simple tabletop

box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Floor_Wood
  }
  scale <100.0, 100.0, 1.0>
  translate  <0.0, 55.452952, -7.205032>
}


#declare Ink_Lid = lathe {
  linear_spline
  4  // control points
  <3.9, 0.0>,
  <3.896849, 1.746981>,
  <3.626459, 1.996345>,
  <0.0, 2.0>
  rotate <90,0,90>
  texture {
    Lid_Tex_2
  }
  translate  <-25.106132, 0.0742, 4.569335>
}
//
// Include file contains 'Ink_Bottle'
//
#include "bible_3.inc"
#declare Ink_Bottle = object {
  Ink_Bottle_Raw
  texture {
    Glass
  }      
  interior { Glass_Interior }
  translate  <-25.104156, 0.08228, -6.15557>
}
//
// Include file contains 'Ink'
//
#include "bible_4.inc"
#declare Ink = object {
  Ink_Raw
  texture {
    Ink_Tex
  }
  translate  <-25.104156, 0.08228, -6.15557>
}
#declare LidRim01 = difference {
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <3.95, 3.95, 0.1>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    scale <3.8, 3.8, 1.0>
    translate  <0.0, -0.0, -0.464522>
  }
  texture {
    Gold_Metal_1
  }
  translate  <-25.106265, 0.074007, 6.195398>
}
#declare LidRim02 = difference {
  cylinder { // Cylndr8
    <0,0,1>, <0,0,0>, 1 
    scale <3.95, 3.95, 0.1>
  }
  cylinder { // Cylndr9
    <0,0,1>, <0,0,0>, 1 
    scale <3.8, 3.8, 1.0>
    translate  <0.0, -0.0, -0.464522>
  }
  texture {
    Gold_Metal_1
  }
  translate  <-25.106265, 0.074007, 4.570111>
}

// The whole ink bottle. I originally had the parts of the ink bottle in one union
// statement, but it caused POV-Ray 3.1 to crash so I had to seperate them.

union { // The lid.
    object { Ink_Lid }
    object { LidRim01 }
    object { LidRim02 }
    }

object { Ink_Bottle }
object { Ink }



