// By: Ken Tyler Oct. 1998
// Compatible with POV-Ray 3.0 and 3.1
// Memory requirements for height field only = 2,157,182

// The image I used was scaled from 640x480 t0 600x300 to cause the
// random noise image to elongate in the x direction. This helped
// give some flatness to the blades of grass as viewed from a camera
// position at -z

// I know this mother is huge (the grass) but I was working on a scene
// where I needed a grass plane out to the horizon. You will want to
// scale things down a bit if you use this in a smaller area.

// Not needed now but available
// #include "colors.inc"
// #include "textures.inc"

camera       { location<0, 9, -225 > look_at 20*y }

// The lighting and surface finish of the grass height field
// has a dramatic effect on the look of the scene and will have
// to be carefully choosen to match the scene they are used in.

light_source { < 0, 120, -590> rgb 1 }
light_source { < 0,  50, -220> rgb 1 }

// An optional texture for the grass. If scaled right will give
// a yellowish tint to the roots of the grass as seen in nature.
  
// #declare GrassTex =
// texture{pigment{gradient y turbulence .22 color_map{
// [0.1,0.15 color rgb<0.87,0.87,0.1>color rgb<0.67,0.87,0.1>]
// [0.15 rgb< 0.3, 0.75, 0.4>]}}scale<1,1.5,1>translate y*-1.2}



#declare Grass =
height_field { tga"grassmap.tga" smooth
texture      { pigment{ rgb< 0.3, 0.75, 0.4> } /*GrassTex*/
finish       { crand 0.001 ambient .3 diffuse 0.3 phong 0.2}
scale 0.6    } translate -0.5 scale<100,2,50>}

// The following takes the declared grass patch and makes a
// 10x10 matrix. I used this method to keep the density of the
// grass as thick as possible. If you over scale it you end
// up with bare spots and the "blades" rapidly loose what little
// definition they have.

// The Grass Placement
#declare Yard =
#declare cx = 1;
#while  (cx<=10)
#declare cz = 1;
#while  (cz<=10)
object  {Grass translate<-550,-1,-250>translate<99*cx,0,49*cz> }
#declare cz = cz + 1; #end
#declare cx = cx + 1; #end

// The Yard
object{ Yard }

// Pigment for the brick wall
#declare Pig1 = pigment{marble  turbulence .45 
color_map{
[.200 rgb<.6,.52,.46>][.205 rgb<.43,.37,.29>]
[.205 rgb<.6,.47,.36>][.500 rgb<.53,.43,.23>]
[.505 rgb<.6,.49,.42>][.505 rgb<.48,.35,.26>]
[.805 rgb<.6,.45,.39>][1.01 rgb<.44,.33,.22>]}
rotate 85*-z}

// The Brick Wall
box{-1,1 scale<530,45,3>translate<0,45,200>
pigment{brick 
pigment{rgb<.87,.91,0.90>}
pigment{Pig1 scale<2,2,1>}
scale 3.2}}

// The Sky
sky_sphere {pigment {bozo turbulence 0.3 omega 0.7 
pigment_map{[ 0.750 bumps turbulence 0.3 omega 0.7 
color_map  {[0 rgb 1 ][1 rgb .7]}scale .4]}}}
