//start file
camera
{
   right     < 1, 0, 0   >
   up        < 0, 1, 0   >
   direction < 0, 0, 2 >
   location  <-100, 75, -100   >*2.75
   look_at <0,0,0>
}
light_source {
<-3000,2000,3000>
color rgb 1.25
spotlight
point_at 0
radius 5000
falloff 7500
}
light_source {
<0,6000,-6000>
color rgb .75
spotlight
point_at 0
radius 5000
falloff 7500
}
light_source {
<3000,2000,-3000>
color rgb .5
spotlight
point_at 0
radius 5000
falloff 7500
}


//Textures and pre-defined shapes
#declare RBox2 = superellipsoid {
<.25, .25>
translate <1,1,1>
scale .5
}
#declare RBox = superellipsoid {
<.125, .125>
translate <1,1,1>
scale .5
}
#declare RCylinder1 = //cylinder {0,1,1}
superellipsoid {
<1, .125>
rotate 90*x
translate <0,1,0>
scale .5
}
#declare General_Tex4 =
texture {
pigment {rgb <1,1,.675>}
finish {ambient 1 diffuse 0}
}
#declare General_Tex1 =
texture {
pigment {rgb <.4875,.4875,.5>}
finish {ambient 0 diffuse 1 phong .5 metallic phong_size 5}
}
#declare General_Tex2 =
texture {
pigment {rgb <.45,.45,.5>*.375}
finish {ambient 0 diffuse 1 phong .5 metallic phong_size 5}
}
#declare OrangeGlow =
union {
sphere {
0, 1
hollow
texture {
pigment  {
rgbt<1, 1, 1, 1>}
halo {
emitting
linear
spherical_mapping
color_map {
[0 color rgbt<1, 1, .675,  1>]
[1.0 color rgbt<1, 1, .675, .5>]
}
}
}
}
scale 1.25
translate <0,0,.25>
}

//Mass Driver Cannon
#declare MassDriver =
union {
blob {
threshold .01
cylinder {0,<0,1,0>,1, 1 scale <5,3,5> rotate <90,0,0>}
cylinder {0,<0,1,0>,1, -20 scale <10000,20,10> translate <0,-10,-10>}
#declare Count = 0
#while (Count < 360)
cylinder {<0,3,-15>,<0,3,2.5>,1, -1 rotate Count*z}
#declare Count = Count + 45
#end
texture {General_Tex1}
}
#declare Count = 0
#while (Count < 360)
cylinder {<0,3,15>,<0,3,0>,1 open rotate Count*z texture {General_Tex2}}
#declare Count = Count + 45
#end
}
//Neutron Gun
#declare Neutron =
// Object type: World
// Name: Root
object
{
   union
   {
      // Object type: Composite
      // Name: group #1
      object
      {
         union
         {
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Sphere
                  // Name: NoName
                  object
                  {
                     sphere { < 0, 0, 0 >, 1 }

                     scale < 4, 4, 8 >
                     translate < 0, 0, -14 >
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < 40, 2, 40 >
                     rotate < 90, 0, 0 >
                     translate < 0, 0, -21 >
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                     scale < 1.6, 12, 1.6 >
                     rotate < 90, 0, 0 >
                     translate < 0, -9.0008e-23, -26 >
                  }
                  // Object type: Torus
                  // Name: NoName
                  object
                  {
                     torus { 30, 2.5 }

                     scale < 0.14, 0.2, 0.14 >
                     rotate < 90, 0, 0 >
                     translate < 0, 0, -14 >
                  }
                  // Object type: Torus
                  // Name: NoName
                  object
                  {
                     torus { 30, 2.5 }

                     scale < 0.13, 0.2, 0.13 >
                     rotate < 90, 0, 0 >
                     translate < 0, 0, -16.2 >
                  }
               }
            }
            // Object type: Torus
            // Name: NoName
            object
            {
               torus { 30, 10 }

               scale < 0.028, 0.2, 0.028 >
               rotate < 90, 0, 0 >
               translate < 0, 0, -20 >
            }
            // Object type: Polynomial
            // Name: NoName
            object
            {
               RBox

               scale < 4, 9, 17 >
               translate < -4, -4, 9 >
            }
            // Object type: Cone
            // Name: NoName
            object
            {
               cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.5  }

               rotate < -90, 0, 0 >
               translate < 4.5, 3.5, 9 >
            }
            // Object type: Cone
            // Name: NoName
            object
            {
               cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.5 open }

               rotate < -90, 0, 0 >
               translate < 0, 0, -22 >
            }
            // Object type: Cone
            // Name: NoName
            object
            {
               cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.5  }

               rotate < -90, 0, 0 >
               translate < 4.5, -2.5, 9 >
            }
            // Object type: Cone
            // Name: NoName
            object
            {
               cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.5  }

               rotate < -90, 0, 0 >
               translate < 4.5, 0.5, 9 >
            }
            // Object type: Composite
            // Name: group #1
            object
            {
               union
               {
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                     scale < 1.5, 25, 1.5 >
                     rotate < 90, 0, -120 >
                     translate < 1.732, -1, -14 >
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                     scale < 1.5, 25, 1.5 >
                     rotate < 90, 0, 0 >
                     translate < 0, 2, -14 >
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                     scale < 1.5, 25, 1.5 >
                     rotate < 90, 0, 120 >
                     translate < -1.732, -1, -14 >
                  }
                  // Object type: Polynomial
                  // Name: NoName
                  object
                  {
                     RBox2

                     scale < 6, 9, 17 >
                     translate < 0, -4, 9 >
                  }
                  // Object type: Polynomial
                  // Name: NoName
                  object
                  {
                     RBox2

                     scale < 2, 7, 12 >
                     translate < -5, -3, 12 >
                  }
                  // Object type: Polynomial
                  // Name: NoName
                  object
                  {
                     RBox2

                     scale < 2, 4, 12 >
                     translate < 5, -3, 12 >
                  }
                  // Object type: Polynomial
                  // Name: NoName
                  object
                  {
                     RBox2

                     scale < 2, 1, 4 >
                     translate < 3.5, 4.5, 10 >
                  }
                  // Object type: Polynomial
                  // Name: NoName
                  object
                  {
                     RBox2

                     scale < 2, 1, 4 >
                     translate < 3.5, 4.5, 14.5 >
                  }
                  // Object type: Polynomial
                  // Name: NoName
                  object
                  {
                     RBox2

                     scale < 2, 1, 4 >
                     translate < 3.5, 4.5, 19 >
                  }
               }

               texture
               {
                  General_Tex1
                  scale < 2, 2, 2 >
                  translate < 1, 0.8, 6 >
               }
            }
         }

         texture
         {
            General_Tex2
            scale < 2, 2, 2 >
         }
      }
   }
}

#declare Side_Wing =
blob {
threshold .01
sphere {< 0, 0, 0 >, 1,.5
scale < 43, 18, 140 >
}
//Various bumps on the wing
sphere { < 0, 0, 0 >, 1,.25
scale < 10, 6.75, 20 >
rotate < 3.75, 0, -8.75 >
translate < 18.25, 13, 25 >
}
sphere { < 0, 0, 0 >, 1,.5
scale < 3, 3, 9 >
rotate < 0, 0, -8.75 >
translate < 5.25, 16, -10 >
}
sphere { < 0, 0, 0 >, 1,.5
scale < 3, 3, 9 >
rotate < 0, 0, -8.75 >
translate < 10.25, 15.5, -10 >
}
//cutouts
cylinder {<0,0,0>,<0,1,0>,1,-75
scale <75,40,10000>
translate <-27.5-50,-20,0>}

cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1,-75
scale < 80, 40, 10000 >
rotate < 0, 90, 0 >
translate < 0, -20, -106 >
}
cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 ,-75
scale < 220, 40, 10000 >
rotate < 0, 90, 0 >
translate < 0, -20, 290 >
}
cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1,-20
scale < 5, 20, 5 >
rotate < 90, 0, 0 >
translate < 7.5, 6.5, -37 >
pigment {rgb .25}
}
cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1,-75
scale < 5, 20, 5 >
rotate < 90, 0, 0 >
translate < 7.5, -6.5, -37 >
pigment {rgb .25}
}
cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1,-10
scale < 5, 20, 5 >
rotate < 90, 0, 0 >
translate < 18, 0, -37 >
pigment {rgb .25}
}
cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 ,-10
scale < 2.5, 20, 2.5 >
rotate < 90, 0, 0 >
translate < 26, -3, -37 >
pigment {rgb .25}
}
cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 ,-10
scale < 2.5, 20, 2.5 >
rotate < 90, 0, 0 >
translate < 26, 3, -37 >
pigment {rgb .25}
}
cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1,-10
scale < 2.5, 20, 2.5 >
rotate < 90, 0, 0 >
translate < 32, 0, -37 >
pigment {rgb .25}
}
}

#declare UFusalage =
blob {
threshold .01
//Base
sphere {< 0, 0, 0 >, 1,.5
scale < 82, 1, 67 >
}
//Small booster humps
sphere { < 0, 0, 0 >, 1,.25
scale < 8, 8, 40 >
translate < 14, -1, 20 >
}
sphere { < 0, 0, 0 >, 1,.25
scale < 8, 8, 40 >
translate < -14, -1, 20 >
}
sphere { < 0, 0, 0 >, 1,.125
scale < 3, 3, 9 >
translate < -6, -1, 0 >
}
sphere { < 0, 0, 0 >, 1,.125
scale < 3, 3, 9 >
translate < 6, -1, 0 >
}
sphere { < 0, 0, 0 >, 1,.25
scale < 3, 3, 9 >
translate < 18, -1, -31 >
}
//Mass Driver holders
sphere { < 0, 0, 0 >, 1,.25
scale < 7, 12.5, 20 >
translate <-4.75,-1,-47.5>
}
sphere { < 0, 0, 0 >, 1,.25
scale < 7, 12.5, 20 >
translate <4.75,-1,-47.5>
}
//cutouts
cylinder {<0,0,0>,<0,1,0>,1,-75
scale < 57, 80, 10000 >
translate < -80, -40, 0 >
}
cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1,-75
scale < 57, 80, 10000 >
translate < 80, -40, 0 >
}
cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 ,-250
scale < 570, 80, 10000 >
rotate < 0, 90, 0 >
translate < 0, -40, 610 >
}
cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 ,-75
scale < 565, 80, 10000 >
rotate < 0, 90, 0 >
translate < 0, -40, 600 >
}
sturm
}

#declare Fusalage =
difference {
blob {
threshold .01
//Base
sphere {< 0, 0, 0 >, 1,.5
scale < 82, 19, 67 >
}
//cockpit hump
sphere { < 0, 0, 0 >, 1,.375
scale < 15, 35, 75 >
rotate <-7.5,0,0>
translate < 0, 6, 0 >
}
//Small booster humps
sphere { < 0, 0, 0 >, 1,.25
scale < 8, 8, 40 >
translate < 14, 16, 20 >
}
sphere { < 0, 0, 0 >, 1,.25
scale < 8, 8, 40 >
translate < -14, 16, 20 >
}
sphere { < 0, 0, 0 >, 1,1
scale < 3, 3, 9 >
translate < -6, 33.5, 21 >
}
sphere { < 0, 0, 0 >, 1,1
scale < 3, 3, 9 >
translate < 6, 33.5, 21 >
}
sphere { < 0, 0, 0 >, 1,.25
scale < 3, 3, 9 >
rotate <-8.75,0,0>
translate < 18.25, 15, -31 >
}
sphere { < 0, 0, 0 >, 1,.25
scale < 3, 3, 9 >
rotate <-8.75,0,0>
translate < -18.25, 15, -31 >
}
//cutouts
cylinder {<0,0,0>,<0,1,0>,1,-75
scale < 57, 80, 10000 >
translate < -80, -40, 0 >
}
cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1,-75
scale < 57, 80, 10000 >
translate < 80, -40, 0 >
}
cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 ,-250
scale < 570, 80, 10000 >
rotate < 0, 90, 0 >
translate < 0, -40, 610 >
}
cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 ,-75
scale < 565, 80, 10000 >
rotate < 0, 90, 0 >
translate < 0, -40, 600 >
}
cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 ,-75
scale < 70, 200, 10000 >
rotate <0,0,-90>
translate < -100, -70, 0 >
}
sturm
}
object {RBox2 scale < 12, 11, 40 > translate < 10, 1, -77 >}
object {RBox2 scale < 12, 11, 40 > translate < 10, 1, -77 > scale <-1,1,1>}
//Maneuvering jet cutouts on cockpit hump
object {box {0,1}scale <4.95,6.81,6.0792> rotate <0,0,-45> translate <3,33.5,18>
texture {General_Tex2}}
object {box {0,1}scale <4.95,6.81,6.0792> rotate <0,0,-45> translate <3,33.5,18>
scale <-1,1,1> texture {General_Tex2}}
//Maneuvering jet cutouts on Base
object {box {0,1}scale <5,6.8096,6.0792> rotate <-7.5,0,0> translate <15.5,13,-34>
texture {General_Tex2}}
object {box {0,1}scale <5,6.8096,6.0792> rotate <-7.5,0,0> translate <15.5,13,-34>
scale <-1,1,1> texture {General_Tex2}}
}

//Self explanitory
#declare Engine =

union {
union {
union {OrangeGlow scale 10 translate <0,0,25>}
}
cylinder {0,<0,0,10>,10}
#declare Count = 0
#while (Count < 360)
box {0,1 scale <2,.5,9> translate <-1,10,.5> rotate Count*z}
#declare Count = Count + 15
#end
torus { 8, 2 rotate -90*x scale <1,1,2.5> translate <0,0,15>texture {General_Tex1}}
torus { 7.5, 1 rotate -90*x scale <1,1,5> translate <0,0,22.5>}
disc {<0,0,25>, z, 7.5 texture {General_Tex4}}
torus { 4, .5 rotate -90*x translate <0,0,25>}
#declare Count = 0
#while (Count < 360)
object {RBox2 scale <1,.5,1> translate <-.5,6,25> rotate Count*z}
#declare Count = Count + 15
#end
texture {General_Tex2}
}

//The star fighter
#declare Raptor =
union {
//The upper part of the star fighter
difference {
union {
object {
Fusalage
}
object {
Side_Wing
translate <25,0,0>
}
object {
Side_Wing
translate <25,0,0>
scale <-1,1,1>
}
texture {
pigment {image_map {png "raptor.png"interpolate 2}}
normal {bump_map {gif "raptorbm.gif" interpolate 2} bump_size .5}
finish {ambient 0 diffuse 1 phong .25 metallic phong_size 5}
scale <150,200,1> rotate 90*x translate <-75,0,-100>
}
texture {
pigment {rgbt 1}
normal {bumps bump_size .025 scale .005}
finish {ambient 0 diffuse 1 phong .25 metallic phong_size 5}
scale <150,200,1> rotate 90*x translate <-75,0,-100>
}
}
plane {y,0}
}
//The lower part of the star fighter
difference {
union {
object {
UFusalage
}
object {
Side_Wing
translate <25,0,0>
}
object {
Side_Wing
translate <25,0,0>
scale <-1,1,1>
}
texture {
pigment {image_map {png "raptor2.png"interpolate 2}}
normal {bump_map {gif "raptorbm.gif" interpolate 2} bump_size .5}
finish {ambient 0 diffuse 1 phong .25 metallic phong_size 5}
scale <150,200,1> rotate 90*x translate <-75,0,-100>
}
texture {
pigment {rgbt 1}
normal {bumps bump_size .025 scale .005}
finish {ambient 0 diffuse 1 phong .25 metallic phong_size 5}
scale <150,200,1> rotate 90*x translate <-75,0,-100>
}
}
plane {-y,0}
}
//End Part
      // Object type: Composite
      // Name: group #1
      object
      {
         union
         {
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                     scale < 11, 21, 17 >
                     rotate < 90, 0, 0 >
                     translate < 0, 18, 23 >
                     texture {
pigment {image_map {png "raptor.png"interpolate 2}}
normal {bump_map {gif "raptorbm.gif" interpolate 2} bump_size .5}
finish {ambient 0 diffuse 1 phong .25 metallic phong_size 5}
scale <150,200,1> rotate 90*x translate <-75,0,-100>
}
texture {
pigment {rgbt 1}
normal {bumps bump_size .025 scale .005}
finish {ambient 0 diffuse 1 phong .25 metallic phong_size 5}
scale <150,200,1> rotate 90*x translate <-75,0,-100>
}
}
                  // Object type: Difference
                  // Name: 'and not'
                  object
                  {
                     difference
                     {
                        // Object type: Cylinder
                        // Name: NoName
                        object
                        {
                           cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                           scale < 10, 21, 16 >
                           rotate < 90, 0, 0 >
                           translate < 0, 18, 40 >
                        }
                        // Object type: Box
                        // Name: NoName
                        object
                        {
                           box { < 0, 0, 0 >, < 1, 1, 1 > }

                           scale < 24, 6, 37 >
                           translate < -12, 15, 37 >
                        }
                     }
                  }
               }
            }
            // Object type: Sphere
            // Name: NoName
            object
            {
               sphere { < 0, 0, 0 >, 1 }

               scale < 3, 3, 9 >
               translate < 11, 18, 35 >
            }
            // Object type: Sphere
            // Name: NoName
            object
            {
               sphere { < 0, 0, 0 >, 1 }

               scale < 3, 3, 9 >
               translate < -11, 18, 35 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 5, 6, 5 >
               rotate < 90, 0, 0 >
               translate < 0, 18, 38 >

               texture
               {
                  General_Tex1
                  scale < 5, 6, 5 >
                  rotate < 90, 0, 0 >
                  translate < 0, 18, 38 >
               }
            }
            // Object type: Sphere
            // Name: NoName
            object
            {
               sphere { < 0, 0, 0 >, 1 }

               scale < 5, 5, 1 >
               translate < 0, 18, 44 >

               texture
               {
                  General_Tex1
                  scale < 5, 5, 1 >
                  translate < 0, 18, 44 >
               }
            }
            // Object type: Sphere
            // Name: NoName
            object
            {
               sphere { < 0, 0, 0 >, 1 }

               scale < 2, 5, 3 >
               translate < -5, 26, 40 >
            }
            // Object type: Sphere
            // Name: NoName
            object
            {
               sphere { < 0, 0, 0 >, 1 }

               scale < 2, 5, 3 >
               translate < 5, 26, 40 >
            }
            // Object type: Sphere
            // Name: NoName
            object
            {
               sphere { < 0, 0, 0 >, 1 }

               scale < 2, 5, 3 >
               translate < -4, 9, 40 >
            }
            // Object type: Sphere
            // Name: NoName
            object
            {
               sphere { < 0, 0, 0 >, 1 }

               scale < 2, 5, 3 >
               translate < 4, 9, 40 >
            }
         }

         texture
         {
            General_Tex2
            translate < 0, 18, 49 >
         }
         scale .875
         translate <0,2,12>
      }
//The engines.
union {
Engine
scale <1.25,1.25,1>
translate <35,0,70>
}
union {
Engine
scale <1.25,1.25,1>
translate <-35,0,70>
}
union {
Engine
scale <.5,.5,1>
translate <50,0,70>
}
union {
Engine
scale <.5,.5,1>
translate <-50,0,70>
}
union {
Engine
scale <.675,.675,1>
translate <-15,15,35>
}
union {
Engine
scale <.675,.675,1>
translate <15,15,35>
}
union {
Engine
scale <.5,.5,1>
translate <-12,2.5,35>
}
union {
Engine
scale <.5,.5,1>
translate <12,2.5,35>
}
//Now the guns.
union {
Neutron translate <15.5,5,-61.5>
}
union {
Neutron translate <-15.5,5,-61.5>
}
union {
MassDriver translate <5,-5,-72.5>
}
union {
MassDriver translate <-5,-5,-72.5>
}
//Maneuvering jet nozzels
union {
object {torus { 30, 5 } scale <.05,.424,.05> rotate <0,0,45> translate <-6,33.5,21>}
object {torus { 30, 5 } scale <.05,.424,.05> translate <18,15,-31>}
object {torus { 30, 5 } scale <.05,.424,.05> rotate <0,0,45> translate <-6,33.5,21>
scale <-1,1,1>}
object {torus { 30, 5 } scale <.05,.424,.05> translate <18,15,-31>
scale <-1,1,1>}
texture {General_Tex2}}
//I think that this speeds it up a bit
//maybe not.
//bounded_by {
//box {0,1 scale <150,40,300> translate <-75,-20,-150>}
//}
translate <0,0,-20>
}

object {
Raptor translate 55*y
}
object {
Raptor rotate 180*y translate -55*y
}




global_settings {
max_trace_level 10
}
//end file
