/************************************************************
/
/ This file is a collection of all entries in the kolors.inc
/ include file. Kolors.inc was created by Ken Tyler for use
/ with the Persistence of Vision Raytracer (POV-Ray) version
/ 3.x . The file contains 683 colors, the majority of which
/ have been created by Ken Tyler, and the old ones kept for
/ compatibility. All of them are present here except for
/ color Clear (it's there, actually :) ) Render this file to
/ get a (hopefully) nice-looking and organized palette. In
/ order to find out which name corresponds to a certain entry
/ of the palette just see its column and row numbers, as they
/ appear on the image (some are skipped!). That's all. Hope
/ you find this demo helpful.
/
/ Happy tracing!
/
/ --Peter Popov
/
/ Comments, ideas, compliments, criticism etc. at peter.popov@usa.net
/
************************************************************/

#version 3.02

#include "kolors.inc"

#default {finish {diffuse 1 ambient 0}}

// #declare tile = sphere { 0, 0.575 }
#declare tile =
union
{ box { -1, 1 }
  sphere { x+y, 1 }
  sphere { x-y, 1 }
  sphere { -x-y, 1 }
  sphere { -x+y, 1 }
  cylinder { -x-y, -x+y, 1 }
  cylinder { -x+y, +x+y, 1 }
  cylinder { +x+y, +x-y, 1 }
  cylinder { +x-y, -x-y, 1 }
  scale 0.2725
}

#declare Column = x
#declare Row = -y

light_source { -1000*z color White }
camera { location -27*z+16.5*Column+11.5*Row look_at 16.5*Column+11.5*Row orthographic }

#declare X=0
#while (X<34)
  #if ((X!=7)&(X!=16)&(X!=25))
    text
    { ttf "cyrvetic.ttf",
      str(X,0,0),
      1,0
      scale 0.7
      texture
      {
        pigment { White     }
        finish  { ambient 1 }
      }
      translate Column*X+y-0.3*x
    }
  #end
  #declare X=X+1
#end

#declare Y=0
#while (Y<25)
  #if ((Y!=4)&(Y!=11)&(Y!=18))
    text
    { ttf "cyrvetic.ttf",
      str(Y,0,0),
      1,0
      scale 0.7
      texture
      {
        pigment { White     }
        finish  { ambient 1 }
      }
      translate Row*Y-Column-0.35*x-0.2*y
    }
  #end
  #declare Y=Y+1
#end

text
  { ttf "cyrvetic.ttf",
    "kolors.inc created by Ken Tyler (tylereng@pacbell.net), this demo by Peter Popov (peter.popov@usa.net)",
    1,0
    scale 0.55
    texture
    {
      pigment
      { marble
        frequency 1/60
        color_map
        {
          [0.0 color Red    ]
          [0.2 color Yellow ]
          [0.4 color Green  ]
          [0.6 color Blue   ]
          [0.8 color Violet ]
          [1.0 color Red    ]
        }
      }
      finish  { ambient 2 }
    }
    rotate 90*z
    translate -5*z
    translate 34.1*Column+24*Row
  }

object {tile translate Column*0+Row*0 pigment {Black}}
object {tile translate Column*1+Row*0 pigment {Gray005}}
object {tile translate Column*2+Row*0 pigment {Gray02}}
object {tile translate Column*3+Row*0 pigment {Gray03}}
object {tile translate Column*4+Row*0 pigment {Gray04}}
object {tile translate Column*5+Row*0 pigment {Gray05}}
object {tile translate Column*6+Row*0 pigment {Gray05A}}
object {tile translate Column*8+Row*0 pigment {Gray06}}
object {tile translate Column*9+Row*0 pigment {Gray07}}
object {tile translate Column*10+Row*0 pigment {Gray08}}
object {tile translate Column*11+Row*0 pigment {Gray09}}
object {tile translate Column*12+Row*0 pigment {Gray10}}
object {tile translate Column*13+Row*0 pigment {Gray10A}}
object {tile translate Column*14+Row*0 pigment {Gray11}}
object {tile translate Column*15+Row*0 pigment {Gray12}}
object {tile translate Column*17+Row*0 pigment {Gray13}}
object {tile translate Column*18+Row*0 pigment {Gray14}}
object {tile translate Column*19+Row*0 pigment {Gray15A}}
object {tile translate Column*20+Row*0 pigment {Gray15}}
object {tile translate Column*21+Row*0 pigment {Gray16}}
object {tile translate Column*22+Row*0 pigment {Gray17}}
object {tile translate Column*23+Row*0 pigment {Gray18}}
object {tile translate Column*24+Row*0 pigment {DarkSlateGray1}}
object {tile translate Column*26+Row*0 pigment {Gray19}}
object {tile translate Column*27+Row*0 pigment {Gray20A}}
object {tile translate Column*28+Row*0 pigment {Gray20}}
object {tile translate Column*29+Row*0 pigment {Gray21}}
object {tile translate Column*30+Row*0 pigment {Gray22}}
object {tile translate Column*31+Row*0 pigment {Gray23}}
object {tile translate Column*32+Row*0 pigment {Gray24}}
object {tile translate Column*33+Row*0 pigment {Gray25}}
object {tile translate Column*0+Row*1 pigment {Gray25A}}
object {tile translate Column*1+Row*1 pigment {Gray26}}
object {tile translate Column*2+Row*1 pigment {Gray27}}
object {tile translate Column*3+Row*1 pigment {Gray28}}
object {tile translate Column*4+Row*1 pigment {Gray29}}
object {tile translate Column*5+Row*1 pigment {Gray30}}
object {tile translate Column*6+Row*1 pigment {Gray30A}}
object {tile translate Column*8+Row*1 pigment {Gray31}}
object {tile translate Column*9+Row*1 pigment {Gray32}}
object {tile translate Column*10+Row*1 pigment {Gray33}}
object {tile translate Column*11+Row*1 pigment {DimGray}}
object {tile translate Column*12+Row*1 pigment {Gray34}}
object {tile translate Column*13+Row*1 pigment {Gray35A}}
object {tile translate Column*14+Row*1 pigment {Gray36}}
object {tile translate Column*15+Row*1 pigment {Gray37}}
object {tile translate Column*17+Row*1 pigment {Gray38}}
object {tile translate Column*18+Row*1 pigment {Gray39}}
object {tile translate Column*19+Row*1 pigment {Gray40A}}
object {tile translate Column*20+Row*1 pigment {Gray40}}
object {tile translate Column*21+Row*1 pigment {Gray41}}
object {tile translate Column*22+Row*1 pigment {DimGray1}}
object {tile translate Column*23+Row*1 pigment {Gray42}}
object {tile translate Column*24+Row*1 pigment {Gray43}}
object {tile translate Column*26+Row*1 pigment {Gray44}}
object {tile translate Column*27+Row*1 pigment {Gray45A}}
object {tile translate Column*28+Row*1 pigment {Gray45}}
object {tile translate Column*29+Row*1 pigment {Gray46}}
object {tile translate Column*30+Row*1 pigment {Gray47}}
object {tile translate Column*31+Row*1 pigment {Gray48}}
object {tile translate Column*32+Row*1 pigment {Gray49}}
object {tile translate Column*33+Row*1 pigment {Gray50A}}
object {tile translate Column*0+Row*2 pigment {Gray50}}
object {tile translate Column*1+Row*2 pigment {Gray51}}
object {tile translate Column*2+Row*2 pigment {Gray52}}
object {tile translate Column*3+Row*2 pigment {Gray53}}
object {tile translate Column*4+Row*2 pigment {Snow4}}
object {tile translate Column*5+Row*2 pigment {Gray54}}
object {tile translate Column*6+Row*2 pigment {Gray55A}}
object {tile translate Column*8+Row*2 pigment {Gray56}}
object {tile translate Column*9+Row*2 pigment {Gray57}}
object {tile translate Column*10+Row*2 pigment {Gray58}}
object {tile translate Column*11+Row*2 pigment {Gray59}}
object {tile translate Column*12+Row*2 pigment {Gray60A}}
object {tile translate Column*13+Row*2 pigment {Gray60}}
object {tile translate Column*14+Row*2 pigment {Gray61}}
object {tile translate Column*15+Row*2 pigment {Gray62}}
object {tile translate Column*17+Row*2 pigment {Gray63}}
object {tile translate Column*18+Row*2 pigment {Gray64}}
object {tile translate Column*19+Row*2 pigment {Gray65A}}
object {tile translate Column*20+Row*2 pigment {Gray65}}
object {tile translate Column*21+Row*2 pigment {Gray66}}
object {tile translate Column*22+Row*2 pigment {DarkGray}}
object {tile translate Column*23+Row*2 pigment {Gray67}}
object {tile translate Column*24+Row*2 pigment {Gray68}}
object {tile translate Column*26+Row*2 pigment {Gray69}}
object {tile translate Column*27+Row*2 pigment {Gray70A}}
object {tile translate Column*28+Row*2 pigment {Gray70}}
object {tile translate Column*29+Row*2 pigment {Gray71}}
object {tile translate Column*30+Row*2 pigment {Gray72}}
object {tile translate Column*31+Row*2 pigment {Gray73}}
object {tile translate Column*32+Row*2 pigment {Gray74}}
object {tile translate Column*33+Row*2 pigment {Grey}}
object {tile translate Column*0+Row*3 pigment {Gray75}}
object {tile translate Column*1+Row*3 pigment {Gray76}}
object {tile translate Column*2+Row*3 pigment {Gray77}}
object {tile translate Column*3+Row*3 pigment {Gray78}}
object {tile translate Column*4+Row*3 pigment {Gray79}}
object {tile translate Column*5+Row*3 pigment {Gray80A}}
object {tile translate Column*6+Row*3 pigment {VLightGrey}}
object {tile translate Column*8+Row*3 pigment {Gray81}}
object {tile translate Column*9+Row*3 pigment {Gray82}}
object {tile translate Column*10+Row*3 pigment {LightGray}}
object {tile translate Column*11+Row*3 pigment {Gray83}}
object {tile translate Column*12+Row*3 pigment {Gray84}}
object {tile translate Column*13+Row*3 pigment {Gray85A}}
object {tile translate Column*14+Row*3 pigment {Gray86}}
object {tile translate Column*15+Row*3 pigment {Gainsboro}}
object {tile translate Column*17+Row*3 pigment {Gray87}}
object {tile translate Column*18+Row*3 pigment {Gray88}}
object {tile translate Column*19+Row*3 pigment {Gray89}}
object {tile translate Column*20+Row*3 pigment {Gray90A}}
object {tile translate Column*21+Row*3 pigment {Gray90}}
object {tile translate Column*22+Row*3 pigment {Gray91}}
object {tile translate Column*23+Row*3 pigment {Gray92}}
object {tile translate Column*24+Row*3 pigment {Gray93}}
object {tile translate Column*26+Row*3 pigment {Gray94}}
object {tile translate Column*27+Row*3 pigment {Gray95A}}
object {tile translate Column*28+Row*3 pigment {Gray95}}
object {tile translate Column*29+Row*3 pigment {WhiteSmoke}}
object {tile translate Column*30+Row*3 pigment {Gray97}}
object {tile translate Column*31+Row*3 pigment {Gray98}}
object {tile translate Column*32+Row*3 pigment {Gray99}}
object {tile translate Column*33+Row*3 pigment {White}}
object {tile translate Column*0+Row*5 pigment {Mica}}
object {tile translate Column*1+Row*5 pigment {Gray01}}
object {tile translate Column*2+Row*5 pigment {DarkGreen1}}
object {tile translate Column*3+Row*5 pigment {Green4}}
object {tile translate Column*4+Row*5 pigment {Green3}}
object {tile translate Column*5+Row*5 pigment {Green2}}
object {tile translate Column*6+Row*5 pigment {Green}}
object {tile translate Column*0+Row*6 pigment {DarkBlue}}
object {tile translate Column*1+Row*6 pigment {DarkEggPlant}}
object {tile translate Column*2+Row*6 pigment {HuntersGreen}}
object {tile translate Column*3+Row*6 pigment {SpringGreen5}}
object {tile translate Column*4+Row*6 pigment {Heiny_Green}}
object {tile translate Column*5+Row*6 pigment {LimeGreen1}}
object {tile translate Column*6+Row*6 pigment {PaleGreen1}}
object {tile translate Column*0+Row*7 pigment {NavyBlue1}}
object {tile translate Column*1+Row*7 pigment {MidnightBlue1}}
object {tile translate Column*2+Row*7 pigment {DodgerBlue4}}
object {tile translate Column*3+Row*7 pigment {Teal}}
object {tile translate Column*4+Row*7 pigment {SpringGreen4}}
object {tile translate Column*5+Row*7 pigment {SpringGreen3}}
object {tile translate Column*6+Row*7 pigment {SpringGreen1}}
object {tile translate Column*0+Row*8 pigment {NewMidnightBlue}}
object {tile translate Column*1+Row*8 pigment {Navy}}
object {tile translate Column*2+Row*8 pigment {DeepSkyBlue4}}
object {tile translate Column*3+Row*8 pigment {Turquoise5}}
object {tile translate Column*4+Row*8 pigment {Cyan4}}
object {tile translate Column*5+Row*8 pigment {MediumSpringGreen1}}
object {tile translate Column*6+Row*8 pigment {SpringGreen}}
object {tile translate Column*0+Row*9 pigment {Blue3}}
object {tile translate Column*1+Row*9 pigment {MediumBlue1}}
object {tile translate Column*2+Row*9 pigment {DodgerBlue3}}
object {tile translate Column*3+Row*9 pigment {DeepSkyBlue3}}
object {tile translate Column*4+Row*9 pigment {Turquoise4}}
object {tile translate Column*5+Row*9 pigment {Cyan3}}
object {tile translate Column*6+Row*9 pigment {Cyan2}}
object {tile translate Column*0+Row*10 pigment {Blue}}
object {tile translate Column*1+Row*10 pigment {Blue1}}
object {tile translate Column*2+Row*10 pigment {SlateBlue}}
object {tile translate Column*3+Row*10 pigment {DodgerBlue2}}
object {tile translate Column*4+Row*10 pigment {DeepSkyBlue2}}
object {tile translate Column*5+Row*10 pigment {DeepSkyBlue1}}
object {tile translate Column*6+Row*10 pigment {Cyan}}
object {tile translate Column*8+Row*5 pigment {VeryDarkBrown}}
object {tile translate Column*9+Row*5 pigment {DarkGreen}}
object {tile translate Column*10+Row*5 pigment {DarkOliveGreen}}
object {tile translate Column*11+Row*5 pigment {ForestGreen1}}
object {tile translate Column*12+Row*5 pigment {ForestGreen}}
object {tile translate Column*13+Row*5 pigment {LimeGreen}}
object {tile translate Column*14+Row*5 pigment {Green1}}
object {tile translate Column*15+Row*5 pigment {Chartreuse3}}
object {tile translate Column*8+Row*6 pigment {MidnightBlue}}
object {tile translate Column*9+Row*6 pigment {DarkSlateGrey}}
object {tile translate Column*10+Row*6 pigment {DarkSlateGray}}
object {tile translate Column*11+Row*6 pigment {MediumSeaGreen}}
object {tile translate Column*12+Row*6 pigment {SeaGreen1}}
object {tile translate Column*13+Row*6 pigment {SeaGreen5}}
object {tile translate Column*14+Row*6 pigment {MediumSeaGreen1}}
object {tile translate Column*15+Row*6 pigment {SpringGreen2}}
object {tile translate Column*8+Row*7 pigment {Navy1}}
object {tile translate Column*9+Row*7 pigment {NavyBlue}}
object {tile translate Column*10+Row*7 pigment {RoyalBlue4}}
object {tile translate Column*11+Row*7 pigment {SeaGreen}}
object {tile translate Column*12+Row*7 pigment {DarkCyan}}
object {tile translate Column*13+Row*7 pigment {SeaGreen4}}
object {tile translate Column*14+Row*7 pigment {MediumAquamarine}}
object {tile translate Column*15+Row*7 pigment {SeaGreen3}}
object {tile translate Column*8+Row*8 pigment {Blue4}}
object {tile translate Column*9+Row*8 pigment {DarkBlue1}}
object {tile translate Column*10+Row*8 pigment {SteelBlue}}
object {tile translate Column*11+Row*8 pigment {SteelBlue5}}
object {tile translate Column*12+Row*8 pigment {LightSeaGreen}}
object {tile translate Column*13+Row*8 pigment {DarkTurquoise1}}
object {tile translate Column*14+Row*8 pigment {Turquoise1}}
object {tile translate Column*15+Row*8 pigment {SeaGreen2}}
object {tile translate Column*8+Row*9 pigment {Blue2}}
object {tile translate Column*9+Row*9 pigment {MediumBlue}}
object {tile translate Column*10+Row*9 pigment {RoyalBlue3}}
object {tile translate Column*11+Row*9 pigment {SkyBlue}}
object {tile translate Column*12+Row*9 pigment {SummerSky}}
object {tile translate Column*13+Row*9 pigment {MediumTurquoise1}}
object {tile translate Column*14+Row*9 pigment {Turquoise3}}
object {tile translate Column*15+Row*9 pigment {CadetBlue2}}
object {tile translate Column*8+Row*10 pigment {NeonBlue}}
object {tile translate Column*9+Row*10 pigment {RoyalBlue}}
object {tile translate Column*10+Row*10 pigment {RoyalBlue2}}
object {tile translate Column*11+Row*10 pigment {DodgerBlue1}}
object {tile translate Column*12+Row*10 pigment {DodgerBlue}}
object {tile translate Column*13+Row*10 pigment {DeepSkyBlue}}
object {tile translate Column*14+Row*10 pigment {Cyan1}}
object {tile translate Column*15+Row*10 pigment {Turquoise2}}
object {tile translate Column*17+Row*5 pigment {BakersChoc}}
object {tile translate Column*18+Row*5 pigment {IndianRed}}
object {tile translate Column*19+Row*5 pigment {DarkBrown}}
object {tile translate Column*20+Row*5 pigment {Chartreuse4}}
object {tile translate Column*21+Row*5 pigment {OliveDrab4}}
object {tile translate Column*22+Row*5 pigment {OliveDrab}}
object {tile translate Column*23+Row*5 pigment {Chartreuse2}}
object {tile translate Column*24+Row*5 pigment {LawnGreen}}
object {tile translate Column*17+Row*6 pigment {Violet}}
object {tile translate Column*18+Row*6 pigment {DimGrey}}
object {tile translate Column*19+Row*6 pigment {DarkOliveGreen1}}
object {tile translate Column*20+Row*6 pigment {PaleGreen5}}
object {tile translate Column*21+Row*6 pigment {MedForestGreen}}
object {tile translate Column*22+Row*6 pigment {DarkOliveGreen5}}
object {tile translate Column*23+Row*6 pigment {Chartreuse}}
object {tile translate Column*24+Row*6 pigment {Chartreuse1}}
object {tile translate Column*17+Row*7 pigment {Indigo}}
object {tile translate Column*18+Row*7 pigment {CornflowerBlue}}
object {tile translate Column*19+Row*7 pigment {SlateBlue5}}
object {tile translate Column*20+Row*7 pigment {DarkGreenCopper}}
object {tile translate Column*21+Row*7 pigment {Aquamarine5}}
object {tile translate Column*22+Row*7 pigment {DarkSlateGray5}}
object {tile translate Column*23+Row*7 pigment {Aquamarine}}
object {tile translate Column*24+Row*7 pigment {PaleGreen4}}
object {tile translate Column*17+Row*8 pigment {Purple4}}
object {tile translate Column*18+Row*8 pigment {DarkSlateBlue1}}
object {tile translate Column*19+Row*8 pigment {MediumPurple5}}
object {tile translate Column*20+Row*8 pigment {SkyBlue5}}
object {tile translate Column*21+Row*8 pigment {SteelBlue1}}
object {tile translate Column*22+Row*8 pigment {CadetBlue}}
object {tile translate Column*23+Row*8 pigment {MediumAquamarine1}}
object {tile translate Column*24+Row*8 pigment {Aquamarine4}}
object {tile translate Column*17+Row*9 pigment {Purple3}}
object {tile translate Column*18+Row*9 pigment {RichBlue}}
object {tile translate Column*19+Row*9 pigment {SlateBlue4}}
object {tile translate Column*20+Row*9 pigment {SteelBlue4}}
object {tile translate Column*21+Row*9 pigment {SteelBlue3}}
object {tile translate Column*22+Row*9 pigment {SkyBlue4}}
object {tile translate Column*23+Row*9 pigment {MediumTurquoise}}
object {tile translate Column*24+Row*9 pigment {Aquamarine3}}
object {tile translate Column*17+Row*10 pigment {MediumSlateBlue}}
object {tile translate Column*18+Row*10 pigment {RoyalBlue1}}
object {tile translate Column*19+Row*10 pigment {SlateBlue1}}
object {tile translate Column*20+Row*10 pigment {CornflowerBlue1}}
object {tile translate Column*21+Row*10 pigment {SteelBlue2}}
object {tile translate Column*22+Row*10 pigment {SkyBlue3}}
object {tile translate Column*23+Row*10 pigment {SkyBlue2}}
object {tile translate Column*24+Row*10 pigment {Aquamarine1}}
object {tile translate Column*26+Row*5 pigment {DarkRed}}
object {tile translate Column*27+Row*5 pigment {SemiSweetChoc}}
object {tile translate Column*28+Row*5 pigment {DarkOrange4}}
object {tile translate Column*29+Row*5 pigment {Gold5}}
object {tile translate Column*30+Row*5 pigment {Yellow3}}
object {tile translate Column*31+Row*5 pigment {MediumSpringGreen}}
object {tile translate Column*32+Row*5 pigment {YellowGreen}}
object {tile translate Column*33+Row*5 pigment {OliveDrab3}}
object {tile translate Column*26+Row*6 pigment {DeepPink4}}
object {tile translate Column*27+Row*6 pigment {Salmon}}
object {tile translate Column*28+Row*6 pigment {Gray35}}
object {tile translate Column*29+Row*6 pigment {DarkWood}}
object {tile translate Column*30+Row*6 pigment {DarkSeaGreen4}}
object {tile translate Column*31+Row*6 pigment {YellowGreen1}}
object {tile translate Column*32+Row*6 pigment {GreenYellow}}
object {tile translate Column*33+Row*6 pigment {GreenYellow1}}
object {tile translate Column*26+Row*7 pigment {RoyalPurple}}
object {tile translate Column*27+Row*7 pigment {DarkOrchid5}}
object {tile translate Column*28+Row*7 pigment {GreenCopper}}
object {tile translate Column*29+Row*7 pigment {CadetBlue5}}
object {tile translate Column*30+Row*7 pigment {PaleTurquoise4}}
object {tile translate Column*31+Row*7 pigment {CadetBlue1}}
object {tile translate Column*32+Row*7 pigment {Light}}
object {tile translate Column*33+Row*7 pigment {PaleGreen3}}
object {tile translate Column*26+Row*8 pigment {DarkSlateBlue}}
object {tile translate Column*27+Row*8 pigment {MediumOrchid5}}
object {tile translate Column*28+Row*8 pigment {LightSkyBlue4}}
object {tile translate Column*29+Row*8 pigment {LightBlue5}}
object {tile translate Column*30+Row*8 pigment {SlateGray}}
object {tile translate Column*31+Row*8 pigment {LightSlateGray}}
object {tile translate Column*32+Row*8 pigment {DarkSlateGray4}}
object {tile translate Column*33+Row*8 pigment {Aquamarine2}}
object {tile translate Column*26+Row*9 pigment {DarkViolet}}
object {tile translate Column*27+Row*9 pigment {BlueViolet1}}
object {tile translate Column*28+Row*9 pigment {SlateBlue3}}
object {tile translate Column*29+Row*9 pigment {DarkTurquoise}}
object {tile translate Column*30+Row*9 pigment {CadetBlue4}}
object {tile translate Column*31+Row*9 pigment {LightSkyBlue3}}
object {tile translate Column*32+Row*9 pigment {SkyBlue1}}
object {tile translate Column*33+Row*9 pigment {DarkSlateGray3}}
object {tile translate Column*26+Row*10 pigment {Purple2}}
object {tile translate Column*27+Row*10 pigment {Purple1}}
object {tile translate Column*28+Row*10 pigment {MediumSlateBlue1}}
object {tile translate Column*29+Row*10 pigment {SlateBlue2}}
object {tile translate Column*30+Row*10 pigment {LightSlateBlue}}
object {tile translate Column*31+Row*10 pigment {LightSkyBlue}}
object {tile translate Column*32+Row*10 pigment {CadetBlue3}}
object {tile translate Column*33+Row*10 pigment {DarkSlateGray2}}
object {tile translate Column*0+Row*12 pigment {Red5}}
object {tile translate Column*1+Row*12 pigment {OrangeRed5}}
object {tile translate Column*2+Row*12 pigment {Orange5}}
object {tile translate Column*3+Row*12 pigment {DarkGldnrod4}}
object {tile translate Column*4+Row*12 pigment {Bronze}}
object {tile translate Column*5+Row*12 pigment {OliveDrab2}}
object {tile translate Column*6+Row*12 pigment {OliveDrab1}}
object {tile translate Column*0+Row*13 pigment {Firebrick4}}
object {tile translate Column*1+Row*13 pigment {IndianRed5}}
object {tile translate Column*2+Row*13 pigment {Tan5}}
object {tile translate Column*3+Row*13 pigment {LightGldnrod4}}
object {tile translate Column*4+Row*13 pigment {Khaki5}}
object {tile translate Column*5+Row*13 pigment {DarkOliveGreen4}}
object {tile translate Column*6+Row*13 pigment {DarkOliveGreen3}}
object {tile translate Column*0+Row*14 pigment {Maroon5}}
object {tile translate Column*1+Row*14 pigment {DarkPurple}}
object {tile translate Column*2+Row*14 pigment {DustyRose}}
object {tile translate Column*3+Row*14 pigment {SlateGray4}}
object {tile translate Column*4+Row*14 pigment {LightCyan4}}
object {tile translate Column*5+Row*14 pigment {DarkSeaGreen}}
object {tile translate Column*6+Row*14 pigment {PaleGreen2}}
object {tile translate Column*0+Row*15 pigment {Magenta4}}
object {tile translate Column*1+Row*15 pigment {Orchid5}}
object {tile translate Column*2+Row*15 pigment {LightSteelBlue5}}
object {tile translate Column*3+Row*15 pigment {Azure4}}
object {tile translate Column*4+Row*15 pigment {Honeydew4}}
object {tile translate Column*5+Row*15 pigment {PaleGreen}}
object {tile translate Column*6+Row*15 pigment {DarkSeaGreen3}}
object {tile translate Column*0+Row*16 pigment {DarkOrchid1}}
object {tile translate Column*1+Row*16 pigment {DarkOrchid}}
object {tile translate Column*2+Row*16 pigment {MediumPurple4}}
object {tile translate Column*3+Row*16 pigment {LightSteelBlue}}
object {tile translate Column*4+Row*16 pigment {LightBlue4}}
object {tile translate Column*5+Row*16 pigment {PaleTurquoise3}}
object {tile translate Column*6+Row*16 pigment {Turquoise}}
object {tile translate Column*0+Row*17 pigment {Purple}}
object {tile translate Column*1+Row*17 pigment {DarkOrchid4}}
object {tile translate Column*2+Row*17 pigment {MediumPurple1}}
object {tile translate Column*3+Row*17 pigment {MediumOrchid}}
object {tile translate Column*4+Row*17 pigment {LightSkyBlue2}}
object {tile translate Column*5+Row*17 pigment {LightSkyBlue1}}
object {tile translate Column*6+Row*17 pigment {PaleTurquoise2}}
object {tile translate Column*8+Row*12 pigment {Scarlet}}
object {tile translate Column*9+Row*12 pigment {Brown5}}
object {tile translate Column*10+Row*12 pigment {Chocolate4}}
object {tile translate Column*11+Row*12 pigment {Goldenrod5}}
object {tile translate Column*12+Row*12 pigment {Sienna}}
object {tile translate Column*13+Row*12 pigment {DarkGldnrod}}
object {tile translate Column*14+Row*12 pigment {Yellow2}}
object {tile translate Column*15+Row*12 pigment {BrightGold}}
object {tile translate Column*8+Row*13 pigment {Firebrick}}
object {tile translate Column*9+Row*13 pigment {Tomato4}}
object {tile translate Column*10+Row*13 pigment {Coral5}}
object {tile translate Column*11+Row*13 pigment {LightSalmon4}}
object {tile translate Column*12+Row*13 pigment {Burlywood4}}
object {tile translate Column*13+Row*13 pigment {Khaki}}
object {tile translate Column*14+Row*13 pigment {Brass}}
object {tile translate Column*15+Row*13 pigment {DarkOliveGreen2}}
object {tile translate Column*8+Row*14 pigment {DarkMagenta}}
object {tile translate Column*9+Row*14 pigment {Maroon}}
object {tile translate Column*10+Row*14 pigment {PaleVioletRed4}}
object {tile translate Column*11+Row*14 pigment {RosyBrown4}}
object {tile translate Column*12+Row*14 pigment {LemonChiffon4}}
object {tile translate Column*13+Row*14 pigment {LightYellow4}}
object {tile translate Column*14+Row*14 pigment {DarkKhaki}}
object {tile translate Column*15+Row*14 pigment {DarkSeaGreen2}}
object {tile translate Column*8+Row*15 pigment {VioletRed5}}
object {tile translate Column*9+Row*15 pigment {HotPink4}}
object {tile translate Column*10+Row*15 pigment {Plum5}}
object {tile translate Column*11+Row*15 pigment {Thistle5}}
object {tile translate Column*12+Row*15 pigment {Gray55}}
object {tile translate Column*13+Row*15 pigment {Ivory4}}
object {tile translate Column*14+Row*15 pigment {LightGray}}
object {tile translate Column*15+Row*15 pigment {DarkSeaGreen1}}
object {tile translate Column*8+Row*16 pigment {Magenta3}}
object {tile translate Column*9+Row*16 pigment {DarkOrchid3}}
object {tile translate Column*10+Row*16 pigment {MediumOrchid4}}
object {tile translate Column*11+Row*16 pigment {MediumPurple3}}
object {tile translate Column*12+Row*16 pigment {SlateGray3}}
object {tile translate Column*13+Row*16 pigment {LightSteelBlue4}}
object {tile translate Column*14+Row*16 pigment {LightBlue1}}
object {tile translate Column*15+Row*16 pigment {PaleTurquoise}}
object {tile translate Column*8+Row*17 pigment {MediumPurple}}
object {tile translate Column*9+Row*17 pigment {DarkOrchid2}}
object {tile translate Column*10+Row*17 pigment {MediumPurple2}}
object {tile translate Column*11+Row*17 pigment {MediumOrchid1}}
object {tile translate Column*12+Row*17 pigment {LightSteelBlue1}}
object {tile translate Column*13+Row*17 pigment {LightBlue3}}
object {tile translate Column*14+Row*17 pigment {PowderBlue}}
object {tile translate Column*15+Row*17 pigment {PaleTurquoise1}}
object {tile translate Column*17+Row*12 pigment {Red4}}
object {tile translate Column*18+Row*12 pigment {Yucca_Brown}}
object {tile translate Column*19+Row*12 pigment {SaddleBrown}}
object {tile translate Column*20+Row*12 pigment {Salmon5}}
object {tile translate Column*21+Row*12 pigment {DarkGldnrod3}}
object {tile translate Column*22+Row*12 pigment {Gold4}}
object {tile translate Column*23+Row*12 pigment {Goldenrod4}}
object {tile translate Column*24+Row*12 pigment {Yellow1}}
object {tile translate Column*17+Row*13 pigment {Brown1}}
object {tile translate Column*18+Row*13 pigment {Brown}}
object {tile translate Column*19+Row*13 pigment {Sienna5}}
object {tile translate Column*20+Row*13 pigment {DarkTan}}
object {tile translate Column*21+Row*13 pigment {Bronze1}}
object {tile translate Column*22+Row*13 pigment {OldGold}}
object {tile translate Column*23+Row*13 pigment {Khaki4}}
object {tile translate Column*24+Row*13 pigment {Goldenrod}}
object {tile translate Column*17+Row*14 pigment {Maroon1}}
object {tile translate Column*18+Row*14 pigment {LightPink4}}
object {tile translate Column*19+Row*14 pigment {Pink5}}
object {tile translate Column*20+Row*14 pigment {PeachPuff4}}
object {tile translate Column*21+Row*14 pigment {Wheat5}}
object {tile translate Column*22+Row*14 pigment {Cornsilk4}}
object {tile translate Column*23+Row*14 pigment {LightGldnrod3}}
object {tile translate Column*24+Row*14 pigment {LemonChiffon3}}
object {tile translate Column*17+Row*15 pigment {MediumVioletRed1}}
object {tile translate Column*18+Row*15 pigment {BlueViolet}}
object {tile translate Column*19+Row*15 pigment {MistyRose4}}
object {tile translate Column*20+Row*15 pigment {LavenderBlush4}}
object {tile translate Column*21+Row*15 pigment {Seashell4}}
object {tile translate Column*22+Row*15 pigment {LightGrey}}
object {tile translate Column*23+Row*15 pigment {LightCyan3}}
object {tile translate Column*24+Row*15 pigment {Honeydew3}}
object {tile translate Column*17+Row*16 pigment {VioletRed}}
object {tile translate Column*18+Row*16 pigment {Maroon4}}
object {tile translate Column*19+Row*16 pigment {Orchid4}}
object {tile translate Column*20+Row*16 pigment {Plum4}}
object {tile translate Column*21+Row*16 pigment {Gray75A}}
object {tile translate Column*22+Row*16 pigment {Gray}}
object {tile translate Column*23+Row*16 pigment {LightBlue}}
object {tile translate Column*24+Row*16 pigment {SlateGray2}}
object {tile translate Column*17+Row*17 pigment {Magenta2}}
object {tile translate Column*18+Row*17 pigment {MediumOrchid3}}
object {tile translate Column*19+Row*17 pigment {Orchid}}
object {tile translate Column*20+Row*17 pigment {Orchid1}}
object {tile translate Column*21+Row*17 pigment {LightSteelBlue3}}
object {tile translate Column*22+Row*17 pigment {SlateGray1}}
object {tile translate Column*23+Row*17 pigment {LightBlue2}}
object {tile translate Column*24+Row*17 pigment {LightSteelBlue2}}
object {tile translate Column*26+Row*12 pigment {Red3}}
object {tile translate Column*27+Row*12 pigment {Firebrick}}
object {tile translate Column*28+Row*12 pigment {OrangeRed4}}
object {tile translate Column*29+Row*12 pigment {DarkOrange3}}
object {tile translate Column*30+Row*12 pigment {Orange4}}
object {tile translate Column*31+Row*12 pigment {Goldenrod1}}
object {tile translate Column*32+Row*12 pigment {Gold3}}
object {tile translate Column*33+Row*12 pigment {Yellow}}
object {tile translate Column*26+Row*13 pigment {Firebrick3}}
object {tile translate Column*27+Row*13 pigment {Brown4}}
object {tile translate Column*28+Row*13 pigment {Sienna1}}
object {tile translate Column*29+Row*13 pigment {Copper}}
object {tile translate Column*30+Row*13 pigment {Peru}}
object {tile translate Column*31+Row*13 pigment {Tan4}}
object {tile translate Column*32+Row*13 pigment {Goldenrod3}}
object {tile translate Column*33+Row*13 pigment {Goldenrod2}}
object {tile translate Column*26+Row*14 pigment {DeepPink3}}
object {tile translate Column*27+Row*14 pigment {VioletRed4}}
object {tile translate Column*28+Row*14 pigment {IndianRed4}}
object {tile translate Column*29+Row*14 pigment {MediumWood}}
object {tile translate Column*30+Row*14 pigment {Bisque4}}
object {tile translate Column*31+Row*14 pigment {Burlywood3}}
object {tile translate Column*32+Row*14 pigment {NavajoWhite3}}
object {tile translate Column*33+Row*14 pigment {Khaki3}}
object {tile translate Column*26+Row*15 pigment {VioletRed1}}
object {tile translate Column*27+Row*15 pigment {HotPink3}}
object {tile translate Column*28+Row*15 pigment {PaleVioletRed3}}
object {tile translate Column*29+Row*15 pigment {RosyBrown}}
object {tile translate Column*30+Row*15 pigment {Pink}}
object {tile translate Column*31+Row*15 pigment {Bisque3}}
object {tile translate Column*32+Row*15 pigment {LightYellow3}}
object {tile translate Column*33+Row*15 pigment {Straw}}
object {tile translate Column*26+Row*16 pigment {Maroon3}}
object {tile translate Column*27+Row*16 pigment {Maroon2}}
object {tile translate Column*28+Row*16 pigment {PaleVioletRed}}
object {tile translate Column*29+Row*16 pigment {Pink4}}
object {tile translate Column*30+Row*16 pigment {Thistle4}}
object {tile translate Column*31+Row*16 pigment {Grey}}
object {tile translate Column*32+Row*16 pigment {Azure3}}
object {tile translate Column*33+Row*16 pigment {LightCyan2}}
object {tile translate Column*26+Row*17 pigment {Magenta}}
object {tile translate Column*27+Row*17 pigment {Magenta1}}
object {tile translate Column*28+Row*17 pigment {MediumOrchid2}}
object {tile translate Column*29+Row*17 pigment {LightPurple}}
object {tile translate Column*30+Row*17 pigment {Plum1}}
object {tile translate Column*31+Row*17 pigment {Quartz}}
object {tile translate Column*32+Row*17 pigment {Azure2}}
object {tile translate Column*33+Row*17 pigment {LightCyan}}
object {tile translate Column*0+Row*19 pigment {Red2}}
object {tile translate Column*1+Row*19 pigment {OrangeRed3}}
object {tile translate Column*2+Row*19 pigment {Chocolate3}}
object {tile translate Column*3+Row*19 pigment {CoolCopper}}
object {tile translate Column*4+Row*19 pigment {DarkGldnrod2}}
object {tile translate Column*5+Row*19 pigment {Gold2}}
object {tile translate Column*6+Row*19 pigment {Gold1}}
object {tile translate Column*0+Row*20 pigment {Crimson}}
object {tile translate Column*1+Row*20 pigment {Tomato3}}
object {tile translate Column*2+Row*20 pigment {Coral4}}
object {tile translate Column*3+Row*20 pigment {Gold}}
object {tile translate Column*4+Row*20 pigment {Tan3}}
object {tile translate Column*5+Row*20 pigment {DarkGldnrod1}}
object {tile translate Column*6+Row*20 pigment {LightGldnrod}}
object {tile translate Column*0+Row*21 pigment {DeepPink2}}
object {tile translate Column*1+Row*21 pigment {IndianRed1}}
object {tile translate Column*2+Row*21 pigment {Salmon4}}
object {tile translate Column*3+Row*21 pigment {LightSalmon3}}
object {tile translate Column*4+Row*21 pigment {Feldspar}}
object {tile translate Column*5+Row*21 pigment {Tan1}}
object {tile translate Column*6+Row*21 pigment {LightGldnrod2}}
object {tile translate Column*0+Row*22 pigment {DeepPink}}
object {tile translate Column*1+Row*22 pigment {VioletRed3}}
object {tile translate Column*2+Row*22 pigment {MediumVioletRed}}
object {tile translate Column*3+Row*22 pigment {LightPink3}}
object {tile translate Column*4+Row*22 pigment {PeachPuff3}}
object {tile translate Column*5+Row*22 pigment {Cornsilk3}}
object {tile translate Column*6+Row*22 pigment {MediumGoldenrod}}
object {tile translate Column*0+Row*23 pigment {Fuchia}}
object {tile translate Column*1+Row*23 pigment {SpicyPink}}
object {tile translate Column*2+Row*23 pigment {HotPink2}}
object {tile translate Column*3+Row*23 pigment {Orchid3}}
object {tile translate Column*4+Row*23 pigment {Gray77}}
object {tile translate Column*5+Row*23 pigment {Gray80}}
object {tile translate Column*6+Row*23 pigment {Honeydew2}}
object {tile translate Column*0+Row*24 pigment {DeepPink1}}
object {tile translate Column*1+Row*24 pigment {Violet1}}
object {tile translate Column*2+Row*24 pigment {Orchid2}}
object {tile translate Column*3+Row*24 pigment {Plum}}
object {tile translate Column*4+Row*24 pigment {Thistle1}}
object {tile translate Column*5+Row*24 pigment {Lavender}}
object {tile translate Column*6+Row*24 pigment {Silver}}
object {tile translate Column*8+Row*19 pigment {Red1}}
object {tile translate Column*9+Row*19 pigment {OrangeRed2}}
object {tile translate Column*10+Row*19 pigment {Chocolate}}
object {tile translate Column*11+Row*19 pigment {DarkOrange2}}
object {tile translate Column*12+Row*19 pigment {Orange3}}
object {tile translate Column*13+Row*19 pigment {Orange2}}
object {tile translate Column*14+Row*19 pigment {Orange1}}
object {tile translate Column*15+Row*19 pigment {DarkOrange}}
object {tile translate Column*8+Row*20 pigment {Firebrick2}}
object {tile translate Column*9+Row*20 pigment {Brown3}}
object {tile translate Column*10+Row*20 pigment {Sienna4}}
object {tile translate Column*11+Row*20 pigment {MandarinOrange}}
object {tile translate Column*12+Row*20 pigment {Sienna3}}
object {tile translate Column*13+Row*20 pigment {Tan2}}
object {tile translate Column*14+Row*20 pigment {SandyBrown}}
object {tile translate Column*15+Row*20 pigment {Khaki1}}
object {tile translate Column*8+Row*21 pigment {OrangeRed}}
object {tile translate Column*9+Row*21 pigment {Brown2}}
object {tile translate Column*10+Row*21 pigment {IndianRed3}}
object {tile translate Column*11+Row*21 pigment {Salmon3}}
object {tile translate Column*12+Row*21 pigment {Tan}}
object {tile translate Column*13+Row*21 pigment {Burlywood}}
object {tile translate Column*14+Row*21 pigment {Burlywood2}}
object {tile translate Column*15+Row*21 pigment {LightGldnrod1}}
object {tile translate Column*8+Row*22 pigment {VioletRed2}}
object {tile translate Column*9+Row*22 pigment {HotPink}}
object {tile translate Column*10+Row*22 pigment {PaleVioletRed2}}
object {tile translate Column*11+Row*22 pigment {LightCoral}}
object {tile translate Column*12+Row*22 pigment {RosyBrown3}}
object {tile translate Column*13+Row*22 pigment {Wheat4}}
object {tile translate Column*14+Row*22 pigment {NavajoWhite2}}
object {tile translate Column*15+Row*22 pigment {PaleGoldenrod}}
object {tile translate Column*8+Row*23 pigment {NeonPink}}
object {tile translate Column*9+Row*23 pigment {HotPink1}}
object {tile translate Column*10+Row*23 pigment {PaleVioletRed1}}
object {tile translate Column*11+Row*23 pigment {LightPink2}}
object {tile translate Column*12+Row*23 pigment {Pink3}}
object {tile translate Column*13+Row*23 pigment {LavenderBlush3}}
object {tile translate Column*14+Row*23 pigment {Gray85}}
object {tile translate Column*15+Row*23 pigment {LightYellow2}}
object {tile translate Column*8+Row*24 pigment {Plum3}}
object {tile translate Column*9+Row*24 pigment {Plum2}}
object {tile translate Column*10+Row*24 pigment {Thistle}}
object {tile translate Column*11+Row*24 pigment {VeryLightPurple}}
object {tile translate Column*12+Row*24 pigment {Thistle3}}
object {tile translate Column*13+Row*24 pigment {LavenderBlush2}}
object {tile translate Column*14+Row*24 pigment {Snow2}}
object {tile translate Column*15+Row*24 pigment {Azure1}}
object {tile translate Column*17+Row*19 pigment {Red}}
object {tile translate Column*18+Row*19 pigment {OrangeRed1}}
object {tile translate Column*19+Row*19 pigment {Chocolate2}}
object {tile translate Column*20+Row*19 pigment {DarkOrange1}}
object {tile translate Column*21+Row*19 pigment {Orange}}
object {tile translate Column*22+Row*19 pigment {Coral}}
object {tile translate Column*23+Row*19 pigment {Chocolate1}}
object {tile translate Column*24+Row*19 pigment {Khaki2}}
object {tile translate Column*17+Row*20 pigment {Firebrick1}}
object {tile translate Column*18+Row*20 pigment {RubyRed}}
object {tile translate Column*19+Row*20 pigment {Tomato2}}
object {tile translate Column*20+Row*20 pigment {Coral3}}
object {tile translate Column*21+Row*20 pigment {Sienna2}}
object {tile translate Column*22+Row*20 pigment {Coral1}}
object {tile translate Column*23+Row*20 pigment {LightSalmon1}}
object {tile translate Column*24+Row*20 pigment {Burlywood1}}
object {tile translate Column*17+Row*21 pigment {Tomato1}}
object {tile translate Column*18+Row*21 pigment {IndianRed2}}
object {tile translate Column*19+Row*21 pigment {Tomato}}
object {tile translate Column*20+Row*21 pigment {Salmon1}}
object {tile translate Column*21+Row*21 pigment {LightSalmon2}}
object {tile translate Column*22+Row*21 pigment {LightSalmon}}
object {tile translate Column*23+Row*21 pigment {NewTan}}
object {tile translate Column*24+Row*21 pigment {NavajoWhite1}}
object {tile translate Column*17+Row*22 pigment {Coral2}}
object {tile translate Column*18+Row*22 pigment {Salmon2}}
object {tile translate Column*19+Row*22 pigment {DarkSalmon}}
object {tile translate Column*20+Row*22 pigment {LightPink1}}
object {tile translate Column*21+Row*22 pigment {RosyBrown2}}
object {tile translate Column*22+Row*22 pigment {LightWood}}
object {tile translate Column*23+Row*22 pigment {Wheat3}}
object {tile translate Column*24+Row*22 pigment {Wheat1}}
object {tile translate Column*17+Row*23 pigment {AntiqueWhite4}}
object {tile translate Column*18+Row*23 pigment {Pink2}}
object {tile translate Column*19+Row*23 pigment {LightPink}}
object {tile translate Column*20+Row*23 pigment {MistyRose3}}
object {tile translate Column*21+Row*23 pigment {Pink1}}
object {tile translate Column*22+Row*23 pigment {RosyBrown1}}
object {tile translate Column*23+Row*23 pigment {AntiqueWhite2}}
object {tile translate Column*24+Row*23 pigment {LemonChiffon1}}
object {tile translate Column*17+Row*24 pigment {Seashell3}}
object {tile translate Column*18+Row*24 pigment {Snow3}}
object {tile translate Column*19+Row*24 pigment {AntiqueWhite3}}
object {tile translate Column*20+Row*24 pigment {MistyRose2}}
object {tile translate Column*21+Row*24 pigment {Thistle2}}
object {tile translate Column*22+Row*24 pigment {MistyRose1}}
object {tile translate Column*23+Row*24 pigment {LavenderBlush1}}
object {tile translate Column*24+Row*24 pigment {Azure}}
object {tile translate Column*26+Row*19 pigment {NavajoWhite4}}
object {tile translate Column*27+Row*19 pigment {PeachPuff2}}
object {tile translate Column*28+Row*19 pigment {Flesh}}
object {tile translate Column*29+Row*19 pigment {NavajoWhite}}
object {tile translate Column*30+Row*19 pigment {Bisque2}}
object {tile translate Column*31+Row*19 pigment {Moccasin}}
object {tile translate Column*32+Row*19 pigment {PeachPuff}}
object {tile translate Column*33+Row*19 pigment {Wheat2}}
object {tile translate Column*26+Row*20 pigment {Ivory3}}
object {tile translate Column*27+Row*20 pigment {PeachPuff1}}
object {tile translate Column*28+Row*20 pigment {Wheat}}
object {tile translate Column*29+Row*20 pigment {Bisque1}}
object {tile translate Column*30+Row*20 pigment {LemonChiffon2}}
object {tile translate Column*31+Row*20 pigment {Bisque}}
object {tile translate Column*32+Row*20 pigment {BlanchedAlmond}}
object {tile translate Column*33+Row*20 pigment {LemonChiffon}}
object {tile translate Column*26+Row*21 pigment {Cornsilk2}}
object {tile translate Column*27+Row*21 pigment {Seashell2}}
object {tile translate Column*28+Row*21 pigment {AntiqueWhite}}
object {tile translate Column*29+Row*21 pigment {PapayaWhip}}
object {tile translate Column*30+Row*21 pigment {MistyRose}}
object {tile translate Column*31+Row*21 pigment {LightGldnrodYlw}}
object {tile translate Column*32+Row*21 pigment {Bone}}
object {tile translate Column*33+Row*21 pigment {AntiqueWhite1}}
object {tile translate Column*26+Row*22 pigment {Ivory2}}
object {tile translate Column*27+Row*22 pigment {Linen}}
object {tile translate Column*28+Row*22 pigment {Beige}}
object {tile translate Column*29+Row*22 pigment {Cornsilk}}
object {tile translate Column*30+Row*22 pigment {Cornsilk1}}
object {tile translate Column*31+Row*22 pigment {OldLace}}
object {tile translate Column*32+Row*22 pigment {LightYellow}}
object {tile translate Column*33+Row*22 pigment {Seashell}}
object {tile translate Column*26+Row*23 pigment {LavenderBlush}}
object {tile translate Column*27+Row*23 pigment {Ivory1}}
object {tile translate Column*28+Row*23 pigment {Honeydew1}}
object {tile translate Column*29+Row*23 pigment {Seashell1}}
object {tile translate Column*30+Row*23 pigment {Gray96}}
object {tile translate Column*31+Row*23 pigment {FloralWhite}}
object {tile translate Column*32+Row*23 pigment {Ivory}}
object {tile translate Column*33+Row*23 pigment {Honeydew}}
object {tile translate Column*26+Row*24 pigment {GhostWhite}}
object {tile translate Column*27+Row*24 pigment {AliceBlue}}
object {tile translate Column*28+Row*24 pigment {Snow}}
object {tile translate Column*29+Row*24 pigment {Snow1}}
object {tile translate Column*30+Row*24 pigment {Gray100}}
object {tile translate Column*31+Row*24 pigment {LightCyan1}}
object {tile translate Column*32+Row*24 pigment {LightYellow1}}
object {tile translate Column*33+Row*24 pigment {MintCream}}

text
{ ttf "cyrvetic.ttf",
  "Kolors.inc demo surely includes color Clear, doesn't it? :)",
    1,0
    scale 0.4
    texture
    {
      pigment { Clear     }
      finish  { ambient 1 }
    }
    translate 11*Column-1.65*Row
  }
