  // By Ken Tyler
  #include "kolors.inc"

  camera {
  location  < 0,  0, -200>
  direction  <0,  0,    1>
  up         <0,  1,    0>
  right    <4/3,  0,    0>
  look_at  <  0,  0,    0>}

  light_source{< 200,   0,-700>color White}
  light_source{<-200,   0,-700>color White}
  light_source{<   0,-200,-700>color White}
  light_source{<   0, 200,-700>color White}

  #declare Til = superellipsoid{<.05,.3>scale<2,2,1>}
  #declare Offset = 4.15

  // You'll probably have to change this to keep pov 3.1 happy
  #declare Fin =
  finish{ambient .6 diffuse .1 reflection .15 phong 1 phong_size 500 brilliance 4
  refraction 1 ior 1.8}

 #declare Row1 = union{
  object{Til translate -y*Offset    pigment{AliceBlue        }finish{Fin}}
  object{Til translate -y*Offset*2  pigment{AntiqueWhite     }finish{Fin}}
  object{Til translate -y*Offset*3  pigment{AntiqueWhite2    }finish{Fin}}
  object{Til translate -y*Offset*4  pigment{AntiqueWhite4    }finish{Fin}}
  object{Til translate -y*Offset*5  pigment{Aquamarine       }finish{Fin}}
  object{Til translate -y*Offset*6  pigment{Aquamarine2      }finish{Fin}}
  object{Til translate  y*0         pigment{Aquamarine4      }finish{Fin}}
  object{Til translate  y*Offset    pigment{Azure            }finish{Fin}}
  object{Til translate  y*Offset*2  pigment{Azure2           }finish{Fin}}
  object{Til translate  y*Offset*3  pigment{Azure4           }finish{Fin}}
  object{Til translate  y*Offset*4  pigment{BakersChoc       }finish{Fin}}
  object{Til translate  y*Offset*5  pigment{Beige            }finish{Fin}}
  object{Til translate  y*Offset*6  pigment{Bisque           }finish{Fin}}
  object{Til translate  y*Offset*7  pigment{Bisque2          }finish{Fin}}
  object{Til translate  y*Offset*8  pigment{Bisque4          }finish{Fin}}
  object{Til translate  y*Offset*9  pigment{BlanchedAlmond   }finish{Fin}}
  object{Til translate  y*Offset*10 pigment{Blue             }finish{Fin}}
  object{Til translate  y*Offset*11 pigment{Blue2            }finish{Fin}}
  object{Til translate  y*Offset*12 pigment{Blue4            }finish{Fin}}
  object{Til translate  y*Offset*13 pigment{BlueViolet       }finish{Fin}}
  object{Til translate  y*Offset*14 pigment{BlueViolet1      }finish{Fin}}
  object{Til translate  y*Offset*15 pigment{Bone             }finish{Fin}}
  object{Til translate  y*Offset*16 pigment{Brass            }finish{Fin}}
  object{Til translate  y*Offset*17 pigment{BrightGold       }finish{Fin}}
  object{Til translate  y*Offset*18 pigment{Bronze           }finish{Fin}}
  object{Til translate  y*Offset*19 pigment{Bronze1          }finish{Fin}}
  object{Til translate  y*Offset*20 pigment{Brown            }finish{Fin}}}
 #declare Row2 = union{
  object{Til translate -y*Offset    pigment{Burlywood        }finish{Fin}}
  object{Til translate -y*Offset*2  pigment{Burlywood2       }finish{Fin}}
  object{Til translate -y*Offset*3  pigment{Burlywood4       }finish{Fin}}
  object{Til translate -y*Offset*4  pigment{CadetBlue        }finish{Fin}}
  object{Til translate -y*Offset*5  pigment{CadetBlue2       }finish{Fin}}
  object{Til translate -y*Offset*6  pigment{CadetBlue4       }finish{Fin}}
  object{Til translate  y*0         pigment{Chartreuse       }finish{Fin}}
  object{Til translate  y*Offset    pigment{Chartreuse2      }finish{Fin}}
  object{Til translate  y*Offset*2  pigment{Chartreuse4      }finish{Fin}}
  object{Til translate  y*Offset*3  pigment{Chocolate        }finish{Fin}}
  object{Til translate  y*Offset*4  pigment{Chocolate2       }finish{Fin}}
  object{Til translate  y*Offset*5  pigment{Chocolate4       }finish{Fin}}
  object{Til translate  y*Offset*6  pigment{CoolCopper       }finish{Fin}}
  object{Til translate  y*Offset*7  pigment{Copper           }finish{Fin}}
  object{Til translate  y*Offset*8  pigment{Coral            }finish{Fin}}
  object{Til translate  y*Offset*9  pigment{Coral2           }finish{Fin}}
  object{Til translate  y*Offset*10 pigment{Coral4           }finish{Fin}}
  object{Til translate  y*Offset*11 pigment{CornflowerBlue   }finish{Fin}}
  object{Til translate  y*Offset*12 pigment{CornflowerBlue1  }finish{Fin}}
  object{Til translate  y*Offset*13 pigment{Cornsilk         }finish{Fin}}
  object{Til translate  y*Offset*14 pigment{Cornsilk2        }finish{Fin}}
  object{Til translate  y*Offset*15 pigment{Cornsilk4        }finish{Fin}}
  object{Til translate  y*Offset*16 pigment{Cyan             }finish{Fin}}
  object{Til translate  y*Offset*17 pigment{Cyan2            }finish{Fin}}
  object{Til translate  y*Offset*18 pigment{Cyan4            }finish{Fin}}
  object{Til translate  y*Offset*19 pigment{DarkBlue         }finish{Fin}}
  object{Til translate  y*Offset*20 pigment{DarkBlue1        }finish{Fin}}}
 #declare Row3 = union{
  object{Til translate -y*Offset    pigment{DarkBrown        }finish{Fin}}
  object{Til translate -y*Offset*2  pigment{DarkCyan         }finish{Fin}}
  object{Til translate -y*Offset*3  pigment{DarkGldnrod      }finish{Fin}}
  object{Til translate -y*Offset*4  pigment{DarkGldnrod2     }finish{Fin}}
  object{Til translate -y*Offset*5  pigment{DarkGldnrod4     }finish{Fin}}
  object{Til translate -y*Offset*6  pigment{DarkGreen        }finish{Fin}}
  object{Til translate  y*0         pigment{DarkGreen1       }finish{Fin}}
  object{Til translate  y*Offset    pigment{DarkGreenCopper  }finish{Fin}}
  object{Til translate  y*Offset*2  pigment{DarkKhaki        }finish{Fin}}
  object{Til translate  y*Offset*3  pigment{DarkMagenta      }finish{Fin}}
  object{Til translate  y*Offset*4  pigment{DarkOliveGreen   }finish{Fin}}
  object{Til translate  y*Offset*5  pigment{DarkOliveGreen2  }finish{Fin}}
  object{Til translate  y*Offset*6  pigment{DarkOliveGreen4  }finish{Fin}}
  object{Til translate  y*Offset*7  pigment{DarkOrange       }finish{Fin}}
  object{Til translate  y*Offset*8  pigment{DarkOrange2      }finish{Fin}}
  object{Til translate  y*Offset*9  pigment{DarkOrange4      }finish{Fin}}
  object{Til translate  y*Offset*10 pigment{DarkOrchid       }finish{Fin}}
  object{Til translate  y*Offset*11 pigment{DarkOrchid2      }finish{Fin}}
  object{Til translate  y*Offset*12 pigment{DarkOrchid4      }finish{Fin}}
  object{Til translate  y*Offset*13 pigment{DarkPurple       }finish{Fin}}
  object{Til translate  y*Offset*14 pigment{DarkRed          }finish{Fin}}
  object{Til translate  y*Offset*15 pigment{DarkSalmon       }finish{Fin}}
  object{Til translate  y*Offset*16 pigment{DarkSeaGreen     }finish{Fin}}
  object{Til translate  y*Offset*17 pigment{DarkSeaGreen2    }finish{Fin}}
  object{Til translate  y*Offset*18 pigment{DarkSeaGreen4    }finish{Fin}}
  object{Til translate  y*Offset*19 pigment{DarkSlateBlue    }finish{Fin}}
  object{Til translate  y*Offset*20 pigment{DarkSlateBlue1   }finish{Fin}}}
 #declare Row4 = union{
  object{Til translate -y*Offset    pigment{DarkSlateGray    }finish{Fin}}
  object{Til translate -y*Offset*2  pigment{DarkSlateGray2   }finish{Fin}}
  object{Til translate -y*Offset*3  pigment{DarkSlateGray4   }finish{Fin}}
  object{Til translate -y*Offset*4  pigment{DarkTan          }finish{Fin}}
  object{Til translate -y*Offset*5  pigment{DarkTurquoise    }finish{Fin}}
  object{Til translate -y*Offset*6  pigment{DarkTurquoise1   }finish{Fin}}
  object{Til translate  y*0         pigment{DarkViolet       }finish{Fin}}
  object{Til translate  y*Offset    pigment{DarkWood         }finish{Fin}}
  object{Til translate  y*Offset*2  pigment{DeepPink         }finish{Fin}}
  object{Til translate  y*Offset*3  pigment{DeepPink2        }finish{Fin}}
  object{Til translate  y*Offset*4  pigment{DeepPink4        }finish{Fin}}
  object{Til translate  y*Offset*5  pigment{DeepSkyBlue      }finish{Fin}}
  object{Til translate  y*Offset*6  pigment{DeepSkyBlue2     }finish{Fin}}
  object{Til translate  y*Offset*7  pigment{DeepSkyBlue4     }finish{Fin}}
  object{Til translate  y*Offset*8  pigment{DodgerBlue       }finish{Fin}}
  object{Til translate  y*Offset*9  pigment{DodgerBlue2      }finish{Fin}}
  object{Til translate  y*Offset*10 pigment{DodgerBlue4      }finish{Fin}}
  object{Til translate  y*Offset*11 pigment{DustyRose        }finish{Fin}}
  object{Til translate  y*Offset*12 pigment{Feldspar         }finish{Fin}}
  object{Til translate  y*Offset*13 pigment{Firebrick        }finish{Fin}}
  object{Til translate  y*Offset*14 pigment{Firebrick2       }finish{Fin}}
  object{Til translate  y*Offset*15 pigment{Firebrick4       }finish{Fin}}
  object{Til translate  y*Offset*16 pigment{Flesh            }finish{Fin}}
  object{Til translate  y*Offset*17 pigment{FloralWhite      }finish{Fin}}
  object{Til translate  y*Offset*18 pigment{ForestGreen      }finish{Fin}}
  object{Til translate  y*Offset*19 pigment{ForestGreen1     }finish{Fin}}
  object{Til translate  y*Offset*20 pigment{Gainsboro        }finish{Fin}}}
 #declare Row5 = union{
  object{Til translate -y*Offset    pigment{GhostWhite       }finish{Fin}}
  object{Til translate -y*Offset*2  pigment{Gold             }finish{Fin}}
  object{Til translate -y*Offset*3  pigment{Gold2            }finish{Fin}}
  object{Til translate -y*Offset*4  pigment{Gold4            }finish{Fin}}
  object{Til translate -y*Offset*5  pigment{Goldenrod        }finish{Fin}}
  object{Til translate -y*Offset*6  pigment{Goldenrod2       }finish{Fin}}
  object{Til translate  y*0         pigment{Goldenrod4       }finish{Fin}}
  object{Til translate  y*Offset    pigment{Green            }finish{Fin}}
  object{Til translate  y*Offset*2  pigment{Green2           }finish{Fin}}
  object{Til translate  y*Offset*3  pigment{Green4           }finish{Fin}}
  object{Til translate  y*Offset*4  pigment{GreenCopper      }finish{Fin}}
  object{Til translate  y*Offset*5  pigment{GreenYellow      }finish{Fin}}
  object{Til translate  y*Offset*6  pigment{GreenYellow1     }finish{Fin}}
  object{Til translate  y*Offset*7  pigment{Heiny_Green      }finish{Fin}}
  object{Til translate  y*Offset*8  pigment{Honeydew         }finish{Fin}}
  object{Til translate  y*Offset*9  pigment{Honeydew2        }finish{Fin}}
  object{Til translate  y*Offset*10 pigment{Honeydew4        }finish{Fin}}
  object{Til translate  y*Offset*11 pigment{HotPink          }finish{Fin}}
  object{Til translate  y*Offset*12 pigment{HotPink2         }finish{Fin}}
  object{Til translate  y*Offset*13 pigment{HotPink4         }finish{Fin}}
  object{Til translate  y*Offset*14 pigment{HuntersGreen     }finish{Fin}}
  object{Til translate  y*Offset*15 pigment{IndianRed        }finish{Fin}}
  object{Til translate  y*Offset*16 pigment{IndianRed2       }finish{Fin}}
  object{Til translate  y*Offset*17 pigment{IndianRed4       }finish{Fin}}
  object{Til translate  y*Offset*18 pigment{Ivory            }finish{Fin}}
  object{Til translate  y*Offset*19 pigment{Ivory2           }finish{Fin}}
  object{Til translate  y*Offset*20 pigment{Ivory4           }finish{Fin}}}
 #declare Row6 = union{
  object{Til translate -y*Offset    pigment{Khaki            }finish{Fin}}
  object{Til translate -y*Offset*2  pigment{Khaki2           }finish{Fin}}
  object{Til translate -y*Offset*3  pigment{Khaki4           }finish{Fin}}
  object{Til translate -y*Offset*4  pigment{Lavender         }finish{Fin}}
  object{Til translate -y*Offset*5  pigment{LavenderBlush    }finish{Fin}}
  object{Til translate -y*Offset*6  pigment{LavenderBlush2   }finish{Fin}}
  object{Til translate  y*0         pigment{LavenderBlush4   }finish{Fin}}
  object{Til translate  y*Offset    pigment{LawnGreen        }finish{Fin}}
  object{Til translate  y*Offset*2  pigment{LemonChiffon     }finish{Fin}}
  object{Til translate  y*Offset*3  pigment{LemonChiffon2    }finish{Fin}}
  object{Til translate  y*Offset*4  pigment{LemonChiffon4    }finish{Fin}}
  object{Til translate  y*Offset*5  pigment{Light            }finish{Fin}}
  object{Til translate  y*Offset*6  pigment{LightBlue        }finish{Fin}}
  object{Til translate  y*Offset*7  pigment{LightBlue2       }finish{Fin}}
  object{Til translate  y*Offset*8  pigment{LightBlue4       }finish{Fin}}
  object{Til translate  y*Offset*9  pigment{LightCoral       }finish{Fin}}
  object{Til translate  y*Offset*10 pigment{LightCyan        }finish{Fin}}
  object{Til translate  y*Offset*11 pigment{LightCyan2       }finish{Fin}}
  object{Til translate  y*Offset*12 pigment{LightCyan4       }finish{Fin}}
  object{Til translate  y*Offset*13 pigment{LightGldnrod     }finish{Fin}}
  object{Til translate  y*Offset*14 pigment{LightGldnrod2    }finish{Fin}}
  object{Til translate  y*Offset*15 pigment{LightGldnrod4    }finish{Fin}}
  object{Til translate  y*Offset*16 pigment{LightGldnrodYlw  }finish{Fin}}
  object{Til translate  y*Offset*17 pigment{LightPink        }finish{Fin}}
  object{Til translate  y*Offset*18 pigment{LightPink2       }finish{Fin}}
  object{Til translate  y*Offset*19 pigment{LightPink4       }finish{Fin}}
  object{Til translate  y*Offset*20 pigment{LightPurple      }finish{Fin}}}
 #declare Row7 = union{
  object{Til translate -y*Offset    pigment{LightSalmon      }finish{Fin}}
  object{Til translate -y*Offset*2  pigment{LightSalmon      }finish{Fin}}
  object{Til translate -y*Offset*3  pigment{LightSalmon      }finish{Fin}}
  object{Til translate -y*Offset*4  pigment{LightSeaGreen    }finish{Fin}}
  object{Til translate -y*Offset*5  pigment{LightSkyBlue     }finish{Fin}}
  object{Til translate -y*Offset*6  pigment{LightSkyBlue     }finish{Fin}}
  object{Til translate  y*0         pigment{LightSkyBlue     }finish{Fin}}
  object{Til translate  y*Offset    pigment{LightSlateBlue   }finish{Fin}}
  object{Til translate  y*Offset*2  pigment{LightSlateGray   }finish{Fin}}
  object{Til translate  y*Offset*3  pigment{LightSteelBlue   }finish{Fin}}
  object{Til translate  y*Offset*4  pigment{LightSteelBlue   }finish{Fin}}
  object{Til translate  y*Offset*5  pigment{LightSteelBlue   }finish{Fin}}
  object{Til translate  y*Offset*6  pigment{LightYellow      }finish{Fin}}
  object{Til translate  y*Offset*7  pigment{LightYellow      }finish{Fin}}
  object{Til translate  y*Offset*8  pigment{LightYellow      }finish{Fin}}
  object{Til translate  y*Offset*9  pigment{LightWood        }finish{Fin}}
  object{Til translate  y*Offset*10 pigment{LimeGreen        }finish{Fin}}
  object{Til translate  y*Offset*11 pigment{LimeGreen        }finish{Fin}}
  object{Til translate  y*Offset*12 pigment{Linen            }finish{Fin}}
  object{Til translate  y*Offset*13 pigment{Magenta          }finish{Fin}}
  object{Til translate  y*Offset*14 pigment{Magenta          }finish{Fin}}
  object{Til translate  y*Offset*15 pigment{Magenta          }finish{Fin}}
  object{Til translate  y*Offset*16 pigment{MandarinOrange   }finish{Fin}}
  object{Til translate  y*Offset*17 pigment{Maroon           }finish{Fin}}
  object{Til translate  y*Offset*18 pigment{Maroon1          }finish{Fin}}
  object{Til translate  y*Offset*19 pigment{Maroon3          }finish{Fin}}
  object{Til translate  y*Offset*20 pigment{Maroon5          }finish{Fin}}}
 #declare Row8 =
  union{
  object{Til translate -y*Offset    pigment{MediumAquamarine }finish{Fin}}
  object{Til translate -y*Offset*2  pigment{MediumAquamarine1}finish{Fin}}
  object{Til translate -y*Offset*3  pigment{MediumBlue       }finish{Fin}}
  object{Til translate -y*Offset*4  pigment{MediumBlue1      }finish{Fin}}
  object{Til translate -y*Offset*5  pigment{MedForestGreen   }finish{Fin}}
  object{Til translate -y*Offset*6  pigment{MediumGoldenrod  }finish{Fin}}
  object{Til translate  y*0         pigment{MediumOrchid     }finish{Fin}}
  object{Til translate  y*Offset    pigment{MediumOrchid2    }finish{Fin}}
  object{Til translate  y*Offset*2  pigment{MediumOrchid4    }finish{Fin}}
  object{Til translate  y*Offset*3  pigment{MediumPurple     }finish{Fin}}
  object{Til translate  y*Offset*4  pigment{MediumPurple2    }finish{Fin}}
  object{Til translate  y*Offset*5  pigment{MediumPurple4    }finish{Fin}}
  object{Til translate  y*Offset*6  pigment{MediumSeaGreen   }finish{Fin}}
  object{Til translate  y*Offset*7  pigment{MediumSeaGreen1  }finish{Fin}}
  object{Til translate  y*Offset*8  pigment{MediumSlateBlue  }finish{Fin}}
  object{Til translate  y*Offset*9  pigment{MediumSlateBlue1 }finish{Fin}}
  object{Til translate  y*Offset*10 pigment{MediumSpringGreen}finish{Fin}}
  object{Til translate  y*Offset*11 pigment{MediumSpringGreen1}finish{Fin}}
  object{Til translate  y*Offset*12 pigment{MediumTurquoise  }finish{Fin}}
  object{Til translate  y*Offset*13 pigment{MediumTurquoise1 }finish{Fin}}
  object{Til translate  y*Offset*14 pigment{MediumVioletRed  }finish{Fin}}
  object{Til translate  y*Offset*15 pigment{MediumVioletRed1 }finish{Fin}}
  object{Til translate  y*Offset*16 pigment{MediumWood       }finish{Fin}}
  object{Til translate  y*Offset*17 pigment{MidnightBlue     }finish{Fin}}
  object{Til translate  y*Offset*18 pigment{MidnightBlue1    }finish{Fin}}
  object{Til translate  y*Offset*19 pigment{MintCream        }finish{Fin}}
  object{Til translate  y*Offset*20 pigment{Moccasin         }finish{Fin}}}
 #declare Row9 = union{
  object{Til translate -y*Offset    pigment{MistyRose        }finish{Fin}}
  object{Til translate -y*Offset*2  pigment{MistyRose2       }finish{Fin}}
  object{Til translate -y*Offset*3  pigment{MistyRose4       }finish{Fin}}
  object{Til translate -y*Offset*4  pigment{NavajoWhite      }finish{Fin}}
  object{Til translate -y*Offset*5  pigment{NavajoWhite2     }finish{Fin}}
  object{Til translate -y*Offset*6  pigment{NavajoWhite4     }finish{Fin}}
  object{Til translate  y*0         pigment{Navy             }finish{Fin}}
  object{Til translate  y*Offset    pigment{Navy1            }finish{Fin}}
  object{Til translate  y*Offset*2  pigment{NavyBlue         }finish{Fin}}
  object{Til translate  y*Offset*3  pigment{NavyBlue1        }finish{Fin}}
  object{Til translate  y*Offset*4  pigment{NeonBlue         }finish{Fin}}
  object{Til translate  y*Offset*5  pigment{NeonPink         }finish{Fin}}
  object{Til translate  y*Offset*6  pigment{NewMidnightBlue  }finish{Fin}}
  object{Til translate  y*Offset*7  pigment{NewTan           }finish{Fin}}
  object{Til translate  y*Offset*8  pigment{OldGold          }finish{Fin}}
  object{Til translate  y*Offset*9  pigment{OldLace          }finish{Fin}}
  object{Til translate  y*Offset*10 pigment{OliveDrab        }finish{Fin}}
  object{Til translate  y*Offset*11 pigment{OliveDrab2       }finish{Fin}}
  object{Til translate  y*Offset*12 pigment{OliveDrab4       }finish{Fin}}
  object{Til translate  y*Offset*13 pigment{Orange           }finish{Fin}}
  object{Til translate  y*Offset*14 pigment{Orange2          }finish{Fin}}
  object{Til translate  y*Offset*15 pigment{Orange4          }finish{Fin}}
  object{Til translate  y*Offset*16 pigment{OrangeRed        }finish{Fin}}
  object{Til translate  y*Offset*17 pigment{OrangeRed2       }finish{Fin}}
  object{Til translate  y*Offset*18 pigment{OrangeRed4       }finish{Fin}}
  object{Til translate  y*Offset*19 pigment{PaleGoldenrod    }finish{Fin}}
  object{Til translate  y*Offset*20 pigment{PapayaWhip       }finish{Fin}}}
 #declare Row10 = union{
  object{Til translate -y*Offset    pigment{PaleGreen        }finish{Fin}}
  object{Til translate -y*Offset*2  pigment{PaleGreen2       }finish{Fin}}
  object{Til translate -y*Offset*3  pigment{PaleGreen4       }finish{Fin}}
  object{Til translate -y*Offset*4  pigment{PaleGreen5       }finish{Fin}}
  object{Til translate -y*Offset*5  pigment{PaleTurquoise    }finish{Fin}}
  object{Til translate -y*Offset*6  pigment{PaleTurquoise1   }finish{Fin}}
  object{Til translate  y*0         pigment{PaleTurquoise2   }finish{Fin}}
  object{Til translate  y*Offset    pigment{PaleTurquoise3   }finish{Fin}}
  object{Til translate  y*Offset*2  pigment{PaleTurquoise4   }finish{Fin}}
  object{Til translate  y*Offset*3  pigment{PaleVioletRed    }finish{Fin}}
  object{Til translate  y*Offset*4  pigment{PaleVioletRed2   }finish{Fin}}
  object{Til translate  y*Offset*5  pigment{PaleVioletRed4   }finish{Fin}}
  object{Til translate  y*Offset*6  pigment{PeachPuff        }finish{Fin}}
  object{Til translate  y*Offset*7  pigment{PeachPuff2       }finish{Fin}}
  object{Til translate  y*Offset*8  pigment{PeachPuff4       }finish{Fin}}
  object{Til translate  y*Offset*9  pigment{Peru             }finish{Fin}}
  object{Til translate  y*Offset*10 pigment{Pink             }finish{Fin}}
  object{Til translate  y*Offset*11 pigment{Pink2            }finish{Fin}}
  object{Til translate  y*Offset*12 pigment{Pink4            }finish{Fin}}
  object{Til translate  y*Offset*13 pigment{Plum             }finish{Fin}}
  object{Til translate  y*Offset*14 pigment{Plum2            }finish{Fin}}
  object{Til translate  y*Offset*15 pigment{Plum4            }finish{Fin}}
  object{Til translate  y*Offset*16 pigment{PowderBlue       }finish{Fin}}
  object{Til translate  y*Offset*17 pigment{Purple           }finish{Fin}}
  object{Til translate  y*Offset*18 pigment{Purple2          }finish{Fin}}
  object{Til translate  y*Offset*19 pigment{Purple4          }finish{Fin}}
  object{Til translate  y*Offset*20 pigment{Quartz           }finish{Fin}}}
 #declare Row11 = union{
  object{Til translate -y*Offset    pigment{Red              }finish{Fin}}
  object{Til translate -y*Offset*2  pigment{Red2             }finish{Fin}}
  object{Til translate -y*Offset*3  pigment{Red4             }finish{Fin}}
  object{Til translate -y*Offset*4  pigment{RichBlue         }finish{Fin}}
  object{Til translate -y*Offset*5  pigment{RosyBrown        }finish{Fin}}
  object{Til translate -y*Offset*6  pigment{RosyBrown2       }finish{Fin}}
  object{Til translate  y*0         pigment{RosyBrown4       }finish{Fin}}
  object{Til translate  y*Offset    pigment{RoyalBlue        }finish{Fin}}
  object{Til translate  y*Offset*2  pigment{RoyalBlue2       }finish{Fin}}
  object{Til translate  y*Offset*3  pigment{RoyalBlue4       }finish{Fin}}
  object{Til translate  y*Offset*4  pigment{RoyalPurple      }finish{Fin}}
  object{Til translate  y*Offset*5  pigment{RubyRed          }finish{Fin}}
  object{Til translate  y*Offset*6  pigment{SaddleBrown      }finish{Fin}}
  object{Til translate  y*Offset*7  pigment{Salmon           }finish{Fin}}
  object{Til translate  y*Offset*8  pigment{Salmon2          }finish{Fin}}
  object{Til translate  y*Offset*9  pigment{Salmon4          }finish{Fin}}
  object{Til translate  y*Offset*10 pigment{SandyBrown       }finish{Fin}}
  object{Til translate  y*Offset*11 pigment{Scarlet          }finish{Fin}}
  object{Til translate  y*Offset*12 pigment{SemiSweetChoc    }finish{Fin}}
  object{Til translate  y*Offset*13 pigment{SeaGreen         }finish{Fin}}
  object{Til translate  y*Offset*14 pigment{SeaGreen2        }finish{Fin}}
  object{Til translate  y*Offset*15 pigment{SeaGreen4        }finish{Fin}}
  object{Til translate  y*Offset*16 pigment{Seashell         }finish{Fin}}
  object{Til translate  y*Offset*17 pigment{Seashell2        }finish{Fin}}
  object{Til translate  y*Offset*18 pigment{Seashell4        }finish{Fin}}
  object{Til translate  y*Offset*19 pigment{Silver           }finish{Fin}}
  object{Til translate  y*Offset*20 pigment{SpicyPink        }finish{Fin}}}
  #declare Row12 =
  union{
  object{Til translate -y*Offset    pigment{Sienna           }finish{Fin}}
  object{Til translate -y*Offset*2  pigment{Sienna2          }finish{Fin}}
  object{Til translate -y*Offset*3  pigment{Sienna4          }finish{Fin}}
  object{Til translate -y*Offset*4  pigment{SkyBlue          }finish{Fin}}
  object{Til translate -y*Offset*5  pigment{SkyBlue2         }finish{Fin}}
  object{Til translate -y*Offset*6  pigment{SkyBlue4         }finish{Fin}}
  object{Til translate  y*0         pigment{SlateBlue        }finish{Fin}}
  object{Til translate  y*Offset    pigment{SlateBlue2       }finish{Fin}}
  object{Til translate  y*Offset*2  pigment{SlateBlue4       }finish{Fin}}
  object{Til translate  y*Offset*3  pigment{SlateGray        }finish{Fin}}
  object{Til translate  y*Offset*4  pigment{SlateGray2       }finish{Fin}}
  object{Til translate  y*Offset*5  pigment{SlateGray4       }finish{Fin}}
  object{Til translate  y*Offset*6  pigment{Snow             }finish{Fin}}
  object{Til translate  y*Offset*7  pigment{Snow2            }finish{Fin}}
  object{Til translate  y*Offset*8  pigment{Snow4            }finish{Fin}}
  object{Til translate  y*Offset*9  pigment{SpringGreen      }finish{Fin}}
  object{Til translate  y*Offset*10 pigment{SpringGreen2     }finish{Fin}}
  object{Til translate  y*Offset*11 pigment{SpringGreen4     }finish{Fin}}
  object{Til translate  y*Offset*12 pigment{SteelBlue        }finish{Fin}}
  object{Til translate  y*Offset*13 pigment{SteelBlue2       }finish{Fin}}
  object{Til translate  y*Offset*14 pigment{SteelBlue4       }finish{Fin}}
  object{Til translate  y*Offset*15 pigment{Straw            }finish{Fin}}
  object{Til translate  y*Offset*16 pigment{SummerSky        }finish{Fin}}
  object{Til translate  y*Offset*17 pigment{Tan              }finish{Fin}}
  object{Til translate  y*Offset*18 pigment{Tan2             }finish{Fin}}
  object{Til translate  y*Offset*19 pigment{Tan4             }finish{Fin}}
  object{Til translate  y*Offset*20 pigment{VeryDarkBrown    }finish{Fin}}}
 #declare Row13 =
  union{
  object{Til translate -y*Offset    pigment{Thistle          }finish{Fin}}
  object{Til translate -y*Offset*2  pigment{Thistle2         }finish{Fin}}
  object{Til translate -y*Offset*3  pigment{Thistle4         }finish{Fin}}
  object{Til translate -y*Offset*4  pigment{Tomato           }finish{Fin}}
  object{Til translate -y*Offset*5  pigment{Tomato2          }finish{Fin}}
  object{Til translate -y*Offset*6  pigment{Tomato4          }finish{Fin}}
  object{Til translate  y*0         pigment{Turquoise        }finish{Fin}}
  object{Til translate  y*Offset    pigment{Turquoise2       }finish{Fin}}
  object{Til translate  y*Offset*2  pigment{Turquoise4       }finish{Fin}}
  object{Til translate  y*Offset*3  pigment{VeryLightPurple  }finish{Fin}}
  object{Til translate  y*Offset*4  pigment{Violet           }finish{Fin}}
  object{Til translate  y*Offset*5  pigment{Violet1          }finish{Fin}}
  object{Til translate  y*Offset*6  pigment{VioletRed        }finish{Fin}}
  object{Til translate  y*Offset*7  pigment{VioletRed2       }finish{Fin}}
  object{Til translate  y*Offset*8  pigment{VioletRed4       }finish{Fin}}
  object{Til translate  y*Offset*9  pigment{Wheat            }finish{Fin}}
  object{Til translate  y*Offset*10 pigment{Wheat1           }finish{Fin}}
  object{Til translate  y*Offset*11 pigment{Wheat3           }finish{Fin}}
  object{Til translate  y*Offset*12 pigment{Wheat4           }finish{Fin}}
  object{Til translate  y*Offset*13 pigment{WhiteSmoke       }finish{Fin}}
  object{Til translate  y*Offset*14 pigment{Yellow           }finish{Fin}}
  object{Til translate  y*Offset*15 pigment{Yellow1          }finish{Fin}}
  object{Til translate  y*Offset*16 pigment{Yellow2          }finish{Fin}}
  object{Til translate  y*Offset*17 pigment{Yellow3          }finish{Fin}}
  object{Til translate  y*Offset*18 pigment{YellowGreen      }finish{Fin}}
  object{Til translate  y*Offset*19 pigment{YellowGreen1     }finish{Fin}}
  object{Til translate  y*Offset*20 pigment{Yucca_Brown      }finish{Fin}}}
 #declare Row14 =
  union{
  object{Til translate -y*Offset    pigment{Bisque3          }finish{Fin}}
  object{Til translate -y*Offset*2  pigment{Burlywood3       }finish{Fin}}
  object{Til translate -y*Offset*3  pigment{CadetBlue3       }finish{Fin}}
  object{Til translate -y*Offset*4  pigment{Chartreuse3      }finish{Fin}}
  object{Til translate -y*Offset*5  pigment{Chocolate3       }finish{Fin}}
  object{Til translate -y*Offset*6  pigment{Coral5           }finish{Fin}}
  object{Til translate  y*0         pigment{Cornsilk3        }finish{Fin}}
  object{Til translate  y*Offset    pigment{DarkOliveGreen5  }finish{Fin}}
  object{Til translate  y*Offset*2  pigment{DarkOrange3      }finish{Fin}}
  object{Til translate  y*Offset*3  pigment{DarkOrchid5      }finish{Fin}}
  object{Til translate  y*Offset*4  pigment{DarkSlateGray5   }finish{Fin}}
  object{Til translate  y*Offset*5  pigment{DeepPink3        }finish{Fin}}
  object{Til translate  y*Offset*6  pigment{DeepSkyBlue3     }finish{Fin}}
  object{Til translate  y*Offset*7  pigment{DodgerBlue3      }finish{Fin}}
  object{Til translate  y*Offset*8  pigment{Firebrick3       }finish{Fin}}
  object{Til translate  y*Offset*9  pigment{Gainsboro        }finish{Fin}}
  object{Til translate  y*Offset*10 pigment{Gold5            }finish{Fin}}
  object{Til translate  y*Offset*11 pigment{Green3           }finish{Fin}}
  object{Til translate  y*Offset*12 pigment{OliveDrab        }finish{Fin}}
  object{Til translate  y*Offset*13 pigment{OliveDrab1       }finish{Fin}}
  object{Til translate  y*Offset*14 pigment{OliveDrab2       }finish{Fin}}
  object{Til translate  y*Offset*15 pigment{OliveDrab3       }finish{Fin}}
  object{Til translate  y*Offset*16 pigment{OliveDrab4       }finish{Fin}}
  object{Til translate  y*Offset*17 pigment{HotPink1         }finish{Fin}}
  object{Til translate  y*Offset*18 pigment{HotPink2         }finish{Fin}}
  object{Til translate  y*Offset*19 pigment{HotPink3         }finish{Fin}}
  object{Til translate  y*Offset*20 pigment{HotPink4         }finish{Fin}}}
 #declare Row15 = union{
  object{Til translate -y*Offset    pigment{Honeydew         }finish{Fin}}
  object{Til translate -y*Offset*2  pigment{Honeydew1        }finish{Fin}}
  object{Til translate -y*Offset*3  pigment{Honeydew2        }finish{Fin}}
  object{Til translate -y*Offset*4  pigment{Honeydew3        }finish{Fin}}
  object{Til translate -y*Offset*5  pigment{Honeydew4        }finish{Fin}}
  object{Til translate -y*Offset*6  pigment{IndianRed        }finish{Fin}}
  object{Til translate  y*0         pigment{IndianRed1       }finish{Fin}}
  object{Til translate  y*Offset    pigment{IndianRed2       }finish{Fin}}
  object{Til translate  y*Offset*2  pigment{IndianRed3       }finish{Fin}}
  object{Til translate  y*Offset*3  pigment{IndianRed4       }finish{Fin}}
  object{Til translate  y*Offset*4  pigment{IndianRed5       }finish{Fin}}
  object{Til translate  y*Offset*5  pigment{LavenderBlush    }finish{Fin}}
  object{Til translate  y*Offset*6  pigment{LavenderBlush1   }finish{Fin}}
  object{Til translate  y*Offset*7  pigment{LavenderBlush2   }finish{Fin}}
  object{Til translate  y*Offset*8  pigment{LavenderBlush3   }finish{Fin}}
  object{Til translate  y*Offset*9  pigment{LavenderBlush4   }finish{Fin}}
  object{Til translate  y*Offset*10 pigment{LightSkyBlue     }finish{Fin}}
  object{Til translate  y*Offset*11 pigment{LightSkyBlue1    }finish{Fin}}
  object{Til translate  y*Offset*12 pigment{LightSkyBlue2    }finish{Fin}}
  object{Til translate  y*Offset*13 pigment{LightSkyBlue3    }finish{Fin}}
  object{Til translate  y*Offset*14 pigment{LightSkyBlue4    }finish{Fin}}
  object{Til translate  y*Offset*15 pigment{LightYellow      }finish{Fin}}
  object{Til translate  y*Offset*16 pigment{LightYellow1     }finish{Fin}}
  object{Til translate  y*Offset*17 pigment{LightYellow2     }finish{Fin}}
  object{Til translate  y*Offset*18 pigment{LightYellow3     }finish{Fin}}
  object{Til translate  y*Offset*19 pigment{LightYellow4     }finish{Fin}}
  object{Til translate  y*Offset*20 pigment{Linen            }finish{Fin}}}
 #declare Row16 = union{
  object{Til translate -y*Offset    pigment{MediumOrchid     }finish{Fin}}
  object{Til translate -y*Offset*2  pigment{MediumOrchid1    }finish{Fin}}
  object{Til translate -y*Offset*3  pigment{MediumOrchid2    }finish{Fin}}
  object{Til translate -y*Offset*4  pigment{MediumOrchid3    }finish{Fin}}
  object{Til translate -y*Offset*5  pigment{MediumOrchid4    }finish{Fin}}
  object{Til translate -y*Offset*6  pigment{MediumOrchid5    }finish{Fin}}
  object{Til translate  y*0         pigment{MediumPurple     }finish{Fin}}
  object{Til translate  y*Offset    pigment{MediumPurple1    }finish{Fin}}
  object{Til translate  y*Offset*2  pigment{MediumPurple2    }finish{Fin}}
  object{Til translate  y*Offset*3  pigment{MediumPurple3    }finish{Fin}}
  object{Til translate  y*Offset*4  pigment{MediumPurple4    }finish{Fin}}
  object{Til translate  y*Offset*5  pigment{MediumPurple5    }finish{Fin}}
  object{Til translate  y*Offset*6  pigment{MistyRose        }finish{Fin}}
  object{Til translate  y*Offset*7  pigment{MistyRose1       }finish{Fin}}
  object{Til translate  y*Offset*8  pigment{MistyRose2       }finish{Fin}}
  object{Til translate  y*Offset*9  pigment{MistyRose3       }finish{Fin}}
  object{Til translate  y*Offset*10 pigment{MistyRose4       }finish{Fin}}
  object{Til translate  y*Offset*11 pigment{NavajoWhite      }finish{Fin}}
  object{Til translate  y*Offset*12 pigment{NavajoWhite1     }finish{Fin}}
  object{Til translate  y*Offset*13 pigment{NavajoWhite2     }finish{Fin}}
  object{Til translate  y*Offset*14 pigment{NavajoWhite3     }finish{Fin}}
  object{Til translate  y*Offset*15 pigment{NavajoWhite4     }finish{Fin}}
  object{Til translate  y*Offset*16 pigment{Snow             }finish{Fin}}
  object{Til translate  y*Offset*17 pigment{Snow1            }finish{Fin}}
  object{Til translate  y*Offset*18 pigment{Snow2            }finish{Fin}}
  object{Til translate  y*Offset*19 pigment{Snow3            }finish{Fin}}
  object{Til translate  y*Offset*20 pigment{Snow4            }finish{Fin}}}

  union{union{
  object{Row1}                          object{Row2  translate  x*Offset  }
  object{Row3  translate  x*Offset*2 }  object{Row4  translate  x*Offset*3}
  object{Row5  translate  x*Offset*4 }  object{Row6  translate  x*Offset*5}
  object{Row7  translate  x*Offset*6 }  object{Row8  translate  x*Offset*7}
  object{Row9  translate  x*Offset*8 }  object{Row10 translate  x*Offset*9}
  object{Row11 translate  x*Offset*10}  object{Row12 translate -x*Offset  }
  object{Row13 translate -x*Offset*2 }  object{Row14 translate -x*Offset*3}
  object{Row15 translate -x*Offset*4 }  object{Row16 translate -x*Offset*5}
  object{Row1  translate -x*Offset*6 }  object{Row2  translate -x*Offset*7}
  object{Row3  translate -x*Offset*8 }  object{Row4  translate -x*Offset*9}
  object{Row5  translate -x*Offset*10}  translate z*Offset*26}
  union{
  object{Row6}                          object{Row7  translate  x*Offset  }
  object{Row8  translate  x*Offset*2 }  object{Row9  translate  x*Offset*3}
  object{Row10 translate  x*Offset*4 }  object{Row11 translate  x*Offset*5}
  object{Row12 translate  x*Offset*6 }  object{Row13 translate  x*Offset*7}
  object{Row14 translate  x*Offset*8 }  object{Row15 translate  x*Offset*9}
  object{Row16 translate  x*Offset*10}  object{Row1  translate -x*Offset  }
  object{Row2  translate -x*Offset*2 }  object{Row3  translate -x*Offset*3}
  object{Row4  translate -x*Offset*4 }  object{Row5  translate -x*Offset*5}
  object{Row6  translate -x*Offset*6 }  object{Row7  translate -x*Offset*7}
  object{Row8  translate -x*Offset*8 }  object{Row9  translate -x*Offset*9}
  object{Row10 translate -x*Offset*10}}rotate 90*z translate 27.5*x scale<2.35,2.25,5>}

  plane{z,0 inverse pigment{color White}finish{ambient .4 diffuse .1}}


