#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "skies.inc"
#include "glass.inc"
#include "stones.inc"

camera{
  location <0,3,-6>
  look_at  <0,3,0>
}

light_source{<-5,5,-20> color White atmosphere off}

#declare Drop=cone{
  0,0.01,y,0
  pigment{gradient y
    pigment_map{
      [0 color rgbt <0.8,0.8,1.0,0.7>]
      [1 color rgbt <0.8,0.8,1.0,2.0>]
    }
    turbulence 0.1
  }
  finish{F_Glass2}
  scale 4
  rotate z*35
  rotate -x*15
}

#declare RS=seed(3693)
#declare I=0
#while (I<1500)
  object{Drop translate <80*rand(RS)-40,20*rand(RS),70*rand(RS)>}
  #declare I=I+1
#end
#declare I=0
#while (I<500)
  object{Drop translate <80*rand(RS)-40,5*rand(RS)-3,70*rand(RS)>}
  #declare I=I+1
#end

sky_sphere{S_Cloud4}

fog{
  distance   70
  colour     rgb <0.4, 0.4, 0.5>
  fog_type   2
  fog_offset 20
  fog_alt    10
  turbulence 0.5
}

height_field{gif "rock.gif"
  translate <-0.5,0,-0.5>
  scale <25,25,25>
  translate <-5,-15,20>
  texture{T_Glass2}
  rotate -z*15
}
plane{y,0 translate -y*5
  texture{T_Glass2}
  normal{bumps 1 scale 1.5}
}
