#include   "colors.inc"
#include   "finish.inc"
#include "textures.inc"

#version 3.0

global_settings
	{
		assumed_gamma 1.0
	}

camera
	{
		location <10,10,-10>
		 look_at < 0, 0,  0>
	}

light_source
	{
		          <100, 0, 0>
		    color White
		spotlight
		 point_at <  0, 0, 0>
		   radius  4
		  falloff  5.3
		tightness 10
	}

light_source
	{
		          <0, 0, -100>
		    color White
		spotlight
		 point_at <0, 0,    0>
		   radius  4
		  falloff  5.3
		tightness 10
	}

light_source
	{
		          <0, 100, 0>
		    color White
		spotlight
		 point_at <0,   0, 0>
		   radius  4
		  falloff  5.3
		tightness 10
	}

plane
	{
		      z,
		     10
		 hollow
		texture
			{
				pigment
					{
						color Red
					}
				finish
					{
						reflection .5
					}
			}
	}

plane
	{
		      y,
		    -10
		 hollow
		texture
			{
				pigment
					{
						color Yellow
					}
				finish
					{
						reflection .5
					}
			}
	}

plane
	{
		      x,
		    -10
		 hollow
		texture
			{
				pigment
					{
						color Blue
					}
				finish
					{
						reflection .5
					}
			}
	}

#declare Ny = vnormalize(<10, 10, 10>)
#declare Nx = vnormalize(vcross(Ny,y))
#declare Nz = vcross(Nx, Ny)

#declare Bullet =
union
	{
		cylinder
			{
				<0.00, 0.00, 0.00>,
				<0.00, 0.75, 0.00>,
				             0.25
			}
		intersection
			{
				sphere
					{
						<0.00, 0.75, 0.00>,
						             0.25
					}
				plane
					{
						-y,
						 0.75
					}
			}
	}

#declare Iter = -10

#while (Iter <= 0)
	cylinder
		{
			<0.00, 0.00, 0.00>,
			<0.00, 0.75, 0.00>,
			             0.25
			texture
				{
					pigment
						{
							color rgbt <0.99, 0.99, 0.99, 0.99>
						}
					finish
						{				
							 specular 1.000
							roughness 0.001
							 metallic
						}
				}
			matrix
				<Nx.x, Nx.y, Nx.z,
				 Ny.x, Ny.y, Ny.z,
       	 Nz.x, Nz.y, Nz.z,
				 Iter, Iter, Iter>
		}

	#declare Iter = Iter + .51
#end

object
	{
		Bullet
		texture
			{
				pigment
					{
						color Gray20
					}
				finish
					{
						reflection 0.200
						  specular 1.000
						 roughness 0.001
						  metallic
					}
			}
				matrix
				<Nx.x, Nx.y, Nx.z,
				 Ny.x, Ny.y, Ny.z,
       	 Nz.x, Nz.y, Nz.z,
				  0.1,  0.1,  0.1>
	}
