#include   "colors.inc"
#include "textures.inc"
#include    "glass.inc"

#version 3.0

global_settings
	{
		assumed_gamma 2.2
	}

camera
	{
		location <10,10,-10>
		 look_at < 0, 0,  0>
	}

light_source
	{
		          <100, 0, 0>
		    color White
	}

light_source
	{
		          <0, 0, -100>
		    color White
	}

light_source
	{
		          <0, 100, 0>
		    color White
	}

#declare Stella2 =
pigment
	{
		  granite
		color_map
			{
				[ 0.00  0.72 color  Black * 2 color  Black * 2 ]
				[ 0.72  0.75 color Gray55 * 2 color Gray65 * 2 ]
				[ 0.75  0.78 color Gray65 * 2 color Gray75 * 2 ]
				[ 0.78  0.81 color Gray75 * 2 color Gray85 * 2 ]
				[ 0.81  0.85 color Gray85 * 2 color Gray95 * 2 ]
				[ 0.85  0.91 color Gray95 * 2 color  White * 2 ]
				[ 0.91  1.00 color  Black * 2 color  Black * 2 ]
			}
		    scale .1
	}

#declare Spotty =
pigment
	{
		  granite
		color_map
			{
				[ 0.00  0.72 color  White * 2 filter .9 color  White * 2 filter .9  ]
				[ 0.72  0.75 color Red * 2 filter .9 color Red * 2 filter .9 ]
				[ 0.75  0.78 color Yellow * 2 filter .9 color Yellow * 2 filter .9 ]
				[ 0.78  0.81 color Blue * 2 filter .9 color Blue * 2 filter .9 ]
				[ 0.81  0.85 color Red * 2 filter .9 color Red * 2 filter .9 ]
				[ 0.85  0.91 color Yellow * 2 filter .9 color  Yellow * 2 filter .9 ]
				[ 0.91  1.00 color  White * 2 filter .9 color  White * 2 filter .9 ]
			}
		    scale .01
	}

#declare Rtex =
texture
	{
		pigment
			{
				Stella2
			}
	}
texture
	{
		pigment
			{
				color rgbt <2.0, 0.0, 0.0, 0.8>
			}
		finish
			{
				reflection .5
			}
	}

#declare Ytex =
texture
	{
		pigment
			{
				Stella2
			}
	}
texture
	{
		pigment
			{
				color rgbt <2.0, 2.0, 0.0, 0.8>
			}
		finish
			{
				reflection .5
			}
	}

#declare Btex =
texture
	{
		pigment
			{
				Stella2
			}
	}
texture
	{
		pigment
			{
				color rgbt <0.0, 0.0, 2.0, 0.8>
			}
		finish
			{
				reflection .5
			}
	}

#declare K = clock * 2

#if (K > 1)
	#declare K = 2 - K
#end

#declare K = K * 1.5

#declare Stex =
texture
	{
		radial
		turbulence K
		texture_map
			{
				[ 0.00 Rtex ]
				[ 0.17 Rtex ]
				[ 0.33 Ytex ]
				[ 0.50 Ytex ]
				[ 0.66 Btex ]
				[ 0.84 Btex ]
				[ 1.00 Rtex ]
			}
	}

#declare R = clock * 360

#declare Backdrop =
plane
	{
		y,
		0
		hollow
		texture
			{
				Stex
			}
		   rotate <  0,   R,   0>
		   rotate <-45, -45,   0>
		translate <-10, -10,  10>
	}

#declare D = .0625
#declare S = .25

#declare I = .5

#declare B = D + S
#declare L = B + I + I
#declare M = L + I
#declare N = M + I

#declare Dot =
sphere
	{
		<0, 0, 0>,
		       D
	}

#declare Ball =
union
	{
		sphere
			{
				<0, 0, 0>,
		    		   S
				texture
					{
						T_Glass3
						pigment
							{
								Spotty
							}
					}
			}
		object
			{
				Dot
				texture
					{
						pigment
							{
								color Yellow * 2
							}
						finish
							{
								Shiny
							}
					}
				translate < 0,  S,  0>
			}
		object
			{
				Dot
				texture
					{
						pigment
							{
								color Blue * 2
							}
						finish
							{
								Shiny
							}
					}
				translate < 0, -S,  0>
			}
		object
			{
				Dot
				texture
					{
						pigment
							{
								color Red * 2
							}
						finish
							{
								Shiny
							}
					}
				translate < S,  0,  0>
			}
		object
			{
				Dot
				texture
					{
						pigment
							{
								color Green * 2
							}
						finish
							{
								Shiny
							}
					}
				translate <-S,  0,  0>
			}
		object
			{
				Dot
				texture
					{
						pigment
							{
								color White * 2
							}
						finish
							{
								Shiny
							}
					}
				translate < 0,  0,  S>
			}
		object
			{
				Dot
				texture
					{
						pigment
							{
								color Black * 2
							}
						finish
							{
								Shiny
							}
					}
				translate < 0,  0, -S>
			}
	}

#declare Xtor =
torus
	{
		L,
		I
		texture
			{
				pigment
					{
						   radial
						color_map
							{
								[ 0.00 color rgbt <2.0, 0.0, 0.0, 0.8> ]
								[ 0.17 color rgbt <2.0, 0.0, 0.0, 0.8> ]
								[ 0.33 color rgbt <2.0, 2.0, 0.0, 0.8> ]
								[ 0.50 color rgbt <2.0, 2.0, 0.0, 0.8> ]
								[ 0.67 color rgbt <0.0, 0.0, 2.0, 0.8> ]
								[ 0.84 color rgbt <0.0, 0.0, 2.0, 0.8> ]
								[ 1.00 color rgbt <2.0, 0.0, 0.0, 0.8> ]
							}
					}
			}
		rotate <-90,   0,   0>
	}

#declare Ztor =
torus
	{
		M,
		I
		texture
			{
				pigment
					{
						radial
						color_map
							{
								[ 0.00 color rgbt <2.0, 2.0, 0.0, 0.8> ]
								[ 0.17 color rgbt <2.0, 2.0, 0.0, 0.8> ]
								[ 0.33 color rgbt <2.0, 0.0, 0.0, 0.8> ]
								[ 0.50 color rgbt <2.0, 0.0, 0.0, 0.8> ]
								[ 0.67 color rgbt <0.0, 0.0, 2.0, 0.8> ]
								[ 0.84 color rgbt <0.0, 0.0, 2.0, 0.8> ]
								[ 1.00 color rgbt <2.0, 2.0, 0.0, 0.8> ]
							}
					}
			}
		rotate <-90,   0,   0>
	}

#declare Ytor =
torus
	{
		N,
		I
		texture
			{
				pigment
					{
						radial
						color_map
							{
								[ 0.00 color rgbt <0.0, 0.0, 2.0, 0.8> ]
								[ 0.17 color rgbt <0.0, 0.0, 2.0, 0.8> ]
								[ 0.33 color rgbt <2.0, 2.0, 0.0, 0.8> ]
								[ 0.50 color rgbt <2.0, 2.0, 0.0, 0.8> ]
								[ 0.67 color rgbt <2.0, 0.0, 0.0, 0.8> ]
								[ 0.84 color rgbt <2.0, 0.0, 0.0, 0.8> ]
								[ 1.00 color rgbt <0.0, 0.0, 2.0, 0.8> ]
							}
					}
			}
	}

#declare Stage1 =
union
	{
		object
			{
				Ball
				   rotate < R,  R,  R>
				translate < I,  0,  0>
				   rotate < 0, -R,  0>
				translate < L,  0,  0>
			}
		object
			{
				Xtor
				rotate < 0,  0,  R>
			}
		rotate < 0,  0,  R>
		rotate < 0, 90,  0>
	}

#declare Stage2 =
union
	{
		object
			{
				Stage1
				translate <0, M, 0>
			}
		object
			{
				Ztor
				rotate < 0,  0,  R>
			}
				   rotate < 0,  0, R>
				translate < N,  0, 0>
	}

#declare Final =
union
	{
		object
			{
				Stage2
			}
		object
			{
				Ytor
				rotate < 0, -R,  0>
			}
		rotate < 0, -R,  0>
		rotate <-R, -R, -R>
	}

object
	{
		Backdrop
	}

object
	{
		Final
		scale 1.5
	}
