#include "colors.inc"
#include "skies.inc"
#include "metals.inc"
camera { location  <-3.0 , 13.0 ,-10.0> look_at <0,7,10>}

// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color rgb <1,1,1>
  translate <15, 20, 1000>
  //translate <15, 20, -100>
}

#declare effect_type = "Sun"
#declare camera_location = <-3.0 , 13.0 ,-10.0>
#declare camera_look_at = <0, 7, 10>
#declare effect_location = <15, 20, 1000>
#include "Lens.inc"

fog {
    fog_type 2 // 1=constant, 2=ground_fog
    distance 80
    color rgb<.85, .6, .4>
    turbulence 0.45
    fog_offset 2
    fog_alt 1.5
}

height_field
{
  png "shores.png" smooth
  texture {pigment{color DarkBrown} finish{diffuse 0.5}}
  scale <150, 40, 75> translate <-95, -1, 10>
}

plane {
     < 0, 1, 0 >, 0.5
     texture {
       pigment { color rgb< 0.35, 0.25, 0.1> }
       normal { bumps 0.25 scale <.65, .2, .2> }
       finish { phong 1 reflection .8 ambient 0.1 diffuse 0.2 }
     }
}

#declare P_Cloud1 =
pigment {
    bozo
    turbulence 0.65
    octaves 6
    omega 0.7
    lambda 2
    color_map {
        [0.0, 0.1   color red 0.35 green 0.35 blue 0.35
                    color red 0.45 green 0.45 blue 0.45]
        [0.1, 0.5   color red 0.45 green 0.45 blue 0.45
                    color Clear]
        [0.5, 1.001 color Clear
                    color Clear]
    }
    scale <6, 1, 6>
}

sky_sphere {
    pigment {
        gradient y
        pigment_map {
            [0.01 rgb <1, 0.449, 0.247>]
            [0.80 rgb <0.85, 0.65, 0.42>]
        }
    }
    pigment {
        gradient y
        pigment_map {
            [0.01 rgb <0.847, 0.549, 0.247> ] // horizon
            [0.25 P_Cloud1 scale 0.25 rotate z*5]
            [0.60 P_Cloud1 scale <0.25, 0.15, 0.25> rotate z*10]
        }
    }
}
