
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

camera {
	location <0,-3,-25>
	look_at  <0,7,0>
}

light_source {<0,10,-20> color White atmosphere off}

#declare Effects = on
#declare Effects_high = on

#if (Effects = on)
// Constants used by 'rad_def.inc' are set in 'const.inc'
#include "consts.inc"
#if (Effects_high = off)
	#declare Rad_Quality = Radiosity_Debug
	#else
	#declare Rad_Quality = Radiosity_Final
#end

#include "rad_def.inc"
#end

#declare Beam_pigment = pigment {rgbft <0.9,0.9,1,.25,.5>}

#declare Primary_logo = on

#if (Primary_logo = on)

#include "13pov.inc"
object {LOGO pigment{White} rotate <0,35,0> translate <-2,0,0>}
#end

#declare Cloud1 =
pigment {
    bozo
    turbulence 0.65
    octaves 6
    omega 0.7
    lambda 2
    color_map {
        [0.0 rgb <0.88,0.66,0.56>]
        [0.1 rgb <0.26,0.28,0.40>]
		[0.2 rgb <1.00,0.90,0.50>]
		[0.3 rgb <0.79,0.43,0.26>]
		[0.4 rgb <0.26,0.28,0.40>]
        [1.0 rgbf <1,1,1,1>]
    }
    scale <3,0.75,3> rotate <0,-90,0>
}

#declare Cloud2 =
pigment {
    wrinkles
    turbulence 0.5
    octaves 6
    omega 0.7
    lambda 2
    color_map {
        [0.0 rgb <0.88,0.66,0.56>]
        [0.1 rgb <0.26,0.28,0.40>]
		[0.25 rgb <0.54,0.36,0.45>]
		[0.3 rgb <0.61,0.46,0.57>]
		[0.35 rgb <0.71,0.56,0.67>]
		[0.4 rgb <0.26,0.28,0.40>]
		[0.5 rgbf <1,1,1,1>]
        [1.0 rgbf <1,1,1,1>]
    }
    scale <3,1,3>
}

#declare Cloud3 =
pigment {
	granite
	turbulence 1
	color_map {
		[0.0 rgbf <1,1,1,1>]
		[0.025 rgb <2,2,4>]
		[0.075 rgbf <1,1,1,.5>]
		[0.15 rgbf <1,1,1,1>]
		[1.0 rgbf <1,1,1,1>]
	}
}

sky_sphere {
    pigment {
        gradient y
        pigment_map {
            [0.0 rgb <0.88,0.66,0.56> ] // horizon
            [0.1 Cloud1 scale 0.25 rotate z*5]
            [0.60 Cloud2 scale <0.25, 0.15, 0.25> rotate z*10]
			[0.8 Cloud3 scale .2]
        }
    }
}

