//*****************************************************************************************************************************
// Titanicous
//*****************************************************************************************************************************
#version unofficial MegaPov 0.4;
#local quality = 0;
global_settings {
	max_trace_level 20
	number_of_waves 20
	post_process {
		soft_glow{1,8}
	}
	#if (quality >=1)
		#if(quality >= 2)
	  		// High Quality - slow rendering
		  	ini_option "+QR"
		  	ini_option "Preview_Start_Size=8"
		  	ini_option "Preview_End_Size=4"
		  
		  	radiosity{
			    count 80             // CHANGE range from 20 to 150
			    nearest_count 6      // CHANGE range from 3 to 10
			    error_bound 1        // CHANGE - range from 1 to 3 - should correspond with Preview_End_Size
			                         //   1 : preview_end_size = 4
			                         //   3 : preview_end_size = 8
			                         //   use preview_start_size = 16 (or 8 for high quality)
			                         // you can go lower than 1, but then you probably will want to set
			                         // preview_end_size to 2, which is really slow
			    recursion_limit 4    // CHANGE
			    
			    low_error_factor .5  // leave this
			    gray_threshold 0.0   // leave this
			    minimum_reuse 0.015  // leave this
			    brightness 1         // leave this
			    
			    max_sample 1         // CHANGE - this should be the same as the brightest object
			    adc_bailout 0.01/1   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
			    normal on
		  	}
		#else
		  	// Medium Quality - works for most scenes
		  	ini_option "+QR"
		  	ini_option "Preview_Start_Size=16"
		  	ini_option "Preview_End_Size=8"
		  
		  	radiosity{
			    count 40             // CHANGE range from 20 to 150
			    nearest_count 3      // CHANGE range from 3 to 10
			    error_bound 3        // CHANGE - range from 1 to 3 - should correspond with Preview_End_Size
			                         //   1 : preview_end_size = 4
			                         //   3 : preview_end_size = 8
			                         //   use preview_start_size = 16
			                         // you can go lower than 1, but then you probably will want to set
			                         // preview_end_size to 2, which is really slow
			    recursion_limit 3    // CHANGE
			    
			    low_error_factor .5  // leave this
			    gray_threshold 0.0   // leave this
			    minimum_reuse 0.015  // leave this
			    brightness 1         // leave this
			    
			    max_sample 1         // CHANGE - this should be the same as the brightest object
			    adc_bailout 0.01/1   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
			    normal on
			}
		#end
	#end
}
#declare mcount = 0;
#local pov = spline {
	cubic_spline
	-1,<0,0,500>
	0,<600,300,550>
	1,<0,0,-500>
}
#local poi = spline {
	cubic_spline
	-1,<0,0,0>
	0,<0,0,0>
	1,<0,0,0>
}
#local pos = spline {
	cubic_spline
	-1,<0,0,-500>
	0,<0,0,0>
	1,<0,0,500>
}

#declare cam_l = <0,0,0>+pov(clock);     
#declare cam_lat =  <0,0,0>+poi(clock);
            
#local CamZ = 1;

#local CamD = vnormalize(cam_lat-cam_l);
#local CamR = vnormalize(vcross(y,CamD));
#local CamU = vnormalize(vcross(CamD,CamR));

union {
	union {
		cylinder { <0.1,-0.1,0> <0.1,0.2,0> 0.05 }
		sphere { <0.1,0.2,0> 0.05 }
		sphere { <-0.1,-0.1,0> 0.05 }
		intersection {
			plane { y,0 }
			torus { 0.1,0.05 rotate x*90 }
			translate y*-0.1
		}
		pigment { 
			slope y-x
			colour_map {
				[0 rgb <1,1,0>]
				[0.5 rgb <1,0,0> ]
				[1 rgb 0]
			}
		}
		finish { ambient 1 diffuse 0 }
		scale 2/3
	}
	sphere { 0 0.3
		interior { ior 1.5 }
		pigment { slope x-y
			colour_map {
				[0 rgbt <1,1,1,0>]
				[1/3 rgbt 1]
				[2/3 rgbt 1]
				[1 rgbt <1,1,1,0.5>]
			}
		}
		finish {
			ambient 1
			diffuse 0
		}
	}
	torus { 0.3 0.05 rotate x*45 rotate y*(frame_number-1)*180/25 }
	pigment { 
		slope y-x
		colour_map {
			[0 rgb <0,1,1> ]
			[0.5 rgb <0,0,1>]
			[1 rgb 0]
		}
	}
	finish { ambient 1 diffuse 0 }
	no_shadow
	scale 1/4
  translate <-0.55,-0.4,CamZ>
  matrix < CamR.x,CamR.y,CamR.z,
           CamU.x,CamU.y,CamU.z,
           CamD.x,CamD.y,CamD.z,
           cam_l.x,cam_l.y,cam_l.z >
}

camera {
  location cam_l
  up CamU
  right CamR*4/3
  direction CamD*CamZ
}        

light_source { <10000,100000,300000> rgb <1,0.8,0.4> }
light_source { -<10000,100000,300000> rgb <0.2,0.4,1> }

#declare sb1text = texture {
	pigment {
		crackle
		metric 1
		solid
		scale <5,5,25>
		colour_map {
			[0 rgb 0]
			[0.1 rgb 0.5]
			[1 rgb 1]
		}
	}
	finish {
		ambient 0
		diffuse 1
		specular 0.5
		metallic
	}
}
texture {
	pigment {
		slope -z
		pigment_map {
			[0.25 rgb 0 ]
			[0.49 rgbt <0,0,0,1> ]
		}
	}
	finish {
		diffuse 0
		ambient 0
	}
}
texture {
	pigment {
		dents
		scale <10,10,1000>
		turbulence <0.1,0.1,0>
		colour_map {
			[0.5 rgbt <0,0,0,1> ]
			[1 rgbt <0,0,0,0.2> ]
		}
	}
	finish {
		ambient 0
		diffuse 0
	}
}
texture {
	pigment {
		slope y
		colour_map {
			[0.45 rgbt <1,1,0,1>]
			[0.5 rgbt <1,1,0,0>]
			[0.55 rgbt <1,1,0,1>]
		}
	}
	finish {
		ambient 1
		diffuse 0
	}
}
texture {
	pigment {
		slope vrotate(y,120*z)
		colour_map {
			[0.45 rgbt <1,1,0,1>]
			[0.5 rgbt <1,1,0,0>]
			[0.55 rgbt <1,1,0,1>]
		}
	}
	finish {
		ambient 1
		diffuse 0
	}
}
texture {
	pigment {
		slope vrotate(y,120*-z)
		colour_map {
			[0.45 rgbt <1,1,0,1>]
			[0.5 rgbt <1,1,0,0>]
			[0.55 rgbt <1,1,0,1>]
		}
	}
	finish {
		ambient 1
		diffuse 0
	}
}

#declare sb1hulltext = texture {
	pigment {
		slope y
		pigment_map {
			[ 0.1 rgbt 1 ]
			[ 0.1 gradient y scale 3 pigment_map { [5/6 rgbt 1] [5/6 rgbt <1,1,1,-10> ] } ]
			[ 0.9 gradient y scale 3 pigment_map { [5/6 rgbt 1] [5/6 rgbt <1,1,1,-10> ] } ]
			[ 0.9 rgbt 1 ]
		}
	}
	finish {
		ambient 1
		diffuse 0
	}
}

#declare sb1epodtext = texture {
	pigment {
		cylindrical
		rotate z*90
		pigment_map {
			[0 rgbt <0,0,0,1> ]
			[0.2 radial frequency 18 triangle_wave pigment_map { [0.3 cylindrical colour_map { [0 rgbt 0] [1 rgbt <1,1,0,-10>] } ] [0.4 cylindrical colour_map { [0 rgbt 0] [1 rgbt <1,0,0,-10>] }] [0.5 rgbt <0,0,0,-10>] [0.6 rgbt <0,0,0,1>] } ]
			[0.6 radial frequency 18 triangle_wave pigment_map { [0.3 cylindrical colour_map { [0 rgbt 0] [1 rgbt <1,1,0,-10>] } ] [0.4 cylindrical colour_map { [0 rgbt 0] [1 rgbt <1,0,0,-10>] }] [0.5 rgbt <0,0,0,-10>] [0.6 rgbt <0,0,0,1>] } ]
			[0.7 rgbt <0,0,0,1> ]
			[0.8 rgbt <0,0,0,-10> ]
			[0.85 rgbt <0,0,1,-10> ]
			[0.95 rgbt <0,1,1,-10> ]
			[1 rgbt <1,1,1,-10> ]
		}
	}
	finish {
		ambient 1
		diffuse 0
	}
}

#declare titanicous = blob {
	threshold 0.5
	#local rc = 90;
	#while (rc < 360)
		cylinder { <-200,0,100> <-200,0,-100> 50 1 rotate z*-rc }
		sphere { 0 50 1 texture { sb1text } texture { sb1epodtext scale 25 } translate <-200,0,0> rotate z*-rc}
		#local wc = 0;
		#while (wc <= 180)
			cylinder { <0,0,-50> <0,0,50> 25 1 scale <1,1,(abs(wc-90)/90+0.25)*2> translate x*-100 rotate z*wc scale <1,0.5,1> translate <-100,0,0> rotate rc*-z
				#if (mod(wc,180)=0) pigment { rgb <0,5,5> } finish { ambient 1 diffuse 0 } #end }
			cylinder { <0,0,-50> <0,0,50> 25 1 scale <1,1,(abs(wc-90)/90+0.25)*2> translate x*-100 rotate z*-wc scale <1,0.5,1> translate <-100,0,0> rotate rc*-z
				#if (mod(wc,180)=0) pigment { rgb <0,5,5> } finish { ambient 1 diffuse 0 } #end }
			#local wc = wc +1;
		#end
		cylinder { <-100,0,-100> <0,0,-300> 50 1 rotate z*rc }
		cylinder { <0,0,-100> <-50,0,-200> 25 1 rotate z*rc }
		cylinder { <-100,0,100> <0,0,300> 50 1 rotate z*rc }
		cylinder { <0,0,100> <-50,0,200> 25 1 rotate z*rc }
		cylinder { <-100,0,100> <-100,0,-100> 50 1 rotate z*rc }
		#local rc = rc + 120;
	#end
	sphere { <0,0,-300> 200 1}
	sphere { <0,0,300> 200 1}
	#local sc = 0;
	#while (sc < 200)
		sphere { <0,0,0> (200-sc) 1 scale 1-(sc/200) scale <2/3,1/3,1> translate <0,0,300+sc*0.5> texture { sb1text} texture { sb1hulltext } }
		#local sc = sc + 5;
	#end
	sturm
	texture { sb1text }
	#local dpos = vnormalize(pos(clock+0.01)-pos(clock-0.01));
	rotate x*-degrees(atan2(dpos.y,sqrt(dpos.x*dpos.x+dpos.z*dpos.z)))
	rotate y*degrees(atan2(dpos.x,dpos.z))
	translate pos(clock)
}

object { titanicous }

sky_sphere {
	pigment {
		granite
		scale 2
		colour_map {
			[0 rgb 0]
			[1 rgb <0,0,0.2>]
		}
	}
	pigment {
		planar
		colour_map {
			[0.8 rgbt <1,0,1,1>]
			[1 rgbt <1,0,1,0>]
		}
	}
}

#macro stars(maxstars)
	#local sp = seed(42);
	#local scol = seed(42);
	#local sc = 0;
	#while (sc < maxstars)
		#local scolpos=(rand(scol)*pi/4) - (pi/8);
		#local scolour=<cos(scolpos-(pi/8)),cos(scolpos),cos(scolpos+(pi/8))>;
		sphere {
			0 0.1
			pigment {rgb scolour }
			finish {
				ambient 1
				diffuse 0
			}
			no_shadow
			scale 800
			translate -(100000+100000*rand(sp))*y
			rotate x*(180*rand(sp))
			rotate y*(360*rand(sp))
		}
		#local sc = sc +1;
	#end
#end

stars(10000)

