#version unofficial MegaPov 0.5;
camera {
location <-50,50,-80>*2
direction 1.5
look_at -40*z
}

light_source {<-40,25,-15>*200 rgb 1.75}// area_light 200,200,4,4 jitter orient adaptive 0 }
light_source {<-40,25,15>*200 rgb .25 shadowless }

light_source {<40,0,0>*200 rgb <0,.5,1>}

#declare Scarring =
texture {pigment {bozo color_map {[0 rgb 0 transmit .5][1 rgb 0 transmit 1]}scale 2}}
texture {pigment {bozo pigment_map {[0 bozo color_map {[0 rgb 0 transmit .5][1 rgb 0 transmit 1]}scale .125][.5 rgb 0 transmit 1]}scale 2}translate 25}
#declare Scarring2 =
texture {pigment {bozo color_map {[0 rgb 0 transmit .375][1 rgb 0 transmit 1]}scale 2}}
texture {pigment {bozo pigment_map {[0 bozo color_map {[0 rgb 0 transmit .375][1 rgb 0 transmit 1]}scale .125][.5 rgb 0 transmit 1]}scale 2}translate 25}

#declare Color = rgb .25//<.5,.5,1>/2 
#declare ColorA = rgb <1,.625,0>//<1,.375,.375>

#declare T1 =
texture { pigment {Color} finish {ambient 0 diffuse .75 phong 1 phong_size 35}}
texture {Scarring scale .125/8 scale z/2}
#declare T2 =
texture { pigment {Color*.75} finish {ambient 0 diffuse .75 phong 1 phong_size 15}}      
texture {Scarring scale .125/12 scale z/2 translate 20}
#declare T3 =
texture { pigment {Color*2/3} finish {ambient 0 diffuse .75 phong .75 phong_size 15}} 
texture {Scarring scale .125/16 scale z/2 translate 40}

#declare T1A =
texture { pigment {ColorA} finish {ambient 0 diffuse .75 phong 1 phong_size 35}}
texture {Scarring scale .125/8 scale z/2}
#declare T2A =
texture { pigment {ColorA*.75} finish {ambient 0 diffuse .75 phong 1 phong_size 15}}      
texture {Scarring scale .125/12 scale z/2 translate 20}
#declare T3A =
texture { pigment {ColorA*2/3} finish {ambient 0 diffuse .75 phong .75 phong_size 15}} 
texture {Scarring scale .125/16 scale z/2 translate 40}


#declare T4 =
texture { pigment {rgb .75} finish {ambient 0 diffuse .75 phong .75 phong_size 15}}
texture {Scarring scale .125/16 scale z/2 translate 60}
#declare T5 =
texture { pigment {rgb .675} finish {ambient 0 diffuse .75 phong .625 phong_size 15}}
texture {Scarring scale .125/8 scale z/2 translate 80}
#declare T6 =
texture { pigment {rgb .5} finish {ambient 0 diffuse .75 phong .125 phong_size 15}}
texture {Scarring scale .125/16 scale z/2 translate 100}

#declare T7 =
texture { pigment {rgb .75} finish {ambient 0 diffuse .75 phong .85 phong_size 15}}
texture {Scarring2 scale .125 scale 4*z translate 100}
#declare T8 =
texture { pigment {rgb .5} finish {ambient 0 diffuse .75 phong .25 phong_size 15}}
texture {Scarring scale .125 scale 4*z translate 10}

#declare T9 =
texture { pigment {rgb .5} finish {ambient 0 diffuse .75 phong .85 phong_size 15}}
texture {Scarring2 scale .125 translate 100}
#declare T10 =
texture { pigment {rgb .35} finish {ambient 0 diffuse .75 phong .25 phong_size 15}}
texture {Scarring scale .125 translate 10}

#declare S1 =
texture { pigment {rgb <.25,.5,1>} finish {ambient 0 diffuse .75 phong 1.5 phong_size 15 metallic}}
texture {Scarring2 scale .125 translate 10 scale 3*z}
#declare S2 =
texture { pigment {rgb <.25,.5,1>*.625} finish {ambient 0 diffuse .75 phong 2 phong_size 15}}
texture {Scarring scale .125 translate -10 scale 3*z}
#declare P1 =
texture { pigment {rgb .25} finish {ambient 0 diffuse .75 phong 1.5 phong_size 15 metallic}}
texture {Scarring2 scale .125 translate 10 scale 3*z}
#declare P2 =
texture { pigment {rgb <.6,.55,.5>} finish {ambient 0 diffuse .75 phong 2 phong_size 15}}
texture {Scarring scale .125 translate -10 scale 3*z}
#declare P3 =
texture { pigment {rgb 1} finish {ambient 0 diffuse .75 phong .85 phong_size 15}}
texture {Scarring2 scale .125 scale 4*z translate 100}
#declare P4 =
texture { pigment {rgb .625} finish {ambient 0 diffuse .75 phong .25 phong_size 15}}
texture {Scarring scale .125 scale 4*z translate 10}

#declare PanelTex =                                           
texture {
crackle metric 1   
texture_map {
[0 P1]     
[.5 P2]
}
rotate 90*x 
}
#declare PanelTex2 =                                           
texture {
crackle metric 1   
texture_map {
[0 P3]     
[.5 P4]
}
rotate 90*x 
}
#declare SolarPanelTex =                                           
texture {
crackle metric 1   
texture_map {
[0 S1]     
[.5 S2]
}
scale <1/200,1,1> 
warp {cylindrical}   
rotate 90*x 
} 
#declare DefineHullTex =                                           
texture {
crackle metric 1   
texture_map {
[.25 T7]     
[.75 T8]
}
scale <1/160,1,1> 
warp {cylindrical}   
rotate 90*x 
}  

#declare HullTex =                                           
texture {
crackle metric 1   
texture_map {
[.25 T7]     
[.75 T8]
}
scale 2*z
scale 1/12 
}

#declare B1 =
texture { pigment {rgb .5} finish {ambient 0 diffuse .75 phong .85 phong_size 15}}
texture {Scarring2 scale .125 scale 4*z translate 100}
#declare B2 =
texture { pigment {rgb .125} finish {ambient 0 diffuse .75 phong .25 phong_size 15}}
texture {Scarring scale .125 scale 4*z translate 10}


#declare HullTex2 =                                           
texture {
crackle metric 1   
texture_map {
[.25 B1]     
[.75 B2]
}
scale 2*z
scale 1/12 
}  

#declare ColoredHullTex =                                           
texture {
crackle metric 1   
texture_map {
[.25 T1A scale 8 scale 2*z]     
[.75 T3A scale 8 scale 2*z]
}
scale 2*z 
scale 1/12
} 

#macro SolarPanel(Rand)
#local SolarPanelPart1 =
union {
intersection {
cone {0,1,y,2 scale 20*x}
box {<-.125,0,-2>,<.125,.9999,2>}
} 
difference {
intersection {
cone {y,2,y*8.5,1.5 scale 20*x}
box {<-.125,1,-2>,<.125,14.9999,2>}
}    
cone {y*8.5001,1,y*8,.5 scale 20*x}  
cone {y*.9999,1.625,y*7.75,1.125 scale 20*x}   
       
}    
intersection {
cone {y*.9999,1.625,y*7.75,1.125 scale 20*x}          
box {<-.05,1,-2>,<.05,14.9999,2>}
texture {SolarPanelTex scale 1/4 translate Rand*z}
}  

cone {<0,1,1.625>,.175,<0,8,1>,.125 scale 1*x}
cone {<0,1,-1.625>,.175,<0,8,-1>,.125 scale 1*x}  
cone {0,.25,z/3,.125 scale 2*x translate <0,3/4,.875>}
cone {0,.25,-z/3,.125 scale 2*x translate <0,3/4,-.875>}
cylinder {<0,3/4,-.75>,<0,3/4,.75>,.175 scale 2*x}   
cone {0,.25,z/3,.125 scale 2*x translate <0,1/2,.875>}
cone {0,.25,-z/3,.125 scale 2*x translate <0,1/2,-.875>}
cylinder {<0,1/2,-.75>,<0,1/2,-.125>,.175 scale 2*x}  
cylinder {<0,1/2,.75>,<0,1/2,.125>,.175 scale 2*x} 
texture {DefineHullTex scale 1/4 translate Rand*z}
}   
#local SolarPanelPart2 =
union { 
difference {
intersection {
cone {0,1,y,1.5 scale 20*x}
box {<-.125,0,-2>,<.125,.9999,2>}
}
cone {-y/100,.75,y/2,.25 scale 20*x}
}
difference {
intersection {
cone {y,1.5,y*8.5,1 scale 20*x}
box {<-.125,1,-2>,<.125,14.9999,2>}
}    
cone {y*8.5001,.5,y*7.5,.25 scale 20*x}  
cone {y*.9999,1,y*7.25,.75 scale 20*x}          
} 
intersection {
cone {y*.9999,1,y*7.25,.75 scale 20*x}          
box {<-.05,1,-2>,<.05,14.9999,2>}
texture {SolarPanelTex scale 1/4 translate Rand*z}
}    

cone {0,.25,z/3,.125 scale 2*x translate <0,3/4,.875>}
cone {0,.25,-z/3,.125 scale 2*x translate <0,3/4,-.875>}
cylinder {<0,3/4,-.75>,<0,3/4,.75>,.175 scale 2*x} 
cone {0,.275,z/1.75,.125 scale 2*x}
cone {0,.275,-z/1.75,.125 scale 2*x}                  

cone {<0,1,1.175>,.175,<0,8,.875>,.125 scale 1*x}
cone {<0,1,-1.175>,.175,<0,8,-.875>,.125 scale 1*x}


texture {DefineHullTex scale 1/4 translate Rand*z}
}
union {
union {SolarPanelPart1 bounded_by {box {min_extent(SolarPanelPart1),max_extent(SolarPanelPart1)}} clipped_by {bounded_by} scale .5*x}
union {SolarPanelPart2 bounded_by {box {min_extent(SolarPanelPart2),max_extent(SolarPanelPart2)}} clipped_by {bounded_by} scale .5*x scale 1.375*z rotate 30*z translate 8.25*y} 
}
#end

#declare SolarBeamSupport =
difference {
intersection {
box {<-2,1,-10>,<2,0,10>}  
cone {-y/100,2.5,y*1.001,1 scale 200*z}
cone {-y/100,5.5,y*1.001,4 scale 200*z rotate  20*y translate -2*x}
cone {-y/100,5.5,y*1.001,4 scale 200*z rotate -20*y translate 2*x}        
cone {-y/100,5,y*1.001,5 scale 200*z rotate  20*y translate -2*x}
cone {-y/100,5,y*1.001,5 scale 200*z rotate -20*y translate 2*x}
cone {-y/100,8.5,y*1.001,4.5 scale 200*x}   
cone {-y/100,7.5,y*1.001,7.5 scale 200*x}
}
cone {y*.75,4,y*1.001,4.5 scale 200*x translate z*2}
cone {y*.75,.25,y*1.001,.5 scale 200*z rotate -20*x}   
cone {y*.75,.25,y*1.001,.5 scale 200*z rotate -20*x translate z}   
cone {y*.75,.25,y*1.001,.5 scale 200*z rotate -20*x translate z*2}   
cone {y*.75,.25,y*1.001,.5 scale 200*z rotate -20*x translate z*3}   
//cone {y*.75,.25,y*1.001,.5 scale 200*z rotate -15*x translate -z*5}  
cone {y*.25,.25,-y/100,.5 scale 200*z rotate -15*x translate -z*4}
cone {y*.25,.25,-y/100,.5 scale 200*z} 
cone {y*.225,.5,-y/100,2 scale 200*z}
cone {-z*9.5,.5,-z*5,.25 scale 200*y}
scale 1/2
}
#declare SolarPowerSetup = 
union {
union {
object {SolarBeamSupport translate -3.5*z}
object {SolarBeamSupport translate -3.5*z scale -z} 
scale <2,1.5,1>
}
object {SolarPanel(0) scale 2/3 rotate 90*z translate <-1/2,.6,3.5>}
object {SolarPanel(10) scale 2/3 rotate 90*z translate <-1/2,.6,-3.5>} 
object {SolarPanel(40) scale 2/3 rotate 90*z translate <-1/2,.6,0>}
object {SolarPanel(20) scale 2/3 rotate 90*z translate <-1/2,.6,3.5> scale -x}
object {SolarPanel(30) scale 2/3 rotate 90*z translate <-1/2,.6,-3.5> scale -x}
object {SolarPanel(50) scale 2/3 rotate 90*z translate <-1/2,.6,0> scale -x}
}
 

#declare ForeSupport = 
difference {
intersection {
box {<-2,1,-10>,<2,0,15>}  
cone {-y/100,2.5,y*1.001,1 scale 200*z}
cone {-y/100,5.5,y*1.001,4 scale 200*z rotate  20*y translate -2*x}
cone {-y/100,5.5,y*1.001,4 scale 200*z rotate -20*y translate 2*x}        
cone {-y/100,5,y*1.001,5 scale 200*z rotate  20*y translate -2*x}
cone {-y/100,5,y*1.001,5 scale 200*z rotate -20*y translate 2*x}
cone {-y/100,8.5,y*1.001,4.5 scale 200*x}   
cone {-y/100,7.5,y*1.001,7.5 scale 200*x}
}
cone {y*.75,4,y*1.001,4.5 scale 200*x translate z*2}
cone {y*1,4,y*4.001,7.5 scale 200*x translate z*4 rotate 90*z}   
cone {y*1,4,y*4.001,7.5 scale 200*x translate z*4 rotate -90*z}   
cone {y*.75,.25,y*1.001,.5 scale 200*z rotate -20*x}   
cone {y*.75,.25,y*1.001,.5 scale 200*z rotate -20*x translate z}   
cone {y*.75,.25,y*1.001,.5 scale 200*z rotate -20*x translate z*2}   
cone {y*.75,.25,y*1.001,.5 scale 200*z rotate -20*x translate z*3}   
cone {y*.75,.25,y*1.001,.5 scale 200*z rotate -15*x translate -z*5}  
cone {y*.25,.25,-y/100,.5 scale 200*z rotate -15*x translate -z*4}
cone {y*.25,.25,-y/100,.5 scale 200*z} 
cone {y*.125,.25,-y/100,2 scale 200*z}   
scale 1/2 
scale y*2
}
#local BayPanel =
union {
intersection {
cone {0,2,y,3 scale 20*x}
box {<-.125,0,-4>,<.125,.9999,4>}
} 
difference {
intersection {
cone {y,3,y*8.5,1.5 scale 20*x}
box {<-.125,1,-4>,<.125,14.9999,4>}
}    
cone {y*8.5001,1,y*8,.5 scale 20*x}   
difference {
cone {y*.9999,2.375,y*7.75,1.125 scale 20*x}   
cone {y,1.5,y*2,.75 scale 20*x}
}
}    
intersection {
cone {y*.9999,2.375,y*7.75,1.125 scale 20*x}   
box {<-.05,1,-4>,<.05,14.9999,4>}   
texture {PanelTex scale 1/2}
}              
texture {PanelTex2 scale 1/2}
} 


#declare CircularHullTex =                                           
texture {
crackle metric 1   
texture_map {
[.25 T7]     
[.75 T8]
}
scale <1/160,1,1> 
warp {cylindrical} 
rotate 90*x 
}
#declare CircularHullTex2 =                                           
texture {
crackle metric 1   
texture_map {
[.25 T7]     
[.75 T8]
}
scale <1/160/3,1,1> 
warp {cylindrical} 
rotate 90*x 
}    
#declare CircularHullTex2A =                                           
texture {
crackle metric 1   
texture_map {
[.25 T7]     
[.75 T8]
}
scale <1/80,1,1> 
warp {cylindrical} 
scale 1/4
rotate 90*x 
} 
#declare CircularHullTex3 =                                           
texture {
crackle metric 1   
texture_map {
[.25 T9]     
[.75 T10]
}
scale <1/90,1,1> 
warp {cylindrical} 
rotate 90*x 
}


#declare Side =
union { 
difference {
sphere {0,1 scale <25,25,25>}
plane {-z,0}   
plane {z,0 translate -22*z}     
cylinder {-30*z,-10*z,10}  
cylinder {-3*z,10*z,15}
} 
difference {  
torus {23,2 rotate 90*x}
cylinder {-4*z,4*z,23}
} 

difference {
cylinder {-22*z,-22.05*z,11.75}
cylinder {-23*z,-20*z,10.75}
texture {CircularHullTex}
} 
difference {
cylinder {-22*z,-22.05*z,10.5}
cylinder {-23*z,-20*z,10.25}
texture {CircularHullTex}
} 

difference {
cylinder {0,1.5*z,23} 
cone {-z/4,16,z*1.6,19}
cone {z*.75,18,z*1.6,19}
cone {z*1.25,20,z*1.6,21}
texture {CircularHullTex2}
}



#declare FrontBump1 = 
intersection {
cone {0,1,y/2.001,3/4 scale 200*z}   
cone {0,1/2,y/2,1/4 scale 200*x}  
scale 1/2
rotate -90*x translate 11.25*y  
translate -22*z
}
   
#declare FrontBump2 = 
intersection {
cone {0,1,y/2.001,3/4 scale 200*z}   
cone {0,1/2,y/2,1/4 scale 200*x}  
scale 1/2     
scale <1.5,1/2,.75>
rotate -90*x translate 10.625*y  
translate -22*z
} 
#declare RearBump1 = 
intersection {
cone {0,1,y/2.001,3/4 scale 200*z}   
cone {0,1/2,y/2,1/4 scale 200*x}  
scale 1     
scale <1,2,1>
rotate 90*x rotate 90*z rotate 30*x translate 22.5*y  
translate z
}
#declare RearBump2 = 
intersection {
cone {0,1,y/2.001,3/4 scale 200*z}   
cone {0,1/2,y/2,1/4 scale 200*x}  
scale 1     
scale <2,.75,1/2>
rotate 90*x translate 20*y  
translate z
}

union {
#declare C=0
#while (C<360)
object {FrontBump1 rotate C*z}
#declare C=C+8
#end  
#declare C=0
#while (C<360)
object {FrontBump2 rotate C*z}
#declare C=C+10
#end   
#declare C=0
#while (C<360)
object {RearBump1 rotate C*z}
#declare C=C+6
#end 
union {
#declare C=0
#while (C<360)
object {RearBump2 rotate C*z}
#declare C=C+12
#end   
#declare C=0
#while (C<360)
object {RearBump2 translate -y rotate C*z}
#declare C=C+12
#end   
texture {CircularHullTex3}
}
texture {CircularHullTex2} 
}    

//rotate 90*x
}

object {Side 
texture { 
material_map {
sys "b8test"
texture {T1}
texture {T2}
texture {T3}
texture {T4}
texture {T5}
texture {T6}
}
scale <1/30,1,1> 
warp {cylindrical}
rotate 90*x
scale 23
}
translate -5*z
}
object {Side scale -z*2 
texture { 
material_map {
sys "b8test2"
texture {T1 scale z/3}
texture {T2 scale z/3}
texture {T3 scale z/3}
texture {T4 scale z/3}
texture {T5 scale z/3}
texture {T6 scale z/3}
}
scale <1/30,1,1> 
warp {cylindrical}
rotate 90*x
scale 23 
scale z*2  
translate -25/2*z
}
translate 5*z
}     
 
#declare BigSecondaryTex =
texture { 
material_map {
sys "b8test"
texture {T1}
texture {T2}
texture {T3}
texture {T4}
texture {T5}
texture {T6}
}
scale <1/10,1,1> 
warp {cylindrical}
rotate 90*x
scale 23
} 

#declare SmallSecondaryTex =
texture { 
material_map {
sys "b8test3"
texture {T1A}
texture {T2A}
texture {T3A}
texture {T4}
texture {T5}
texture {T6}
}
scale <1/16,1,1> 
warp {cylindrical}
rotate 90*x
scale 23
}

 
union {
difference {
union {
cylinder {-20*z,-30*z,8}
torus {6,2 rotate 90*x translate -30*z}
torus {6,2 rotate 90*x translate -20*z}
}
cylinder {-15*z,-35*z,6}
} 
difference {
union {
cylinder {-20*z,-35*z,5.5}
torus {4.5,1 rotate 90*x translate -35*z}
torus {4.5,1 rotate 90*x translate -20*z}
}
cylinder {-15*z,-40*z,4.5} 
scale 1  
texture {BigSecondaryTex scale -z*2 translate 55*z} 
}
#declare C=0
#while (C<360)
cylinder {<0,5.2,-32>,<0,6,-32>,.05 rotate C*z}
#declare C=C+4
#end  
#declare C=0
#while (C<360)
cylinder {<0,5.2,-32>,<0,6,-32>,.025 rotate C*z}
#declare C=C+1
#end


texture {BigSecondaryTex} 

translate -5*z
} 


union {
difference {
union {
cylinder {-20*z,-30*z,8}
torus {6,2 rotate 90*x translate -30*z}
torus {6,2 rotate 90*x translate -20*z}
}
cylinder {-15*z,-35*z,6}
} 
difference {
union {
cylinder {-20*z,-35*z,5.5}
torus {3.5,2 rotate 90*x translate -35*z}
torus {3.5,2 rotate 90*x translate -20*z}
}
cylinder {-15*z,-40*z,3.5}
scale 1.125 
}
scale 1.125   
texture { 
material_map {
sys "b8test2"
texture {T1 scale z/3}
texture {T2 scale z/3}
texture {T3 scale z/3}
texture {T4 scale z/3}
texture {T5 scale z/3}
texture {T6 scale z/3}
}
scale <1/10,1,1> 
warp {cylindrical}
rotate 90*x
scale 23 
scale z*2  
translate -25/2*z
}  
scale -z
translate 25*z
}

union {
object {ForeSupport scale 2 translate <0,8.5,-30>}
object {ForeSupport scale 2 translate <0,8.5,-30> rotate 90*z}
object {ForeSupport scale 2 translate <0,8.5,-30> rotate -90*z}
object {ForeSupport scale 2 translate <0,8.5,-30> rotate 180*z}
object {ForeSupport scale 2 translate <0,9,-26*2> scale -z}
object {ForeSupport scale 2 translate <0,9,-26*2> scale -z rotate 90*z}
object {ForeSupport scale 2 translate <0,9,-26*2> scale -z rotate -90*z}
object {ForeSupport scale 2 translate <0,9,-26*2> scale -z rotate 180*z}
//texture {CircularHullTex} 
texture {SmallSecondaryTex rotate 22.5/2*z}  
rotate 45*z
}

#declare BayBump1 = 
intersection {
cone {0,1,y/2.001,3/4 scale 200*z}   
cone {0,1/2,y/2,1/4 scale 200*x}  
scale <1,1,1>/3
rotate -90*x rotate 90*z rotate 30*x translate -40*z translate y*3  
}  
#declare BayBump2 =
union { 
intersection {
cone {0,1,y/2.001,3/4 scale 200*z}   
cone {0,1/2,y/2,1/4 scale 200*x}  
scale <2,3,1>*2/3
rotate -90*x rotate 90*z rotate -30*x translate -39.5*z translate y*4.5  
}   
intersection {
cone {0,1,y/2.001,3/4 scale 200*z}   
cone {0,1/2,y/2,1/4 scale 200*x}  
scale <2/3,3.5,1/4>*2/3
rotate -90*x rotate 90*z rotate -30*x translate -39.5*z translate y*4.5  
} 
}

union {
difference {
cylinder {-40*z,-40.1*z,4.5}
cylinder {-39*z,-41*z,2.5}
texture {CircularHullTex2A}
}
union {
difference {
cylinder {-40*z,-40.05*z,4.5}
cylinder {-39*z,-41*z,1.5}     
box {<-4,-1,-39>,<4,1,-41>}
}
#declare C=0
#while (C<360)
object {BayBump1 rotate C*z}
#declare C=C+7.5
#end 
#declare C=0
#while (C<360)
object {BayBump2 rotate C*z}
#declare C=C+15
#end

cylinder {<0,0,-10>,<0,0,-40>,2.75 open}
light_source {<0,0,-30> rgb x fade_distance 12 fade_power 2}

union {  

height_field {tga "bayGrill" water_level .01
scale <4.5,.125,24> translate <-2.25,-1.5,-40>
} 
height_field {tga "bayGrill" water_level .01
scale <4.5,.125,24> translate <-2.25,-1.5,-40>
scale -y     
}  

height_field {tga "bayGrill" water_level .01 
scale <4.5,.125,24> translate <-2.25,-2,-40>        
rotate 90*z
} 
height_field {tga "bayGrill" water_level .01 
scale <4.5,.125,24> translate <-2.25,-2,-40>
scale -y 
rotate 90*z    
} 

#declare C=0
#while (C<30)
torus {2.75,.125 rotate 90*x  translate z*(C-40)}
#declare C=C+1
#end
texture {CircularHullTex3}
}
#declare BayPanelSupport = 
height_field {tga "baybump" water_level .01 smooth
scale <1,.25,1> translate <-.25,0,0> rotate -90*x translate -40*z
} 
union {
object {BayPanel scale 1/5 rotate 90*y rotate -45*x translate < 1.5,1.25,-40.125>}  
object {BayPanel scale 1/5 rotate 90*y rotate -45*x translate < 1.5,1.25,-40.125> scale -x}
object {BayPanel scale 1/5 rotate 90*y rotate -45*x translate <-1.5,1.25,-40.125> scale -y}
object {BayPanel scale 1/5 rotate 90*y rotate -45*x translate <-1.5,1.25,-40.125> scale -y scale -x}
}
union {
object {BayPanelSupport translate < 1.125,1.125,0>}
object {BayPanelSupport translate < 1.125,1.125,0> scale -x}
object {BayPanelSupport translate < 1.125,1.125,0> scale -y}
object {BayPanelSupport translate < 1.125,1.125,0> scale -y scale -x}
texture {PanelTex2  scale 1/8}
}
texture {CircularHullTex2A}
}
//translate -z/2
}

cylinder {-6*z,6*z,17.5 texture {CircularHullTex} }       


union {
SolarPowerSetup 
scale 2.5 
translate 26.5*y 
texture {DefineHullTex}  
rotate 0*z 
translate 6*z
}
union {
SolarPowerSetup 
scale 2.5 
translate 26.5*y 
texture {DefineHullTex}      
scale -y
scale -x 
rotate 0*z
translate 6*z
}   


#declare HullTex1 =                                           
texture {
crackle metric 1   
texture_map {
[.25 T7]     
[.75 T8]
}
//rotate 90*x 
}   
#declare HullTex2 =                                           
texture {
crackle metric 1   
texture_map {
[.25 T9]     
[.75 T10]
}
//rotate 90*x 
}
 

#declare TopProng =
difference {
intersection {
cone {0,10,y*4,9 scale 2000*z}
cone {-y/100,19,y*4.0001,17 scale 2000*z rotate 10*y translate 60*z}
cone {-y/100,19,y*4.0001,17 scale 2000*z rotate 10*y translate 60*z scale -x}
cone {-y/100,30+20,y*4.0001,14+20 scale 2000*x translate 20*z}
}
cone {-z/100,2.75,z*15,2.25 scale 2000*y translate -30.01*z}         
disc {0,z,10 translate -29*z}  
cone {y*3.6,1,y*4.001,2 scale 2000*z translate -30.01*z}         
cone {x*8,20,x*10.01,24 scale 2000*y translate 30*z}         
cone {-x*8,20,-x*10.01,24 scale 2000*y translate 30*z}         
cone {0,6,-z*4,5 scale 2000*y translate 15*z}     
box {<-6,-10,14.9999>,<6,10,600>}

cone {0,7,-z*4,5 scale 2000*y translate 19*z}     
box {<-7,-10,18.9999>,<7,10,600>}

box {<-2,-4,60>,<2,3,-60>}    
    
} 

#declare BottomProng = 
union {
difference {
intersection {
cone {0,10,y*4,10 scale 2000*z}
cone {-y/100,19,y*4.0001,19 scale 2000*z rotate 10*y translate 60*z}
cone {-y/100,19,y*4.0001,19 scale 2000*z rotate 10*y translate 60*z scale -x}
cone {-y/100,30+20,y*4.0001,30+20 scale 2000*x translate 20*z}
}
cone {-z/100,2.75,z*15,2.25 scale 2000*y translate -30.01*z}         
disc {0,z,10 translate -29*z}  
cone {y*3.6,1,y*4.001,2 scale 2000*z translate -30.01*z}         
cone {x*8,20,x*10.01,24 scale 2000*y translate 30*z}         
cone {-x*8,20,-x*10.01,24 scale 2000*y translate 30*z}         
cone {0,6,-z*4,5 scale 2000*y translate 15*z}     
box {<-6,-10,14.9999>,<6,10,600>}  

cone {0,7,-z*4,5 scale 2000*y translate 19*z}     
box {<-7,-10,18.9999>,<7,10,600>}
  
}

union {
#declare C=0
#while (C<30)
box {<-1/4,3.5,1>,<0,.5,-1> translate -C*z} 
#declare C=C+2.5
#end
rotate -10*y translate -8.7*x
}   
union {
#declare C=0
#while (C<30)
box {<1/4,3.5,1>,<0,.5,-1> translate -C*z} 
#declare C=C+2.5
#end
rotate 10*y translate 8.7*x 
}
}

union {
object {TopProng scale y} 
object {BottomProng scale -y/4}
texture {HullTex1 scale 3/4}  
translate <0,-2,-55>    
scale y*.75 
scale x*1.125
}      
light_source {<0,0,-60> rgb x fade_distance 8 fade_power 2 shadowless}

height_field {tga "bayGrill" water_level .01
scale <4,.125/2,24> translate <-2,-1.5,-73> 
texture {HullTex2 scale 1/2} 
}  

height_field {tga "bayGrill" water_level .01
scale <4,-.125/2,24> translate <-2,.5,-73> 
texture {HullTex2 scale 1/2} 
}



 
#declare Part1 = 
difference {
intersection {
union {
cone {0,2,y*2,1 scale z/4}
cylinder {0,-y/2,2 scale z/4}
cone {-y/2,2,-y,1 scale z/4}
}
box {<-2.1,-1.1,.125>,<2.1,2.1,-.125>}
}
cone {y*1.75,.75,y/8,.5 scale 2*z}
cone {-y/8,.5,-y*.75,.75 scale 2*z}

cone {-x,.5,-x*1.5,.25 scale 2*z}
cone {x,.5,x*1.5,.25 scale 2*z}


}

#declare Part2 = 
intersection {
union {
cone {0,2,y*2,1 scale z/4}
cylinder {0,-y/2,2 scale z/4}
cone {-y/2,2,-y,1 scale z/4}
}
box {<-2.1,-1.1,.125>,<2.1,2.1,-.125>}
}

#declare Bay1 = 
union {
object {Part1 texture {HullTex scale 2} translate z}   
object {Part1 texture {HullTex scale 2} translate -z}    
object {Part2 texture {ColoredHullTex scale 2} scale .95 scale 8.5*z} 
scale 1.45 
scale x*1.25
}  

union {
object {Bay1 translate <0,3.25,-45>}  
object {Bay1 translate <0,3.25,-48.4>}
object {Bay1 translate <0,3.25,-51.8>}
object {Bay1 translate <0,3.25,-55.2>}
object {Bay1 translate <0,3.25,-58.6>}
object {Bay1 translate <0,3.25,-62>}    
translate -2*z
} 




#declare Bay2 = 
union {
object {Part1 texture {HullTex scale 2} translate z}   
object {Part1 texture {HullTex scale 2} translate -z}    
object {Part2 texture {HullTex2 scale 1/2} scale .95 scale 8*z} 
scale 1
}  

union {
object {Bay2 rotate 90*z translate <-10,0,-27>}  
object {Bay2 rotate 90*z translate <-10,0,-29.5>}
object {Bay2 rotate 90*z translate <-10,0,-32>}
object {Bay2 rotate 90*z translate <-10,0,-33.5>}   
object {Bay2 rotate 90*z translate <-10,0,-36>}
object {Bay2 rotate 90*z translate <-10,0,-38.5>}
object {Bay2 rotate 90*z translate <-10,0,-41>}
object {Bay2 rotate 90*z translate <-10,0,-43.5>}        
       

object {Bay2 rotate -90*z translate <10,0,-27>}  
object {Bay2 rotate -90*z translate <10,0,-29.5>}
object {Bay2 rotate -90*z translate <10,0,-32>}
object {Bay2 rotate -90*z translate <10,0,-33.5>}   
object {Bay2 rotate -90*z translate <10,0,-36>}
object {Bay2 rotate -90*z translate <10,0,-38.5>}
object {Bay2 rotate -90*z translate <10,0,-41>}  
object {Bay2 rotate -90*z translate <10,0,-43.5>}

translate -2*z
}
