// $Id: main.cc,v 1.6 2001/08/05 22:31:44 peter Exp $

#include "cvector.hh"
#include "cray.hh"
#include "cintrsct.hh"
#include "cobject.hh"
#include "csphere.hh"
#include "cplane.hh"
#include "cbox.hh"
#include "cmesh.hh"
#include "ccamera.hh"
#include <cmath>

int main (void) {

	CBox Box = CBox (CVector(-0.5), CVector(0.5));
//	Box.Rotate(CVector(0,30,0));
//	Box.Rotate(CVector(-30,0,0));
 	
	CSphere Sphere = CSphere ( CVector (0,1,0), 0.5 );
//	Sphere.Scale(CVector(1,0.5,1));
// Sphere.Rotate(CVector(30,0,0));
// Sphere.Translate(CVector(0,0.5,0));	

	CPlane Plane = CPlane (CVector(0,1,0),-0.5);
	
	CMesh Mesh;
	Mesh.AddObject (Sphere);
	Mesh.AddObject (Plane);
	Mesh.AddObject (Box);

	CVector LightSource = CVector(2,1.5,-1);

	CCamera Camera = CCamera(CVector(2,3,-8), CVector(0));
	Camera.Angle(30);
	Camera.LookAt(CVector(0,0.5,0));
	Camera.Render(Mesh, LightSource, 160, 120);

	return 0;
}

// $Log: main.cc,v $
// Revision 1.6  2001/08/05 22:31:44  peter
// *** empty log message ***
//
// Revision 1.5  2001/07/29 06:19:01  peter
// Added an object counter. object ID and print method to each class. Fixed
// various annoying little bugs.
//
// Revision 1.4  2001/07/27 12:53:20  peter
// Revision 1.3  2001/07/23 07:11:51  peter
// Revision 1.2  2001/07/22 23:06:50  peter
// Revision 1.1  2001/07/22 20:44:12  peter
// Initial version in CVS
