// $Id: ctransf.hh,v 1.3 2001/07/31 18:42:03 peter Exp $

#ifndef CTRANSF_HH_
#define CTRANSF_HH_

#include "cmatrix.hh"
#include "cvector.hh"

// class CVector;

// A class to implement linear transformations of 3D vectors using a 4x4 transformation
// matrix. The fourth column stores the translation, if any. The fourth row is <0,0,0,1>
class CTransform {
	public:

		// The actual transformation matrix
		CMatrix Transform;

		// The inverse of the transformation matrix, used for inverse transforms
		CMatrix Inverse;

		// Initialized to an identity transform
		CTransform ();
		CTransform (const CMatrix &);
		~CTransform ();

		static int Count;
		int Number;

		// Create a scaling transformation matrix. The amount of scaling along the x, y
		// and z axes is specified by the respective components of the vector parameter.
		void Scale (const CVector &);

		// Create a rotation transformation matrix. Rotates (orbits!) about x first, then
		// about y and lastly about z. Angle is in degrees.
		void Rotate (const CVector &);

		// Create a translation transformation matrix.
		void Translate (const CVector &);

		// Allows for explicitly specifying the transformation matrix. Note that the last
		// row will be overridden by <0,0,0,1>
		void Explicit (const CMatrix &);

		// Stack two transformations
		CTransform operator * ( const CTransform & );

		int Id();
		void Print();
};

#endif

// $Log: ctransf.hh,v $
// Revision 1.3  2001/07/31 18:42:03  peter
// Finally added some comments. Finalized CVector (I think...)
//
// Revision 1.2  2001/07/29 06:19:01  peter
// Added an object counter. object ID and print method to each class. Fixed
// various annoying little bugs.
//
// Revision 1.1  2001/07/27 12:51:17  peter
// Created a transform class to use with CVector, CRay and CObject*
//
