// $Id: csphere.hh,v 1.2 2001/08/05 22:24:58 peter Exp $

#ifndef CSPHERE_HH_
#define CSPHERE_HH_

#include "consts.hh"
#include "cobject.hh"

class CVector;
class CRay;
class CIntersection;

class CSphere : public CObject {
	private:
		CVector center;
		double radius;

		// Calculated in the constructors, as it is heavily used in intersections
		double radiussquared;

	public:
		CSphere ();
		CSphere (const CVector &, double);
		CSphere (const CSphere &);

		// Make the compiler happy with a virtual destructor
		~CSphere ();
		
		// I know 'virtual' is optional, but it clears things up
		// See cobject.hh
		virtual bool Inside ( const CVector & ) const;  
		virtual IStack Intersect (const CRay &) const;
		virtual CVector NormalAt (const CVector &) const;

		CVector Center() const;
		double Radius() const;

		void Print() const;
};

#endif

// $Log: csphere.hh,v $
// Revision 1.2  2001/08/05 22:24:58  peter
// Added transformation related member functions to CObject and derived.
// Added plane object ( class CPlane : public CObject )
// Intersect, Inside and NormalAt member functions take into account
// object transformations. FIXME: Not all objects do this yet.
//
// Revision 1.1  2001/07/31 18:42:03  peter
// Finally added some comments. Finalized CVector (I think...)
//
