// $Id: cplane.cc,v 1.1 2001/08/05 22:24:58 peter Exp $

#ifndef CPLANE_CC_
#define CPLANE_CC_

#include "consts.hh"
#include "cvector.hh"
#include "cray.hh"
#include "cintrsct.hh"
#include "cplane.hh"
#include <iostream>

CPlane::CPlane () {
	normal = CVector(0,1,0);
	distance = 0.0;
}

CPlane::CPlane (const CVector &V1, double D1) {
	normal = V1.Norm();
	distance = -D1;
}

CVector CPlane::NormalAt (const CVector &V1) const {
	return normal;
}

bool CPlane::Inside( const CVector &V1) const {
	double tmp = VDot (V1, normal);
	return((tmp + distance) < SOMETHING_SMALL);
}

IStack CPlane::Intersect (const CRay & R1) const {
	IStack Intersection;
	
	double tmp1 = VDot (normal, R1.Direction());

	if (fabs(tmp1) > SOMETHING_SMALL) {
		double tmp2 = VDot (normal, R1.Origin());
		double depth = -(distance + tmp2) / tmp1;
		if (depth > SOMETHING_SMALL)
			Intersection.push (CIntersection (depth, this));
	}
	
	return Intersection;
}

void CPlane::Print() const {
	cout.precision(8);
	cout << "plane { ";
	normal.Print();
	cout << ", " << -distance << " }\n";
}

#endif

// $Log: cplane.cc,v $
// Revision 1.1  2001/08/05 22:24:58  peter
// Added transformation related member functions to CObject and derived.
// Added plane object ( class CPlane : public CObject )
// Intersect, Inside and NormalAt member functions take into account
// object transformations. FIXME: Not all objects do this yet.
//
