// $Id: cnode.hh,v 1.7 2001/08/05 22:31:58 peter Exp $

#ifndef CNODE_HH_
#define CNODE_HH_

// Basic class declarations

#include "cvector.hh"
#include "cforce.hh"
#include <vector>

class CLink;

// A node is a point-mass connected to neighbouring nodes using links. See
// clink.hh and clink.cc
class CNode {
	private:

		// The mass the node stores
		double mass;

		// The current position of the node
		CVector position;

		// The node's instantaneous velocity
		CVector velocity;

		// The location the node will go to in the next iteration
		CVector new_position;

		// The links, constraints and external forces relevant to this node.
		// They may be shared by other nodes, so pointers are used.
		vector <CForce *> External;
		vector <CForce *> Constraints;
		vector <CLink *> Links;

		// Mainly for debugging, also for identification
		int Number;
		static int Count;
	public:

		// Links may be added later
		CNode ();

		// Create a node at a given location and having a given mass. This 
		// constructor will be used most often.
		CNode(CVector, double);

		// Only needed to decrease the object counter
		~CNode ();
		
		// Places an existing node at a given location.
		void Set(CVector);

		// Returns the current position of the node
		CVector Position();

		// Calculate the node's potision in the new iteration.
		void Calculate(double);

		// Move the node to its new position
		void Update();

		// Add a link, constraint or external force to the node
		void AddLink(CLink *);
		void AddConstraint(CForce *);
		void AddExternal(CForce *);

		// For debugging and identification
		int Id();
		void Print();
};

#endif

// $Log: cnode.hh,v $
// Revision 1.7  2001/08/05 22:31:58  peter
// Addressed a few minor issues
//
// Revision 1.6  2001/07/31 18:42:03  peter
// Finally added some comments. Finalized CVector (I think...)
//
// Revision 1.5  2001/07/29 06:19:01  peter
// Added an object counter. object ID and print method to each class. Fixed
// various annoying little bugs.
//
// Revision 1.4  2001/07/23 07:33:24  peter
// Added CVS information
//
// Revision 1.1  2001/07/23 07:11:51  peter
// Made it a real header file for cnode.cc
