// $Id: cnode.cc,v 1.5 2001/08/05 22:31:58 peter Exp $

#ifndef CNODE_CC_
#define CNODE_CC_ 

// Basic class declarations

#include "clink.hh"
#include "cnode.hh"
#include "cvector.hh"

class CLink;

int CNode::Count = 0;

CNode::CNode () {
	position = CVector(0,0,0);

	// This is intentional. It will give a division by zero error and thus
	// warn about the node not being initialized;
	mass = 0;
	Count++;
}

void CNode::Set(CVector P) {
	position = P;
}

CNode::~CNode () {
	Count--;
}

CVector CNode::Position() {
	return position;
}

void CNode::Update() {
	position = new_position;
}

void CNode::AddLink(CLink *L1) {
	Links.push_back(L1);
}

void CNode::AddConstraint(CForce *F1) {
	Constraints.push_back(F1);
}

void CNode::AddExternal(CForce *F1) {
	External.push_back(F1);
}

CNode::CNode(CVector P, double M) {
	position = P; mass = M;
}

// Calculates the new position of the node, i.e. where it will end up after time dt.
void CNode::Calculate (double dt) {

	// The resultant force
	CVector R;
	
	// The acceleration due to R
	CVector a;
	
	// Sum all forces along connected links into the resultant R
	for (std::vector<CLink *>::iterator i = Links.begin(); i != Links.end(); i++) {
		R = R + (*i)->VForce();
		// Wow, this is hard stuff! :)
		a = R/mass;

		// Integrate once, determine velocity
		velocity = velocity*(1-(*i)->Dampfing()) + a*dt;
	}
	
	// TODO: Take into account external forces and constraints
	// TODO: THIS FUNCTION HAS TO BE DRASTICALLY OPTIMIZED!!!!
	
	// Integrate again, find displacement. Transform to the global coordinate system
	// and voila!
   new_position = position + velocity * dt;
}

int CNode::Id () {
	return Number;
}

void CNode::Print () {
	std::vector <CLink *>::iterator il;
	std::vector <CForce *>::iterator ie;
	std::vector <CForce *>::iterator ic;
	
	cout << "Node Id: " << Number;
	if ( Links.size() ) {
		cout << "\n |---- Links: ";
		for ( il = Links.begin(); il != Links.end(); il++ )
		  cout << (*il)->Id() << " ";
		cout << "\n";
	}

	if ( External.size() ) {
		cout << "\n |---- External forces: ";
		for ( ie = External.begin(); ie != External.end(); ie++ )
		  cout << (*il)->Id() << " ";
		cout << "\n";
	}

	if ( Links.size() ) {
		cout << "\n |---- Constraints: ";
		for ( ic = Constraints.begin(); ic != Constraints.end(); ic++ )
		  cout << (*ic)->Id() << " ";
		cout << "\n";
	}

}

#endif

// $Log: cnode.cc,v $
// Revision 1.5  2001/08/05 22:31:58  peter
// Addressed a few minor issues
//
// Revision 1.4  2001/07/31 18:42:03  peter
// Finally added some comments. Finalized CVector (I think...)
//
// Revision 1.3  2001/07/29 06:19:01  peter
// Added an object counter. object ID and print method to each class. Fixed
// various annoying little bugs.
//
// Revision 1.2  2001/07/23 07:33:24  peter
// Added CVS information
//
// Revision 1.1  2001/07/23 07:11:51  peter
// Separated class CNode for separate compilation
