// $Id: cmatrix.hh,v 1.3 2001/07/31 18:42:03 peter Exp $

#ifndef CMATRIX_HH_
#define CMATRIX_HH_

#include "cvector.hh"

const double NullMatrix [4][4] = {
	{0, 0, 0, 0},
	{0, 0, 0, 0},
	{0, 0, 0, 0},
	{0, 0, 0, 0}
};

const double IdentityMatrix [4][4] = {
	{1, 0, 0, 0},
	{0, 1, 0, 0},
	{0, 0, 1, 0},
	{0, 0, 0, 1}
};

// A 4x4 matrix for use in linear transformations of 3D vectors.
// The fourth row is used for translations.
// This is an attempt to duplicate POV's approach to matrix transformations.

// Please only use the CMatrix class for transformations if you really
// know what you are doing. The CTransform class (see ctransf.hh) provides
// an easy interface itransforming vectors. CMatrix is just to help CTransform
// do its job.

class CMatrix {
	public:
		double Elements [4][4];

		// These two are mostly used for debugging purposes
		static int Count;
		int Number;
		
		// Initialized to an identity matrix
		CMatrix ();

		// A copy-constructor is necessary to properly increase the object counter
		CMatrix (const CMatrix &);

		// This, along with the two 'operator =' functions, will be most often used.
		CMatrix (const double [4][4]);

		// Only really need it because of the object counter
		~CMatrix ();
		
		// Matrix multiplication. Most often used for stacking linear transformations.
		CMatrix operator * (const CMatrix &);

		// These are just shortcuts
		CMatrix& operator = (const double [4][4]);
		CMatrix& operator = (const CMatrix &);
		
		// Transpose the matrix
		void Transpose();

		// Invert the matrix. Exits with an error if the matrix is singular.
		// Also available as a non-member function
		void Invert();

		// Mostly used for debugging purposes.
		// Also available as a non-member function
		int Id();
		void Print();
};

// Returns the transpose of a matrix
// Also available as a member function of class CMatrix
CMatrix TransposeOf ( const CMatrix & );

// Returns the inverse of a matrix, if nonsingular. Otherwise exits with an error.
// Also available as a member function of class CMatrix
CMatrix InverseOf ( const CMatrix & );

#endif

// $Log: cmatrix.hh,v $
// Revision 1.3  2001/07/31 18:42:03  peter
// Finally added some comments. Finalized CVector (I think...)
//
// Revision 1.2  2001/07/29 06:16:44  peter
// Added constructor from a 4x4 array of double.
// Added Invert() and ``operator = (const CMatrix &)'' member functions.
// Fixed a stupid bug in Transpose().
//
// Revision 1.1  2001/07/27 12:50:01  peter
// Created. A lot of functions still to be added.
//
