// $Id: cmatrix.cc,v 1.4 2001/08/05 22:27:01 peter Exp $

#ifndef CMATRIX_CC_
#define CMATRIX_CC_

#include "cmatrix.hh"
#include "cvector.hh"
#include <iostream>

int CMatrix::Count = 0;

CMatrix::CMatrix() {
	*this = IdentityMatrix;
	Number = ++Count;
}

CMatrix::CMatrix (const CMatrix &M1) {
	*this = M1;
	Number = ++Count;
}

CMatrix::CMatrix (const double A[4][4]) {
	unsigned char i, j;

	for (i = 0; i < 4; i++)
		for (j = 0; j < 4; j++)
			Elements[i][j] = A[i][j];

	Number = ++Count;
};

CMatrix::~CMatrix () {
	Count--;
}

CMatrix CMatrix::operator * (const CMatrix &M1) {
	unsigned char i, j, k;
	CMatrix Result = NullMatrix;

	for (i = 0 ; i < 4 ; i++) 
		for (j = 0 ; j < 4 ; j++) 
			for (k = 0 ; k < 4 ; k++) 
				Result.Elements[i][j] += this->Elements[i][k] * M1.Elements[k][j];

	return Result;
}

void CMatrix::Transpose () {
	unsigned char i, j;
	double tmp;

	for (i = 0 ; i < 4 ; i++)
		for (j = 0 ; j < 4 ; j++) {
			tmp = Elements[i][j];
			Elements [i][j] = Elements [j][i];
			Elements [j][i] = tmp;
		}
}

// Calculate the inverse of a matrix by dividing each element by the determinant
// of the adjoint matrix, then transposing it
void CMatrix::Invert() {
	double Determinant, Minor[4][4], Temp[4][4];
	unsigned char i, j;

	for (i = 0; i < 4; i++)
		for (j = 0; j < 4; j++)
			Temp[i][j] = Elements[i][j];

	Minor[0][0] = Temp[1][1]*Temp[2][2]*Temp[3][3] + Temp[1][2]*Temp[2][3]*Temp[3][1] + 
	              Temp[1][3]*Temp[2][1]*Temp[3][2] - Temp[3][1]*Temp[2][2]*Temp[1][3] - 
	              Temp[3][2]*Temp[2][3]*Temp[1][1] - Temp[3][3]*Temp[2][1]*Temp[1][2];
  
	Minor[0][1] = Temp[1][0]*Temp[2][2]*Temp[3][3] + Temp[1][2]*Temp[2][3]*Temp[3][0] +
	              Temp[1][3]*Temp[2][0]*Temp[3][2] - Temp[3][0]*Temp[2][2]*Temp[1][3] -
	              Temp[3][2]*Temp[2][3]*Temp[1][0] - Temp[3][3]*Temp[2][0]*Temp[1][2];
  
	Minor[0][2] = Temp[1][0]*Temp[2][1]*Temp[3][3] + Temp[1][1]*Temp[2][3]*Temp[3][0] +
	              Temp[1][3]*Temp[2][0]*Temp[3][1] - Temp[3][0]*Temp[2][1]*Temp[1][3] -
	              Temp[3][1]*Temp[2][3]*Temp[1][0] - Temp[3][3]*Temp[2][0]*Temp[1][1];
  
	Minor[0][3] = Temp[1][0]*Temp[2][1]*Temp[3][2] + Temp[1][1]*Temp[2][2]*Temp[3][0] +
	              Temp[1][2]*Temp[2][0]*Temp[3][1] - Temp[3][0]*Temp[2][1]*Temp[1][2] -
	              Temp[3][1]*Temp[2][2]*Temp[1][0] - Temp[3][2]*Temp[2][0]*Temp[1][1];

	Minor[1][0] = Temp[0][1]*Temp[2][2]*Temp[3][3] + Temp[0][2]*Temp[2][3]*Temp[3][1] +
	              Temp[0][3]*Temp[2][1]*Temp[3][2] - Temp[3][1]*Temp[2][2]*Temp[0][3] -
	              Temp[3][2]*Temp[2][3]*Temp[0][1] - Temp[3][3]*Temp[2][1]*Temp[0][2];
  
	Minor[1][1] = Temp[0][0]*Temp[2][2]*Temp[3][3] + Temp[0][2]*Temp[2][3]*Temp[3][0] +
	              Temp[0][3]*Temp[2][0]*Temp[3][2] - Temp[3][0]*Temp[2][2]*Temp[0][3] -
	              Temp[3][2]*Temp[2][3]*Temp[0][0] - Temp[3][3]*Temp[2][0]*Temp[0][2];
  
	Minor[1][2] = Temp[0][0]*Temp[2][1]*Temp[3][3] + Temp[0][1]*Temp[2][3]*Temp[3][0] +
	              Temp[0][3]*Temp[2][0]*Temp[3][1] - Temp[3][0]*Temp[2][1]*Temp[0][3] -
	              Temp[3][1]*Temp[2][3]*Temp[0][0] - Temp[3][3]*Temp[2][0]*Temp[0][1];
  
	Minor[1][3] = Temp[0][0]*Temp[2][1]*Temp[3][2] + Temp[0][1]*Temp[2][2]*Temp[3][0] +
	              Temp[0][2]*Temp[2][0]*Temp[3][1] - Temp[3][0]*Temp[2][1]*Temp[0][2] -
	              Temp[3][1]*Temp[2][2]*Temp[0][0] - Temp[3][2]*Temp[2][0]*Temp[0][1];

	Minor[2][0] = Temp[0][1]*Temp[1][2]*Temp[3][3] + Temp[0][2]*Temp[1][3]*Temp[3][1] +
	              Temp[0][3]*Temp[1][1]*Temp[3][2] - Temp[3][1]*Temp[1][2]*Temp[0][3] -
	              Temp[3][2]*Temp[1][3]*Temp[0][1] - Temp[3][3]*Temp[1][1]*Temp[0][2];
  
	Minor[2][1] = Temp[0][0]*Temp[1][2]*Temp[3][3] + Temp[0][2]*Temp[1][3]*Temp[3][0] +
	              Temp[0][3]*Temp[1][0]*Temp[3][2] - Temp[3][0]*Temp[1][2]*Temp[0][3] -
	              Temp[3][2]*Temp[1][3]*Temp[0][0] - Temp[3][3]*Temp[1][0]*Temp[0][2];
  
	Minor[2][2] = Temp[0][0]*Temp[1][1]*Temp[3][3] + Temp[0][1]*Temp[1][3]*Temp[3][0] +
	              Temp[0][3]*Temp[1][0]*Temp[3][1] - Temp[3][0]*Temp[1][1]*Temp[0][3] -
	              Temp[3][1]*Temp[1][3]*Temp[0][0] - Temp[3][3]*Temp[1][0]*Temp[0][1];
  
	Minor[2][3] = Temp[0][0]*Temp[1][1]*Temp[3][2] + Temp[0][1]*Temp[1][2]*Temp[3][0] +
	              Temp[0][2]*Temp[1][0]*Temp[3][1] - Temp[3][0]*Temp[1][1]*Temp[0][2] -
	              Temp[3][1]*Temp[1][2]*Temp[0][0] - Temp[3][2]*Temp[1][0]*Temp[0][1];

	Minor[3][0] = Temp[0][1]*Temp[1][2]*Temp[2][3] + Temp[0][2]*Temp[1][3]*Temp[2][1] +
	              Temp[0][3]*Temp[1][1]*Temp[2][2] - Temp[2][1]*Temp[1][2]*Temp[0][3] -
	              Temp[2][2]*Temp[1][3]*Temp[0][1] - Temp[2][3]*Temp[1][1]*Temp[0][2];
  
	Minor[3][1] = Temp[0][0]*Temp[1][2]*Temp[2][3] + Temp[0][2]*Temp[1][3]*Temp[2][0] +
	              Temp[0][3]*Temp[1][0]*Temp[2][2] - Temp[2][0]*Temp[1][2]*Temp[0][3] -
	              Temp[2][2]*Temp[1][3]*Temp[0][0] - Temp[2][3]*Temp[1][0]*Temp[0][2];
  
	Minor[3][2] = Temp[0][0]*Temp[1][1]*Temp[2][3] + Temp[0][1]*Temp[1][3]*Temp[2][0] +
	              Temp[0][3]*Temp[1][0]*Temp[2][1] - Temp[2][0]*Temp[1][1]*Temp[0][3] -
	              Temp[2][1]*Temp[1][3]*Temp[0][0] - Temp[2][3]*Temp[1][0]*Temp[0][1];
  
	Minor[3][3] = Temp[0][0]*Temp[1][1]*Temp[2][2] + Temp[0][1]*Temp[1][2]*Temp[2][0] +
	              Temp[0][2]*Temp[1][0]*Temp[2][1] - Temp[2][0]*Temp[1][1]*Temp[0][2] -
	              Temp[2][1]*Temp[1][2]*Temp[0][0] - Temp[2][2]*Temp[1][0]*Temp[0][1];

	Determinant = Temp[0][0]*Minor[0][0] - Temp[0][1]*Minor[0][1] +
	              Temp[0][2]*Minor[0][2] - Temp[0][3]*Minor[0][3];

	if (Determinant == 0.0) {
		cout << "Can not invert a singular matrix. Exitting.\n";
		exit(1);
	}

	for ( i = 0; i < 4; i++)
		for ( j = 0; j < 4; j++) {
			// Note that the following line also transposes the result |
			Elements[i][j] = Minor[j][i] / Determinant; //             |
			//       ^__^___here___^__^________________________________/

			if ((i+j)%2)
				Elements[i][j] = -Elements[i][j];
		}
}
		
CMatrix& CMatrix::operator = (const CMatrix &M1) {
	unsigned int i, j;

	for (i = 0; i < 4; i++)
		for (j = 0; j < 4; j++)
			this->Elements[i][j] = M1.Elements[i][j];

	return *this;
}

CMatrix& CMatrix::operator = (const double A[4][4]) {
	unsigned int i, j;

	for (i = 0; i < 4; i++)
		for (j = 0; j < 4; j++)
			this->Elements[i][j] = A[i][j];

	return *this;
}

int CMatrix::Id () {
	return Number;
}

void CMatrix::Print () {
	unsigned char i, j;

	cout.precision(4);
	cout << "\nMatrix Id: " << Number << "\n";
	for ( i = 0; i < 4; i++ ) {
		for ( j = 0; j < 4; j++ ) {
			cout.width(12);
			cout << Elements[i][j];
		}
		cout << "\n";
	}
}

CMatrix InverseOf ( const CMatrix &M1 ) {
	CMatrix tmp = M1;
	tmp.Invert();
	return tmp;
}

CMatrix TransposeOf ( const CMatrix &M1 ) {
	CMatrix tmp = M1;
	tmp.Transpose();
	return tmp;
}

#endif

// $Log: cmatrix.cc,v $
// Revision 1.4  2001/08/05 22:27:01  peter
// Fixed bug in Inverse and InverseOf
// Fixed bug in Print
// The default constructor now properly assigns the identity matrix
//
// Revision 1.3  2001/07/31 18:42:03  peter
// Finally added some comments. Finalized CVector (I think...)
//
// Revision 1.2  2001/07/29 06:16:44  peter
// Added constructor from a 4x4 array of double.
// Added Invert() and ``operator = (const CMatrix &)'' member functions.
// Fixed a stupid bug in Transpose().
//
// Revision 1.1  2001/07/27 12:49:42  peter
// Created. A lot of functions still to be added.
//
