// $Id: clink.hh,v 1.5 2001/08/05 22:31:58 peter Exp $

#ifndef CLINK_HH_
#define CLINK_HH_

// Basic class declarations

#include "cvector.hh"
#include "cforce.hh"
#include <vector>

class CNode;

// A link carries on the interaction between two nodes. It is actually a
// parallel spring-dampfer system.
class CLink 
{
	private:

		// Used for internal calculations
		CVector force;
		double

			// The current length of the link
			length,

			// The initial length (i,e,, undeformed state, no stresses)
			initial_length,

			// The string constant in N/m
			spring_constant,

			// The viscuous dampfing coefficient
			dampfing_coefficient;


		// These two are mostly used for debugging purposes, but can also
		// used for identification
		static int Count;
		int Number;
		
	public:

		// The two nodes the link is connected to
		CNode * Node1;
      CNode * Node2;

		// An empty link makes no sense by itself, but nodes can be added to it later.
		CLink();

		// This will be used by CMesh::Tesselate (const CObject &) when I make it to there
		CLink (CNode *, CNode *, double, double);

		// Only needed to decrease the counter
		~CLink();

		// Returns the strain (relative elongation) of the link
		double Strain();

		// Returns the magnitude of the force along the link. It is somewhat redundant
		// since all it does is return (VForce()).Length()
		double DForce();

		// Returns the force resulting from deforming the link
		CVector VForce();

		// Returns the current length of the spring
		double Length();

		// Returns the damphing coefficient used. I don't have a use for it yet, but
		// may do when I get to colliding two meshes
		double Dampfing();

		// These two are used for debugging.
		int Id();
		void Print();
};

#endif

// $Log: clink.hh,v $
// Revision 1.5  2001/08/05 22:31:58  peter
// Addressed a few minor issues
//
// Revision 1.4  2001/07/31 18:42:03  peter
// Finally added some comments. Finalized CVector (I think...)
//
// Revision 1.3  2001/07/29 06:19:01  peter
// Added an object counter. object ID and print method to each class. Fixed
// various annoying little bugs.
//
// Revision 1.2  2001/07/23 07:33:24  peter
// Added CVS information
//
// Revision 1.1  2001/07/23 07:11:51  peter
// Made it a real header file
