// $Id: clink.cc,v 1.4 2001/07/31 18:42:03 peter Exp $

// TODO: proper calculation of dampfing_coefficient

#ifndef CLINK_CC_
#define CLINK_CC_

#include "cvector.hh"
#include "cforce.hh"
#include "clink.hh"
#include "cnode.hh"
#include <vector>
#include <iostream>

int CLink::Count = 0;

CLink::CLink() {
	Number = ++Count;
}

double CLink::Strain() {
	return (length-initial_length)/initial_length;
}

double CLink::DForce() {
	return force.Length();
}

CVector CLink::VForce() {
	return force;
}

double CLink::Length() {
	return length;
}

double CLink::Dampfing() {
	return dampfing_coefficient;
} 

CLink::CLink (CNode *N1, CNode *N2, double E, double c)
{ 
	Node1 = N1;
	Node2 = N2;
   CVector tmp = N1->Position() - N2->Position();
	initial_length = tmp.Length();
	length = initial_length;
	force = 0.0;
	spring_constant = E*length;
   dampfing_coefficient = c; 
}

int CLink::Id() {
	return Number;
}

void CLink::Print() {
	cout << "\nLink Id: " << Number;
	cout << "\n |---- Nodes: " << Node1->Id() << " and " << Node2->Id() 
		<< 
		"\n";
}	

CLink::~CLink () {
	Count--;
}

#endif

// $Log: clink.cc,v $
// Revision 1.4  2001/07/31 18:42:03  peter
// Finally added some comments. Finalized CVector (I think...)
//
// Revision 1.3  2001/07/29 06:19:01  peter
// Added an object counter. object ID and print method to each class. Fixed
// various annoying little bugs.
//
// Revision 1.2  2001/07/23 07:33:24  peter
// Added CVS information
//
// Revision 1.1  2001/07/23 07:11:51  peter
// Created
