// $Id: cforce.hh,v 1.5 2001/07/31 18:42:03 peter Exp $

#ifndef CFORCE_HH_
#define CFORCE_HH_ 

#include "cvector.hh"

// A force is like a vector (hence the inheritance), but also carries
// information about the type of force (external, static etc.) This
// information has not yet been coded in.
class CForce : public CVector {
	public:
		CForce () : CVector () { Number = Count++; }
		CForce (double D1, double D2, double D3) : CVector (D1, D2, D3) { Number = Count++;}
		CForce (double D1) : CVector (D1) { Number = Count++; }
		CForce (const CVector &V1) : CVector (V1) { Number = Count++; }
		~CForce() { Count--; }
};

#endif

// $Log: cforce.hh,v $
// Revision 1.5  2001/07/31 18:42:03  peter
// Finally added some comments. Finalized CVector (I think...)
//
// Revision 1.4  2001/07/29 06:19:01  peter
// Added an object counter. object ID and print method to each class. Fixed
// various annoying little bugs.
//
// Revision 1.3  2001/07/27 12:49:13  peter
// CForce now inherits CVector and is not a simple #define
//
// Revision 1.2  2001/07/23 07:33:24  peter
// Added CVS information
//
// Revision 1.1  2001/07/23 07:11:51  peter
// Created
