// $Id: ccamera.hh,v 1.1 2001/08/07 10:58:23 peter Exp $

#ifndef CCAMERA_HH_
#define CCAMREA_HH_

#include "cintrsct.hh"
#include "cvector.hh"

class CMesh;
class CRay;

class CCamera {
	private:
		CVector location;
		CVector lookat;
		double angle;
		double aspect;
		CVector sky;
		CVector up, right;
		CVector direction;
		
	public:
		CCamera();
		CCamera(const CVector &, const CVector &);

		CVector Location() const;
		CVector LookAt() const;
		double Angle() const;
		CVector Sky() const;
		CVector Up() const;
		CVector Right() const;
		CVector Direction() const;

		void Location(const CVector &);
		void LookAt (const CVector &);
		void Angle(double);
		void Sky(const CVector &);
		void Up(const CVector &);
		void Right(const CVector &);
		void Direction(const CVector &);

		void Render(const CMesh &, const CVector &, unsigned int, unsigned int);

		void Print();
};

#endif

// $Log: ccamera.hh,v $
// Revision 1.1  2001/08/07 10:58:23  peter
// Took all camera and render related stuff out of main and into CCamera
//
