// $Id: ccamera.cc,v 1.1 2001/08/07 10:58:23 peter Exp $

#ifndef CCAMERA_CC_
#define CCAMERA_CC_

#include "ccamera.hh"
#include "cvector.hh"
#include "cray.hh"
#include "cmesh.hh"
#include "cmatrix.hh"
#include "ctransf.hh"
#include "cintrsct.hh"
#include "consts.hh"
#include <cmath>


CCamera::CCamera() {
	location = CVector (0,4,-10);
	lookat = CVector (0);
	angle = 63;
	up = CVector (0,1,0);
	right = CVector (4.0/3.0,0,0);
	sky = up;
	aspect = 4.0/3.0;
	direction = -(lookat.Norm());
}

CCamera::CCamera (const CVector &V1, const CVector &V2) {
	location = V1;
	lookat = V2;
	angle = 63;
	up = CVector (0,1,0);
	right = CVector (4.0/3.0,0,0);
	sky = up;
	aspect = 4.0/3.0;
	direction = (lookat-location).Norm();
}

CVector CCamera::Location() const {
	return location;
}

CVector CCamera::LookAt() const {
	return lookat;
}

double CCamera::Angle() const {
	// Return value in degrees!
	return angle/DEG_TO_RAD;
}

CVector CCamera::Sky() const {
	return sky;
}

CVector CCamera::Up() const {
	return up;
}

CVector CCamera::Right() const {
	return right;
}

CVector CCamera::Direction() const {
	return direction;
}

void CCamera::Location(const CVector &V1) {
	location = V1;
}

void CCamera::LookAt (const CVector &V1) {
	double tmp_right = right.Length();
	double tmp_up = up.Length();
	double tmp_dir = direction.Length();

	lookat = V1;
	direction = (V1 - location).Norm();
	right = VCross(sky, direction).Norm();
	up = VCross(direction, right).Norm();

	up *= tmp_up;
	right *= tmp_right;
	direction *= tmp_dir;
}

void CCamera::Angle(double D1) {
	angle = D1;
	direction = direction.Norm() * right.Length() / tan(angle * DEG_TO_RAD * 0.5)/2.0;
}

void CCamera::Sky(const CVector &V1) {
	sky = V1;
}

void CCamera::Up(const CVector &V1) {
	up = V1;
}

void CCamera::Right(const CVector &V1) {
	right = V1;
}

void CCamera::Direction(const CVector &V1) {
	direction = V1;
}

void CCamera::Print() {}

void CCamera::Render(const CMesh &Mesh, const CVector &LightSource, unsigned int W, unsigned int H) {
	double x, y;
	double xc, yc;
	CVector D;

	CIntersection Intersection, ShadowTest;
	CRay Ray, ShadowRay;
	CVector IntersectionPoint, ToLight;
	double Brightness, Color;
	
	cout.precision(0);
	cout << "P3 " << W << " " << H << " 255\n";
	
	for (y = 0.0; y < H; y++ )
	  for (x = 0.0; x < W; x++ ) {
			xc = x / (1.0*W) - 0.5;
			yc = (H - y - 1.0) / (1.0*H) - 0.5;
			D = direction + xc * right + yc * up;
			Ray = CRay (location, D);
			Intersection.Clear();
			Intersection = Mesh.Trace(Ray);
			Color = 127;
			if (Intersection.Object != NULL) {
				IntersectionPoint = Ray.Evaluate(Intersection.Depth);
				ToLight = LightSource - IntersectionPoint;
				ShadowRay = CRay (IntersectionPoint+SOMETHING_SMALL*ToLight.Norm(),ToLight.Norm());
				ShadowTest.Clear();
				ShadowTest = Mesh.Trace(ShadowRay);
				if ( ShadowTest.Object == NULL ) {
					Brightness = VDot(ToLight.Norm(),Intersection.Object->NormalAt(IntersectionPoint));
					if (Brightness > 0)
						Color = 256.0*(0.2+0.8*Brightness);
					else
						Color = 0.2;
				}
				else Color = 0.2;
			}
			cout << (int)Color << " " << (int)Color << " " << (int)Color << "\n";
		}
}

#endif

// $Log: ccamera.cc,v $
// Revision 1.1  2001/08/07 10:58:23  peter
// Took all camera and render related stuff out of main and into CCamera
//
