// $Id: ctransf.cc,v 1.2 2001/08/05 22:31:58 peter Exp $

#ifndef CTRANSF_CC_
#define CTRANSF_CC_

#include "ctransf.hh"
#include "cvector.hh"
#include "consts.hh"
#include <iostream>

int CTransform::Count = 0;

CTransform::CTransform () {
	Transform = IdentityMatrix;
	Inverse = IdentityMatrix;
	Number = ++Count;
}

CTransform::CTransform (const CMatrix &M1) {
	Transform = M1;
	Inverse = Transform;
	Inverse.Invert();
	Number = ++Count;
}

CTransform::~CTransform () {
	Count--;
}

void CTransform::Scale (const CVector &V1) {
	Transform = IdentityMatrix;
	Transform.Elements[0][0] = V1.X();
	Transform.Elements[1][1] = V1.Y();
	Transform.Elements[2][2] = V1.Z();
	
	Inverse = IdentityMatrix;
	Inverse.Elements[0][0] = 1.0 / V1.X();
	Inverse.Elements[1][1] = 1.0 / V1.Y();
	Inverse.Elements[2][2] = 1.0 / V1.Z();
}

void CTransform::Rotate (const CVector &V1) {
	register double cx, cy, cz, sx, sy, sz;
	CMatrix MTemp;
	CVector VTemp;

	VTemp = V1 * DEG_TO_RAD;
	Transform = IdentityMatrix;

	sx = sin (VTemp.X());
	sy = sin (VTemp.Y());
	sz = sin (VTemp.Z());

	cx = cos (VTemp.X());
	cy = cos (VTemp.Y());
	cz = cos (VTemp.Z());

	Transform.Elements [1][1] = cx;
	Transform.Elements [2][2] = cx;
	Transform.Elements [1][2] = sx;
	Transform.Elements [2][1] = -sx;

//	Inverse = Transform;
//	Inverse.Transpose();

	MTemp = IdentityMatrix;

	MTemp.Elements [0][0] = cy;
	MTemp.Elements [2][2] = cy;
	MTemp.Elements [0][2] = -sy;
	MTemp.Elements [2][0] = sy;

	Transform = Transform * MTemp;

	MTemp.Transpose();

//	Inverse = MTemp * Inverse;

	MTemp = IdentityMatrix;

	MTemp.Elements [0][0] = cz;
	MTemp.Elements [1][1] = cz;
	MTemp.Elements [0][1] = sz;
	MTemp.Elements [1][0] = -sz;

	Transform = Transform * MTemp;

	MTemp.Transpose();

//	Inverse = MTemp * Inverse;
	Inverse = Transform;
	Inverse.Invert();
}

void CTransform::Translate (const CVector &V1) {
	Transform = IdentityMatrix;
	Inverse = IdentityMatrix;

	Transform.Elements[3][0] = V1.X();
	Transform.Elements[3][1] = V1.Y();
	Transform.Elements[3][2] = V1.Z();

	Inverse.Elements[3][0] = -V1.X();
	Inverse.Elements[3][1] = -V1.Y();
	Inverse.Elements[3][2] = -V1.Z();
}

void CTransform::Explicit (const CMatrix &M1) {
	Transform = M1;
	Inverse = M1;
	Inverse.Invert();
}

CTransform CTransform::operator * (const CTransform &T1) {
	CTransform TTemp;

	TTemp.Transform = Transform * T1.Transform;
	TTemp.Inverse = Inverse * T1.Inverse;

	return TTemp;
}

int CTransform::Id() {
	return Number;
}

void CTransform::Print() {
	cout.width(12);
	cout << "Transform Id: " << Number << "\n";
	cout << " |---- Transform matrix:";
	Transform.Print();
	cout << " |\n";
	cout << " |---- Inverse matrix:";
	Inverse.Print();
	cout << "\n";
}

#endif

// $Log: ctransf.cc,v $
// Revision 1.2  2001/08/05 22:31:58  peter
// Addressed a few minor issues
//
// Revision 1.1  2001/07/29 06:19:01  peter
// Added an object counter. object ID and print method to each class. Fixed
// various annoying little bugs.
//
