// $Id: csphere.cc,v 1.2 2001/08/05 22:24:58 peter Exp $

#ifndef CSPHERE_CC_
#define CSPHERE_CC_

#include "consts.hh"
#include "cvector.hh"
#include "cray.hh"
#include "cobject.hh"
#include "cintrsct.hh"
#include "csphere.hh"
#include <stack>
#include <iostream>

CSphere::CSphere () {
	center = 0.0;
	radius = 1.0;
	radiussquared = 1.0;
}

CSphere::CSphere ( const CVector &V1, double D1 ) {
	center = V1;
	radius = D1;
	radiussquared = D1 * D1;
}

CSphere::CSphere ( const CSphere &S1 ) {
	center = S1.Center();
	radius = S1.Radius();
	radiussquared = radius*radius;
	transform = S1.Transform();
}

CSphere::~CSphere () {
}

bool CSphere::Inside ( const CVector &V1 ) const {
	return (CVector( V1 - center ).Length() < radius);
}

CVector CSphere::NormalAt (const CVector &V1) const {
	return (VInverseTransform(V1 - center,transform)).Norm();
}

stack <CIntersection> CSphere::Intersect (const CRay &R1) const {
	IStack IntersectionPoints;
	double DepthToOrthoRadius, ToCenterSquared, HalfChord, HalfChordSquared;
	CVector ToCenter;
	double Length;

	CVector TOrigin = VInverseTransform(R1.Origin(), transform); 
   CVector TDirection = VInverseTransform(R1.Direction(), transform);
	Length = TDirection.Length();
	TDirection.Normalize();

	ToCenter = center - TOrigin;
	ToCenterSquared = ToCenter.Length()*ToCenter.Length();
	DepthToOrthoRadius = VDot (ToCenter, TDirection);

	if ( !( (ToCenterSquared > radiussquared) && (DepthToOrthoRadius < 0.0) ) ) {
		HalfChordSquared = radiussquared + DepthToOrthoRadius*DepthToOrthoRadius - ToCenterSquared;
		if (HalfChordSquared > SOMETHING_SMALL) {
			HalfChord = sqrt(HalfChordSquared);
			IntersectionPoints.push( CIntersection( (DepthToOrthoRadius - HalfChord)/Length, this ) );
			IntersectionPoints.push( CIntersection( (DepthToOrthoRadius + HalfChord)/Length, this ) );
		}
	}
	
	return IntersectionPoints;
}

CVector CSphere::Center() const {
	return center;
}

double CSphere::Radius() const {
	return radius;
}

void CSphere::Print() const {
	cout.precision(8);
	cout << "sphere { ";
	center.Print();
	cout << ", " << radius << " }\n";
}

#endif

// $Log: csphere.cc,v $
// Revision 1.2  2001/08/05 22:24:58  peter
// Added transformation related member functions to CObject and derived.
// Added plane object ( class CPlane : public CObject )
// Intersect, Inside and NormalAt member functions take into account
// object transformations. FIXME: Not all objects do this yet.
//
// Revision 1.1  2001/07/31 18:42:03  peter
// Finally added some comments. Finalized CVector (I think...)
//
