// $Id: cray.hh,v 1.2 2001/08/05 22:28:20 peter Exp $

#ifndef CRAY_HH_
#define CRAY_HH_

#include "cvector.hh"

// The ray class is pretty straight forward. It is a ray :)
class CRay {
	private:
		CVector origin;
		CVector direction;

	public:

		// Initialized to start at <0,0,0> and point at +x
		CRay ();

		// Usually you'll just give it an origin and direction.
		// Direction is automatically normalized.
		CRay ( const CVector &, const CVector & );

		// Rotate the direction, keep the origin
		void Rotate ( const CVector & );

		// Translate the origin, keep the direction
		void Translate ( const CVector & );

		CVector Origin() const;
		CVector Direction() const;

		// Returns the point lying at a specified distance from the origin
		CVector Evaluate (double);

		// Print information about the ray
		void Print();

		// Keep the origin, invert the direction
		CRay operator - ();
};

#endif

// $Log: cray.hh,v $
// Revision 1.2  2001/08/05 22:28:20  peter
// Added Evaluate member function
// Added Print member function
//
// Revision 1.1  2001/07/31 18:42:03  peter
// Finally added some comments. Finalized CVector (I think...)
//
