// $Id: cray.cc,v 1.2 2001/08/05 22:28:20 peter Exp $

#ifndef CRAY_CC_
#define CRAY_CC_

#include "cray.hh"
#include "cvector.hh"
#include "ctransf.hh"

CRay::CRay() {
	origin = 0.0;
	direction = CVector(1,0,0);
}

CRay::CRay ( const CVector & V1, const CVector & V2) {
	origin = V1;
	direction = V2.Norm();
}

void CRay::Rotate ( const CVector & V1 ) {
	CTransform T;

	T.Rotate (V1);
	direction = VTransform (direction, T);
}

void CRay::Translate ( const CVector & V1 ) {
	origin = origin + V1;
}

CVector CRay::Origin() const {
	return origin;
}

CVector CRay::Direction() const {
	return direction;
}

CVector CRay::Evaluate(double D1) {
	return origin + D1 * direction;
}

void CRay::Print() {
	cout << "origin: ";
	origin.Print();
	cout << ", direction: ";
	direction.Print();
	cout << "\n";
}

CRay CRay::operator - () {
	direction = -direction;
	return *this;
}

#endif

// $Log: cray.cc,v $
// Revision 1.2  2001/08/05 22:28:20  peter
// Added Evaluate member function
// Added Print member function
//
// Revision 1.1  2001/07/31 18:42:03  peter
// Finally added some comments. Finalized CVector (I think...)
//
