// $Id: cplane.hh,v 1.1 2001/08/05 22:24:58 peter Exp $

#ifndef CPLANE_HH_
#define CPLANE_HH_

#include "cintrsct.hh"
#include "cvector.hh"
#include "cobject.hh"

class CRay;

class CPlane : public CObject {
	private:
		CVector normal;
		double distance;

	public:

		CPlane();
		CPlane (const CVector &, double);
		
		CVector NormalAt(const CVector &) const;
		IStack Intersect(const CRay &) const;
		bool Inside (const CVector &) const;

		void Print() const;
};

#endif

// $Log: cplane.hh,v $
// Revision 1.1  2001/08/05 22:24:58  peter
// Added transformation related member functions to CObject and derived.
// Added plane object ( class CPlane : public CObject )
// Intersect, Inside and NormalAt member functions take into account
// object transformations. FIXME: Not all objects do this yet.
//
