// $Id: cobject.hh,v 1.3 2001/08/05 22:24:58 peter Exp $

#ifndef COBJECT_HH_
#define COBJECT_HH_

#include "cintrsct.hh"
#include "ctransf.hh"

class CVector;
class CRay;

// This class is an abstract base class providing a common interface
// to all classes inheriting it. All object types (sphere, plane, box...)
// must inherit CObject
class CObject {
	protected:
		CTransform transform;

	public:

		// Check whether a point is inside a specific object
		virtual bool Inside ( const CVector & ) const = 0;

		// Returns all intersections of a ray with an object
		virtual IStack Intersect (const CRay &) const = 0;

		// Returns the normal of an object at a point
		virtual CVector NormalAt (const CVector &) const = 0;

		// Prints the object in POV-Ray's scene description language
		virtual void Print() const = 0;

		// Virtual destructor to make the compiler happy
		virtual ~CObject() = 0;

		// Transformations related stuff
		
		// Without a parameter returns the transform
		CTransform Transform() const;

		// Explicitly the transform
		void Transform (const CTransform &);

		// Create transforms for scaling, rotation and translation. They will stack
		// over the existing transform.
		void Scale (const CVector &);
		void Rotate (const CVector &);
		void Translate (const CVector &);
		void Matrix (const CMatrix &);
};

#endif

// $Log: cobject.hh,v $
// Revision 1.3  2001/08/05 22:24:58  peter
// Added transformation related member functions to CObject and derived.
// Added plane object ( class CPlane : public CObject )
// Intersect, Inside and NormalAt member functions take into account
// object transformations. FIXME: Not all objects do this yet.
//
// Revision 1.2  2001/07/31 18:42:03  peter
// Finally added some comments. Finalized CVector (I think...)
//
// Revision 1.1  2001/07/27 12:50:25  peter
// Created as base class for object hierarchy
//

