// $Id: cobject.cc,v 1.2 2001/08/05 22:24:58 peter Exp $

#ifndef COBJECT_CC_
#define COBJECT_CC_

#include "cobject.hh"
#include "cvector.hh"
#include "cray.hh"
#include "cintrsct.hh"
#include "ctransf.hh"

CObject::~CObject () {
}
/*
bool CObject::Inside ( const CVector & ) const {
	// declared virtual, only makes sense for descendants
	return false;
}
*/
IStack CObject::Intersect ( const CRay & ) const {
	IStack tmp;
	// declared virtual, only makes sense for descendants
	return tmp;
}

CVector CObject::NormalAt ( const CVector & ) const {
	// declared virtual, only makes sense for descendants
	return CVector (0);
}

CTransform CObject::Transform() const {
	return transform;
}

void CObject::Transform(const CTransform &T1) {
	transform = T1;
}

void CObject::Scale (const CVector &V1) {
	CTransform tmp;
	tmp.Scale(V1);
	transform = tmp * transform;
}

void CObject::Rotate (const CVector &V1) {
	CTransform tmp;
	tmp.Rotate(V1);
	transform = tmp * transform;
}

void CObject::Translate (const CVector &V1) {
	for (char i = 0; i < 3; i++) {
		transform.Transform.Elements[3][i] += V1[i];
		transform.Inverse.Elements[3][i] -= V1[i];
	}
}

void CObject::Matrix (const CMatrix &V1) {
	CTransform tmp;
	tmp.Explicit(V1);
	transform = tmp * transform;
}

#endif

// $Log: cobject.cc,v $
// Revision 1.2  2001/08/05 22:24:58  peter
// Added transformation related member functions to CObject and derived.
// Added plane object ( class CPlane : public CObject )
// Intersect, Inside and NormalAt member functions take into account
// object transformations. FIXME: Not all objects do this yet.
//
