// $Id: cmesh.cc,v 1.5 2001/08/05 22:27:49 peter Exp $

#ifndef CMESH_CC_
#define CMESH_CC_

#include "consts.hh"
#include "cvector.hh"
#include "cforce.hh"
#include "cray.hh"
#include "cnode.hh"
#include "clink.hh"
#include "cobject.hh"
#include "cmesh.hh"
#include <vector>
#include <list>

int CMesh::Count = 0;

void CMesh::AddLink (const CLink &L1) {
	Links.push_back(L1);
}

void CMesh::AddNode (const CNode &N1) {
	Nodes.push_back(N1);
}

void CMesh::AddConstraint (const CForce &C1) {
	Constraints.push_back(C1);
}

void CMesh::AddExternal (const CForce &E1) {
	External.push_back(E1);
}

void CMesh::AttachLink (CNode N1, CLink L1) {
	N1.AddLink(&L1);
}

void CMesh::AttachConstraint (CNode N1, CForce C1) {
	N1.AddConstraint(&C1);
}

void CMesh::AttachExternal (CNode N1, CForce E1) {
	N1.AddExternal(&E1);
}

CIntersection CMesh::Trace ( const CRay &R1 ) const {

	// All intersections with currently tested object
	IStack ObjectIntersections;

	// The currently examined intersection
	CIntersection CurrentIntersection;

	// The best intersection so far, i.e. closest to the ray origin
	CIntersection BestIntersection;

	// An iterator through the list of objects
	std::list <CObject *>::const_iterator CurrentObject;

	for (CurrentObject = Objects.begin(); CurrentObject != Objects.end(); CurrentObject++) {

		// Get an interstaction stack containing all intersection of the ray
		// with the currently tested object
		ObjectIntersections = (*CurrentObject)->Intersect(R1);

		// Check if any of them is better than the currently best one. If it is, make
		// it the best.
		while (!ObjectIntersections.empty()) {
			CurrentIntersection = ObjectIntersections.top();
			if (CurrentIntersection.Depth < BestIntersection.Depth)
				BestIntersection = CurrentIntersection;
			ObjectIntersections.pop();
		}
	}
	
	return BestIntersection;
}

CMesh::CMesh () {
	Number = ++Count;
}

CMesh::~CMesh() {
	Count--;
}

int CMesh::Id() {
	return Number;
}

void CMesh::Print() {
	std::vector <CLink>::iterator il;
	std::vector <CForce>::iterator ie;
	std::vector <CForce>::iterator ic;
	std::vector <CNode>::iterator in;

	cout << "\nMesh Id: " << Number;
	if ( Nodes.size() ) {
		cout << "\n |---- Nodes: ";
		for ( in = Nodes.begin(); in != Nodes.end(); in++ )
		  cout << (*in).Id() << " ";
		cout << "\n";
	}

	if ( Links.size() ) {
		cout << "\n |---- Links: ";
		for ( il = Links.begin(); il != Links.end(); il++ )
		  cout << (*il).Id() << " ";
		cout << "\n";
	}

	if ( External.size() ) {
		cout << "\n |---- External forces: ";
		for ( ie = External.begin(); ie != External.end(); ie++ )
		  cout << (*il).Id() << " ";
		cout << "\n";
	}

	if ( Links.size() ) {
		cout << "\n |---- Constraints: ";
		for ( ic = Constraints.begin(); ic != Constraints.end(); ic++ )
		  cout << (*ic).Id() << " ";
		cout << "\n";
	}
}


#endif

// $Log: cmesh.cc,v $
// Revision 1.5  2001/08/05 22:27:49  peter
// The destructor now detroys all objects the mesh uses
//
// Revision 1.4  2001/07/31 18:42:03  peter
// Finally added some comments. Finalized CVector (I think...)
//
// Revision 1.3  2001/07/29 06:19:01  peter
// Added an object counter. object ID and print method to each class. Fixed
// various annoying little bugs.
//
// Revision 1.2  2001/07/23 07:33:24  peter
// Added CVS information
//
// Revision 1.1  2001/07/23 07:11:51  peter
// Created
