// $Id: cintrsct.hh,v 1.2 2001/08/05 22:25:35 peter Exp $

#ifndef CINTRSCT_HH_
#define CINTRSCT_HH_

#include <stack>

class CObject;

// An intersection carries information of the depth along the ray at which
// it (the intersection) occured, and the object it intersected at that
// depth. At the moment its only use is to help CMesh::Trace ( const CRay & )
class CIntersection {
	public:

		// The depth, i.e. the distance from the origin of the ray being tested,
		// at which the intersection occured.
		double Depth;

		// The object the intersection point belongs to
		const CObject * Object;

		// Initialized to no intersection, i.e. CIntersection (SOMETHING_BIG, NULL)
		CIntersection();

		// This is the constructor that will be used most often
		CIntersection (double, const CObject *);

		void Clear();
};

// I am heavily borrowing from POV-Ray's IStack idea.
// Basically, the Intersect member function of children classes of CObject
// return a stack containing all intersections. See CMesh::Trace (const CRay &)
// in cmesh.hh and cmesh.cc for more info.
typedef stack <CIntersection> IStack;

#endif

// $Log: cintrsct.hh,v $
// Revision 1.2  2001/08/05 22:25:35  peter
// Added void Clear() member function
//
// Revision 1.1  2001/07/31 18:42:03  peter
// Finally added some comments. Finalized CVector (I think...)
//
