// $Id: cbox.hh,v 1.1 2001/08/05 22:24:58 peter Exp $

#ifndef CBOX_HH_
#define CBOX_HH_

#include "consts.hh"

class CObject;
class CVector;
class CRay;
class CIntersection;

class CBox : public CObject {
	private:
		CVector lower;
		CVector upper;

	public:
		CBox ();
		CBox (const CVector &, const CVector &);

		// Make the compiler happy with a virtual destructor
		~CBox ();
		
		// I know 'virtual' is optional, but it clears things up
		// See cobject.hh
		virtual bool Inside ( const CVector & ) const ;
		virtual IStack Intersect (const CRay &) const ;
		virtual CVector NormalAt (const CVector & ) const ;

		void Print() const ;
};

#endif

// $Log: cbox.hh,v $
// Revision 1.1  2001/08/05 22:24:58  peter
// Added transformation related member functions to CObject and derived.
// Added plane object ( class CPlane : public CObject )
// Intersect, Inside and NormalAt member functions take into account
// object transformations. FIXME: Not all objects do this yet.
//
