/****************************************************************************
*                mechsim.h
*
*  Author: Christoph Hormann <chris_hormann@gmx.de>
*
*  Mechanics simulation
*
*  MechSim version 0.2.0   December 2002
*
*****************************************************************************
*
*  from Persistence of Vision(tm) Ray Tracer
*  Copyright 1996-2002 Persistence of Vision Team
*---------------------------------------------------------------------------
*  NOTICE: This source code file is provided so that users may experiment
*  with enhancements to POV-Ray and to port the software to platforms other
*  than those supported by the POV-Ray Team.  There are strict rules under
*  which you are permitted to use this file.  The rules are in the file
*  named POVLEGAL.DOC which should be distributed with this file.
*  If POVLEGAL.DOC is not available it may be found online at -
*
*    http://www.povray.org/povlegal.html.
*
* This program is based on the popular DKB raytracer version 2.12.
* DKBTrace was originally written by David K. Buck.
* DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
*
*###################################################################
*  This file is part of MegaPOV, which is a modified and unofficial version of POV-Ray
*
* $RCSfile: mechsim.h,v $
* $Revision: 1.7 $
* $Author: smellenbergh $
* $Log: mechsim.h,v $
* Revision 1.7  2002/12/07 16:48:43  smellenbergh
* Adds listed pattern, displacement warp
* Header CVS keywords fix
*
* Revision 1.6  2002/12/05 20:57:25  chris
* merging the mechsim changes after version 0.1.0:
* attachments, interactions, fields and various other changes
* removed unused variables
*
* Revision 1.5  2002/12/03 08:50:13  smellenbergh
* syntax corrections
*
*
* Revision 1.2  2002/12/02 14:41:09  abx
* clothray and mechsim adjusted to 'no warning' version,
* frame_step is working switch and script build-in token but not influence animation rendering,
* CLASSNAMEPREFIX in windows code is MegaPOV now
*
* Revision 1.1  2002/12/02 00:03:27  smellenbergh
* Adds Mechanics Simulation Patch and Clothray Patch
*
*****************************************************************************/


#ifndef MECHSIM_H
#define MECHSIM_H

/*****************************************************************************
* Global preprocessor defines
******************************************************************************/

#define MECHSIM_METHOD_EULER 1
#define MECHSIM_METHOD_HEUN 2
#define MECHSIM_METHOD_GRADIENT 4

#define MECHSIM_FLAG_FIXED 1

#define MECHSIM_COLLISION_NONE 0
#define MECHSIM_COLLISION_ALL 1
#define MECHSIM_COLLISION_GROUP 2

#define MECHSIM_ENV_METHOD_FORCE 1
#define MECHSIM_ENV_METHOD_IMPACT 2

/*****************************************************************************
* Global typedefs
******************************************************************************/

/* ------------------------------------------------------ */
typedef struct mechsim_state_struct MECHSIM_STATE;

struct mechsim_state_struct {
  VECTOR Position;
  VECTOR Velocity;
};

/* ------------------------------------------------------ */
typedef struct mechsim_mass_struct MECHSIM_MASS;

struct mechsim_mass_struct {

  int Index;

  VECTOR Position;
  VECTOR Velocity;
  DBL Mass;
  DBL Radius;
  int Flag;
  int Attach;

  int Group;
};

/* ------------------------------------------------------ */
typedef struct mechsim_connect_struct MECHSIM_CONNECT;

struct mechsim_connect_struct {

  int Index;

  int Idx1;
  int Idx2;

  DBL Length;
  DBL Stiffness;
  DBL Damping;

  int Group;
};

/* ------------------------------------------------------ */
typedef struct mechsim_face_struct MECHSIM_FACE;

struct mechsim_face_struct {

  int Index;

  int Idx1;
  int Idx2;
  int Idx3;

  int Group;
  
  VECTOR bbox_min;
  VECTOR bbox_max;
};

/* ------------------------------------------------------ */
typedef struct mechsim_group_struct MECHSIM_GROUP;

struct mechsim_group_struct {

  int max_masses;
  int max_connects;
  int max_faces;

  int mass_count;
  int connect_count;
  int faces_count;

  MECHSIM_MASS **Masses;
  MECHSIM_CONNECT **Connects;
  MECHSIM_FACE **Faces;
};

/* ------------------------------------------------------ */
typedef struct mechsim_data_struct MECHSIM_DATA;

struct mechsim_data_struct {

  int max_masses;
  int max_connects;
  int max_faces;
  int max_groups;

  int mass_count;
  int connect_count;
  int faces_count;
  int group_count;

  MECHSIM_MASS *Masses;
  MECHSIM_CONNECT *Connects;
  MECHSIM_FACE *Faces;
  MECHSIM_GROUP *Groups;

  OBJECT *Faces_Object;
};

/* ------------------------------------------------------ */
typedef struct mechsim_environment_struct MECHSIM_ENVIRONMENT;

struct mechsim_environment_struct {

  FUNCTION_PTR Function;
  OBJECT *Object;
  DBL Stiffness;
  DBL Damping;
  DBL Friction;
  DBL Friction_Excess;
  unsigned int Method;

  MECHSIM_ENVIRONMENT *Next;
};

/* ------------------------------------------------------ */
typedef struct mechsim_fields_struct MECHSIM_FIELDS;

struct mechsim_fields_struct {

  FUNCTION_PTR *Function;
  int count;
  int max_count;
};

/* ------------------------------------------------------ */
typedef struct mechsim_interactions_struct MECHSIM_INTERACTIONS;

struct mechsim_interactions_struct {

  FUNCTION_PTR *Function;
  int count;
  int max_count;
};

/* ------------------------------------------------------ */
typedef struct mechsim_attachments_struct MECHSIM_ATTACHMENTS;

struct mechsim_attachments_struct {

  FUNCTION_PTR *Function;
  int count;
  int max_count;
};

/* ------------------------------------------------------ */
typedef struct mechsim_options_struct MECHSIM_OPTIONS;

struct mechsim_options_struct {

  unsigned int Method;
  int Step_Count;
  DBL Time_Step;
  DBL Start_Time;

  VECTOR gravity;
  DBL Damping;

  MECHSIM_ENVIRONMENT *Environment;

  DBL Collision_Stiffness;
  DBL Collision_Damping;
  DBL Collision_Friction;
  DBL Collision_Friction_Excess;
  int Calc_Collision;
  int Calc_Collision_Faces;

  char* Load_File_Name;
  char* Save_File_Name;

  bool Save_File;
  int Save_File_Type;

  bool Enabled;

  MECHSIM_DATA Data;

  MECHSIM_INTERACTIONS Interactions;
  MECHSIM_ATTACHMENTS Attachments;
  MECHSIM_FIELDS Fields;
};

/* ------------------------------------------------------ */
typedef struct bounding_hashtable_item BOUNDING_HASHTABLE_ITEM;

struct bounding_hashtable_item {
  int size;
  int used;
  int *index;
};

/* ------------------------------------------------------ */
/* global functions */
/* ------------------------------------------------------ */

bool Mechsim_read_file (POV_ISTREAM * fd, int Group);

void Initialize_MechSim(void);
void Deinitialize_MechSim(void);

void Mechsim_Simulate(void);



extern MECHSIM_OPTIONS MechsimOptions;

#endif

