#version Unofficial megapov 1.0;

light_source
{
	<1,1,-1>*100
	color rgb 1
} 

#declare scape1_func=function
{
	pigment
	{
		image_map
		{
			tga "hf.tga"
			interpolate 3
		}
		rotate x*90
	}
}

#declare scape2_func=function
{
	pigment
	{
		image_map
		{
			tga "hf.tga"
			interpolate 0
		}
	}
}

#local fp = function{scape2_func(x,y,z).red}
#local xsize=10;
#local ysize=10;
#local dx=1/xsize;
#local dy=1/ysize;
#local q=function(x,s){x*s-int(x*s)}

#local Flin = function(f1,f2,x){f1 + (f2-f1)*x}
#local Fbilin = function
{
	Flin(               
		Flin(fp(x,y   ,0),fp(x+dx,y   ,0),q(x,xsize))
		,
		Flin(fp(x,y+dy,0),fp(x+dx,y+dy,0),q(x,xsize))
		,
		q(y,ysize)
	)
}

#local Fcub = function(f1,f2,f3,f4,x)
{
	(-f1/2	+f2*3/2	-f3*3/2	+f4/2	)*x*x*x
	+
	( f1	-f2*5/2	+f3*2	-f4/2	)*x*x
	+
	(-f1/2		+f3/2		)*x
	+
	(	f2			)
}

#declare Fbicub=function{
	Fcub
	(
		Fcub(
			fp(x-dx  ,y-dy,0),
			fp(x     ,y-dy,0),
			fp(x+dx  ,y-dy,0),
			fp(x+2*dx,y-dy,0),
			q(x,xsize)
		)
		,
		Fcub(
			fp(x-dx  ,y,0),
			fp(x     ,y,0),
			fp(x+dx  ,y,0),
			fp(x+2*dx,y,0),
			q(x,xsize)
		)
		,
		Fcub(
			fp(x-dx  ,y+dy,0),
			fp(x     ,y+dy,0),
			fp(x+dx  ,y+dy,0),
			fp(x+2*dx,y+dy,0),
			q(x,xsize)
		)
		,
		Fcub(
			fp(x-dx  ,y+2*dy,0),
			fp(x     ,y+2*dy,0),
			fp(x+dx  ,y+2*dy,0),
			fp(x+2*dx,y+2*dy,0),
			q(x,xsize)
		)
		,
		q(y,ysize)
	)
}


union
{
	plane
	{
		y,0
	}
	

	isosurface
	{
		function
		{
			y
			-.4*scape1_func(x,0,z).red
			//-.4*Fbilin(x,z,0)
			//-.4*Fbicub(x,z,0)
			//-.4*Flin(fp(x,0   ,0),fp(x+dx,0   ,0),q(x,xsize))
			//-.01*q(x,xsize)                                   
		}                 
		max_gradient 3
		contained_by
		{
			box
			{
				<0,0,0>,<1,1,1>
			}
		}
		pigment{color rgb 1}
		finish{specular .2}
	}

	pigment
	{
		checker color rgb <.9,.9,1> color rgb <.5,.5,.7>
		scale .1
	}
}

camera
{  
	location <0,2,-2>
	look_at <.5,0,.5>
	angle 24
}    

/*
#debug "\n"        
#local i=0;    
#local di=.001;
#while(i<.2)
	#debug str(q(i,xsize),0,5)
	#debug "\n"
	#local i=i+di;
#end
#debug "\n"

*/