/*
Copyright 1999-2001 Thorsten Froehlich. All rights reserved. 

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met: 

    1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer. 
    2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the
       documentation and/or other materials provided with the distribution. 

THIS SOFTWARE IS PROVIDED BY THORSTEN FROEHLICH "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THORSTEN FROEHLICH BE LIABLE FOR ANY DIRECT, INDIRECT, 
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE. 
*/

#ifndef QPOVPARSE_H
#define QPOVPARSE_H

class ArrayStream
{
	public:
		ArrayStream() { };
		~ArrayStream() { };

		virtual char operator[](int i) = 0;
		virtual const char *access(int i, int len) = 0;
		virtual int size() = 0;
};

class BuildSymbolTable
{
	public:
		BuildSymbolTable();
		~BuildSymbolTable();

		bool Parse(ArrayStream& as, int maxlevel);
	protected:
		virtual void AddDeclare(const char *text, long textlen) = 0;
		virtual void AddMacro(const char *text, long textlen) = 0;
		virtual ArrayStream *OpenIncludeFile(const char *name, long namelen) = 0;
	private:
		inline bool IsFirstWordChar(unsigned char c);
		inline bool IsWordChar(unsigned char c);
		inline bool ParseComment(ArrayStream& as, int& i, int maxlevel);
};

#endif
