/*==============================================================================
Project:	POV-Ray

Version:	3

File:	keywords.r

Description:
	resource source file of keywords for syntax coloring editor
------------------------------------------------------------------------------
Authors:
	Thorsten Froehlich
------------------------------------------------------------------------------
	from Persistence of Vision(tm) Ray Tracer
	Copyright 1996,1999 Persistence of Vision Team
------------------------------------------------------------------------------
	NOTICE: This source code file is provided so that users may experiment
	with enhancements to POV-Ray and to port the software to platforms other 
	than those supported by the POV-Ray Team.  There are strict rules under
	which you are permitted to use this file.  The rules are in the file
	named POVLEGAL.DOC which should be distributed with this file.
	If POVLEGAL.DOC is not available or for more info please contact the POV-Ray
	Team Coordinator by email to team-coord@povray.org or visit us on the web at
	http://www.povray.org. The latest version of POV-Ray may be found at this site.

	This program is based on the popular DKB raytracer version 2.12.
	DKBTrace was originally written by David K. Buck.
	DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
------------------------------------------------------------------------------
More Info:
	This Macintosh version of POV-Ray was updated and compiled by Eduard Schwan
	and now builds under Metrowerks CodeWarrior CW Pro 3+ for 68k and PPC.
	It used to, and may still build under Apple MPW 3.3.x, and Symantec C 8.
	The Macintosh code was based (loosely) on the original DKB 0.5 port by
	Thomas Okken and David Lichtman, with some help from Glenn Sugden.
	Jim Nitchals was instrumental in getting 1.0 out, Jim and Eduard jointly
	pulled off 2.x with help from Dave Harr for initial Balloon help and the
	custom palette code, and 3.0 was done by Eduard Schwan.  3.1 was done jointly
	by Eduard Schwan and Thorsten Froehlich.

	For bug reports regarding the Macintosh version, you may contact the
	POV-Ray MacOS team at the following e-mail address.  Please send in bugs
	by filling out the bug report form, in the Documentation folder with POV-Ray:
	POV-Ray MacOS Team
		mailto:	mac-team@povray.org
		WWW:	http://mac.povray.org/
		News:	news://news.povray.org/
------------------------------------------------------------------------------
Change History:
	980406	[trf]	Created
	980628	[trf]	Updated for version 3.1 keywords
	980713	[trf]	fixed a few typos
	980901	[esp]	added the last-minute material keyword
	980926	[esp]	changed "range" to "#range"
==============================================================================*/

#include "Types.r"

resource 'STR#' (129,"POV-Ray Language Keywords")
{
{
"abs",
"absorption",
"acos",
"acosh",
"adaptive",
"adc_bailout",
"agate",
"agate_turb",
"all",
"alpha",
"ambient",
"ambient_light",
"angle",
"aperture",
"append",
"arc_angle",
"area_light",
"array",
"asc",
"asin",
"asinh",
"assumed_gamma",
"atan",
"atan2",
"atanh",
"average",
"background",
"bezier_spline",
"bicubic_patch",
"black_hole",
"blob",
"blue",
"blur_samples",
"bounded_by",
"box",
"boxed",
"bozo",
"#break",
"brick",
"brick_size",
"brightness",
"brilliance",
"bumps",
"bump_map",
"bump_size",
"camera",
"#case",
"caustics",
"ceil",
"checker",
"chr",
"clipped_by",
"clock",
"clock_delta",
"color",
"color_map",
"colour",
"colour_map",
"component",
"composite",
"concat",
"cone",
"confidence",
"conic_sweep",
"control0",
"control1",
"cos",
"cosh",
"count",
"crackle",
"crand",
"cube",
"cubic",
"cubic_spline",
"cubic_wave",
"cylinder",
"cylindrical",
"#debug",
"#declare",
"#default",
"degrees",
"density",
"density_file",
"density_map",
"dents",
"difference",
"diffuse",
"dimensions",
"dimension_size",
"direction",
"disc",
"distance",
"distance_maximum",
"dist_exp",
"div",
"double_illuminate",
"eccentricity",
"#else",
"emission",
"#end",
"#error",
"error_bound",
"exp",
"extinction",
"fade_distance",
"fade_power",
"falloff",
"falloff_angle",
"false",
"#fclose",
"file_exists",
"filter",
"finish",
"fisheye",
"flatness",
"flip",
"floor",
"focal_point",
"fog",
"fog_alt",
"fog_offset",
"fog_type",
"#fopen",
"frequency",
"gif",
"global_settings",
"gradient",
"granite",
"gray_threshold",
"green",
"groups",
"height_field",
"hexagon",
"hf_gray_16",
"hierarchy",
"hollow",
"hypercomplex",
"#if",
"#ifdef",
"iff",
"#ifndef",
"image_map",
"#include",
"inside_vector",
"int",
"interior",
"interpolate",
"intersection",
"intervals",
"inverse",
"ior",
"irid",
"irid_wavelength",
"jitter",
"julia_fractal",
"lambda",
"lathe",
"leopard",
"light_group",
"light_source",
"linear_spline",
"linear_sweep",
"#local",
"location",
"log",
"looks_like",
"look_at",
"low_error_factor",
"#macro",
"major_radius",
"mandel",
"map_type",
"marble",
"material",
"material_map",
"matrix",
"max",
"max_intersections",
"max_iteration",
"max_trace_level",
"media",
"media_attenuation",
"media_interaction",
"merge",
"mesh",
"metallic",
"min",
"minimum_reuse",
"mod",
"mortar",
"nearest_count",
"no",
"normal",
"normal_map",
"no_shadow",
"number_of_waves",
"object",
"octaves",
"off",
"offset",
"omega",
"omnimax",
"on",
"once",
"onion",
"open",
"orientation",
"orthographic",
"panoramic",
"parallel",
"perspective",
"pgm",
"phase",
"phong",
"phong_size",
"pi",
"pigment",
"pigment_map",
"planar",
"plane",
"png",
"point_at",
"poly",
"polygon",
"poly_wave",
"pot",
"pow",
"ppm",
"precision",
"prism",
"projected_through",
"pwr",
"quadratic_spline",
"quadric",
"quartic",
"quaternion",
"quick_color",
"quick_colour",
"quilted",
"radial",
"radians",
"radiosity",
"radius",
"rainbow",
"ramp_wave",
"rand",
"#range",
"ratio",
"#read",
"reciprocal",
"recursion_limit",
"red",
"reflection",
"reflection_exponent",
"refraction",
"#render",
"repeat",
"reset_children",
"rgb",
"rgbf",
"rgbft",
"rgbt",
"right",
"ripples",
"rotate",
"roughness",
"samples",
"scale",
"scallop_wave",
"scattering",
"seed",
"shadowless",
"sin",
"sine_wave",
"sinh",
"sky",
"sky_sphere",
"slice",
"slope_map",
"smooth",
"smooth_triangle",
"sor",
"specular",
"sphere",
"sphere_sweep",
"sphere_sweep_depth_tolerance",
"spherical",
"spiral1",
"spiral2",
"spline",
"spotlight",
"spotted",
"sqr",
"sqrt",
"#statistics",
"str",
"strcmp",
"strength",
"string_encoding",
"strlen",
"strlwr",
"strupr",
"sturm",
"substr",
"superellipsoid",
"#switch",
"sys",
"t",
"tan",
"tanh",
"text",
"texture",
"texture_list",
"texture_map",
"tga",
"thickness",
"threshold",
"tightness",
"tile2",
"tiles",
"toroidal",
"torus",
"#trace",
"track",
"transform",
"translate",
"transmit",
"triangle",
"triangle_wave",
"trimmed_by",
"true",
"ttf",
"turbulence",
"turb_depth",
"type",
"u",
"ultra_wide_angle",
"#undef",
"union",
"up",
"use_alpha",
"use_color",
"use_colour",
"use_index",
"uv_indices",
"uv_mapping",
"uv_vectors",
"u_steps",
"v",
"val",
"variance",
"vaxis_rotate",
"vcross",
"vdot",
"#version",
"vertex_vectors",
"vlength",
"vnormalize",
"vrotate",
"v_steps",
"#warning",
"warp",
"water_level",
"waves",
"#while",
"width",
"wood",
"wrinkles",
"#write",
"x",
"y",
"yes",
"z",
""
}
};
