{****************************************************************************
*                 pvguiext.pas
*****************************************************************************
*  Converted from pvguiext.h by Rudy Velthuis
*
*  Comments //RV by the translator: Rudy Velthuis - rvelthuis@gmx.net
*
*  This file contains POV-ray for Windows GUI Extension specific defines.
*
*  Copyright  POV-Team 1996-1997. All Rights Reserved.
*  This windows version of POV-Ray is Copyright 1996-1997 Christopher J. Cason.
*  Author : Christopher J. Cason
*
*  NOTE : As this is Windows code, it was edited using a wide Windows-hosted
*         editor. Accordingly, expect text to exceed 80 columns regularly.
*
*  from Persistence of Vision Raytracer
*  Copyright 1996-1997 Persistence of Vision Team
*---------------------------------------------------------------------------
*  NOTICE: This source code file is provided so that users may experiment
*  with enhancements to POV-Ray and to port the software to platforms other
*  than those supported by the POV-Ray Team.  There are strict rules under
*  which you are permitted to use this file.  The rules are in the file
*  named POVLEGAL.DOC which should be distributed with this file. If
*  POVLEGAL.DOC is not available or for more info please contact the POV-Ray
*  Team Coordinator by leaving a message in CompuServe's POVRAY forum. The
*  The latest version of POV-Ray may be found there as well. POVRAY files can
*  also be found on the world wide web at http://www.povray.org/.
*
* This program is based on the popular DKB raytracer version 2.12.
* DKBTrace was originally written by David K. Buck.
* DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
*
*****************************************************************************}

{*****************************************************************************

  Conversion Copyright  1999 Rudy Velthuis (rvelthuis@gmx.de)

  USE OF THE ENCLOSED CONVERSION
  INDICATES YOUR ASSENT TO THE
  FOLLOWING ADDITIONAL LICENSE CONDITIONS.

  These License Conditions are exlusively governed by the
  Law and Rules of the Federal Republic of Germany.

  Redistribution and use in source and binary form, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
     If the source is modified, the complete original and unmodified
     source code has to distributed with the modified version.

  2. Redistributions in binary form must reproduce the above
     copyright notice, these licence conditions and the disclaimer
     found at the end of this licence agreement in the documentation
     and/or other materials provided with the distribution.

  3. Software using this code must contain a visible line of credit to
     the Author of the conversion.

  DISCLAIMER:

  THIS CONVERSION IS PROVIDED BY THE AUTHOR 'AS IS'.

  ALL EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
  THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
  PARTICULAR PURPOSE ARE DISCLAIMED.

  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  Rudy Velthuis (rvelthuis@gmx.net)
*****************************************************************************}

{$A+,B-,C-,D-,E-,F-,G+,H+,I-,J+,K-,L-,M-,N+,O+,P-,Q-,R-,S-,T-,U-,V-,W-,X+,Y-,Z1}

unit PVGuiExt;

interface

uses Windows, SysUtils;

const
  //RV defines from misc. ANSI and/or POV headers
  _MAX_PATH = 80;

type
  COLC = Single; //RV I'm not absolutely sure about this! COLC is defined as float.
  COLOUR = array [0..4] of COLC;

const
  MAX_GUI_EXT  = 32;
  GUI_INTERFACE_VERSION = 101;
  MAX_QUEUE = 128;

//RV CONTACT had to be turned into a function (see way below).

//RV These were placed here as typed consts instead of in the extension file.
//   They must be changed in the main body of the extension library file.

//RV Don't forget to change these, otherwise your extension will not be loaded!
  Author:  PChar = 'Place Author Name Here';                 // e.g. "Fu Bar"
  EMail:   PChar = 'Place Author Email Address Here';        // e.g. fubar@somewhere.com. don't use '<' or '('.
  ExtName: PChar = 'Place the name of your extension Here';  // this is what's displayed to the users.

type
  MsgType = (
    mNone, //RV inserted by me, because Ord(All) must be 1.
    All,
    mBanner,
    mWarning,
    mRender,
    mStatus,
    mDebug,
    mFatal,
    mStatistics,
    mDivider,
    mHorzLine
  );

  ExternalVarStruct = packed record
    RecSize: Integer ;
    command_line: array [0.._MAX_PATH * 3 - 1] of Char;
    source_file_name: array [0.._MAX_PATH - 1] of Char;
    lastRenderName: array [0.._MAX_PATH - 1] of Char;
    lastRenderPath: array [0.._MAX_PATH - 1] of Char;
    lastQueuePath: array [0.._MAX_PATH - 1] of Char;
    lastSecondaryIniFilePath: array [0.._MAX_PATH - 1] of Char;
    DefaultRenderIniFileName: array [0.._MAX_PATH - 1] of Char;
    SecondaryRenderIniFileName: array [0.._MAX_PATH - 1] of Char;
    SecondaryRenderIniFileSection: array [0..63] of Char;
    ourPath: array [0.._MAX_PATH - 1] of Char;
    engineHelpPath: array [0.._MAX_PATH - 1] of Char;
    rendererHelpPath: array[0.._MAX_PATH - 1] of Char;
    HomePath: array[0.._MAX_PATH - 1] of Char;
    EngineIniFileName: array[0.._MAX_PATH - 1] of Char;
    ToolIniFileName: array[0.._MAX_PATH - 1] of Char;
    loadRerun: Integer ;
    continueRerun: Integer;
    povray_return_code: Integer;
    rendering: BOOL;
    IsWin32: BOOL ;
    IsW95UserInterface: BOOL;
    running_demo: BOOL;
    debugging: BOOL;
    isMaxiMinimized: BOOL;
    newVersion: BOOL;
    use_threads: BOOL;
    use_toolbar: BOOL;
    use_tooltips: BOOL;
    use_editors: BOOL;
    drop_to_editor: BOOL;
    rendersleep: BOOL;
    ExtensionsEnabled: BOOL;
    queued_files: array [0..MAX_QUEUE-1, 0.._MAX_PATH - 1] of Char;
    queued_file_count: Integer ;
    auto_render: Integer ;
    Reserved: array [0..31] of DWord;
  end;

  ExternalEvents = (
    EventFirst,
    EventStartRendering,
    EventStopRendering,
    EventDisplayInit,
    EventDisplayFinished,
    EventDisplayClose,
    EventWinStartup,
    EventWinFinish,
    EventWinCooperate,
    EventLoadToolMenu,
    EventTimer,
    EventSize,
    EventMove,
    EventClose,
    EventDestroy,
    EventLast
  );

  ExternalRequests = (
    RequestFirst,
    RequestGetVars,
    RequestSetVars,
    RequestStartRendering,
    RequestStopRendering,
    RequestExit,
    RequestLast
  );

  ExternalRequestResult = (
    ExRequestDisabled,
    ExRequestOK,
    ExRequestFailed,
    ExRequestFailedRendering,
    ExRequestFailedNotRendering,
    ExRequestBadRecSize,
    ExRequestUnknown
  );

  ExternalDropType = (
    dfRealDrop,
    dfRenderEditor,
    dfRenderMessage,
    dfRenderCommandLine,
    dfRenderSourceFile,
    dfRenderFileQueue
  );

  TExternalRequestFunc = function(Request: ExternalRequests; RequestBlock: Pointer): ExternalRequestResult stdcall;

  GuiExtInitStruct = packed record
  
    // data POV passes to the DLL
    PovVersion: PChar;
    GuiVersion: PChar;
    GuiInterfaceVersion: DWord;
    FirstMenuItem: WParam;
    hInst: THandle;
    MainWindow: THandle;
    ExternalRequest: TExternalRequestFunc;

    // data the DLL passes to POV
    Name: PChar ;
    Author: PChar ;
    AuthorEmail: PChar ;
    hMenu: THandle ;
    DLLInterfaceVersion: DWord;
    Agreement: array [0..1023] of Char;
  end;

  IDataStruct = packed record
    InstanceID: DWord;
    hMenu: THandle ;
    FirstMenuItem: WParam;
  end;
  
type
  TInitFunc = function (InstanceID: DWord; RecSize: Integer; var InitStruct: GuiExtInitStruct): BOOL stdcall;
  TDestroyProc = procedure (var InstanceData: IDataStruct) stdcall;
  TMenuSelectFunc = function (var InstanceData: IDataStruct; Code: WParam): DWord stdcall;
  TMenuTipFunc = function (var InstanceData: IDataStruct; Code: WParam): PChar stdcall;
  TEventFunc = function (var InstanceData: IDataStruct; Event: ExternalEvents; EventVal: DWord): DWord stdcall;
  TDisplayPlotProc = procedure (var InstanceData: IDataStruct; x, y, Red, Green, Blue, Alpha: Integer) stdcall;
  TDisplayPlotRectProc = procedure (var InstanceData: IDataStruct; x1, y1, x2, y2, Red, Green, Blue, Alpha: Integer) stdcall;
  TWinPrePixelProc = procedure (var InstanceData: IDataStruct; x, y: Integer; colour: COLOUR) stdcall; //!! COLOUR defined elsewhere
  TWinPostPixelProc = procedure (var InstanceData: IDataStruct; x, y: Integer; colour: COLOUR) stdcall;
  TWinSystemFunc = function (var InstanceData: IDataStruct; Command: PChar; var ReturnVal: Integer): BOOL stdcall;
  TCleanupAllProc = procedure (var InstanceData: IDataStruct) stdcall;
  TBufferMessageProc = procedure (var InstanceData: IDataStruct; message_type: MsgType; message: PChar) stdcall;
  TParseToolBuffer = array[0..511] of Char;
  TParseToolCommandFunc = function (var InstanceData: IDataStruct; Command: TParseToolBuffer): PChar stdcall;
  TDragFunctionFunc = function (var InstanceData: IDataStruct; szFile: PChar; DropType: ExternalDropType): BOOL stdcall;
  TAssignPixelProc = procedure (var InstanceData: IDataStruct; x, y: Integer; colour: COLOUR) stdcall;

  GuiPointerBlock_Version_100 = packed record
    Signature: DWord;
    InstanceID: DWord;
    Init: TInitFunc;
    Destroy: TDestroyProc;
    MenuSelect: TMenuSelectFunc;
    MenuTip: TMenuTipFunc;
    Event: TEventFunc;
    DisplayPlot: TDisplayPlotProc;
    DisplayPlotRect: TDisplayPlotRectProc;
    WinPrePixel: TWinPrePixelProc;
    WinPostPixel: TWinPostPixelProc;
    WinSystem: TWinSystemFunc;
    CleanupAll: TCleanupAllProc;
    BufferMessage: TBufferMessageProc;
    ParseToolCommand: TParseToolCommandFunc;
    DragFunction: TDragFunctionFunc;
    Reserved: array [0..127] of DWord;
  end;
  
  GuiPointerBlock = packed record
    Signature: DWord;
    InstanceID: DWord;
    Init: TInitFunc;
    Destroy: TDestroyProc;
    MenuSelect: TMenuSelectFunc;
    MenuTip: TMenuTipFunc;
    Event: TEventFunc;
    DisplayPlot: TDisplayPlotProc;
    DisplayPlotRect: TDisplayPlotRectProc;
    WinPrePixel: TWinPrePixelProc;
    WinPostPixel: TWinPostPixelProc;
    WinSystem: TWinSystemFunc;
    CleanupAll: TCleanupAllProc;
    BufferMessage: TBufferMessageProc;
    ParseToolCommand: TParseToolCommandFunc;
    DragFunction: TDragFunctionFunc;
    AssignPixel: TAssignPixelProc;
    Reserved: array [0..126] of DWord;
  end;

function Contact: string;

implementation

//RV This function just concats the strings like in the original macro.
function Contact: string;
begin
  Result := 'Do not contact the POV-Team about this error. Contact the author of this extension:'#13#13
  	    + Author + ' (' + EMail + ')';
end;

end.

