{****************************************************************************
*                 guidemo.dpr
*****************************************************************************
*  Converted from guidemo.c
*
*  Comments //RV by the translator: Rudy Velthuis - rvelthuis@gmx.net
*  Comments !! by the POV-Team (originally they were #error directives).
*
*  This file contains POV-ray for Windows GUI Extension demonstration code.
*
*  Copyright  POV-Team 1996-1997. All Rights Reserved.
*  Author : Christopher J. Cason
*
*  Conversion to Object Pascal:
*    Copyright  Rudy Velthuis 1999. All Rights Reserved.
*    Email: rvelthuis@gmx.net
*  Do not contact the POV-Team about this conversion!
*
*  NOTE : As this is Windows code, it was edited using a wide Windows-hosted
*         editor. Accordingly, expect text to exceed 80 columns regularly.
*
*  from Persistence of Vision Raytracer
*  Copyright 1996-1997 Persistence of Vision Team
*  Windows version Copyright 1996-1997 Christopher J. Cason
*---------------------------------------------------------------------------
*  NOTICE: This source code file is provided so that users may experiment
*  with enhancements to POV-Ray and to port the software to platforms other
*  than those supported by the POV-Ray Team.  There are strict rules under
*  which you are permitted to use this file.  The rules are in the file
*  named POVLEGAL.DOC which should be distributed with this file. If
*  POVLEGAL.DOC is not available or for more info please contact the POV-Ray
*  Team Coordinator by leaving a message in CompuServe's POVRAY forum. The
*  The latest version of POV-Ray may be found there as well. POVRAY files can
*  also be found on the world wide web at http://www.povray.org/.
*
* This program is based on the popular DKB raytracer version 2.12.
* DKBTrace was originally written by David K. Buck.
* DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
*
* EXCLUSION FROM STANDARD LICENCE PROVISIONS
*
* Software authors may use this source code in derived programs PROVIDED
* thay they comply with the terms of POVEXT.TXT.
*
*****************************************************************************}

{*****************************************************************************

  Conversion Copyright  1999 Rudy Velthuis (rvelthuis@gmx.de)

  USE OF THE ENCLOSED CONVERSION
  INDICATES YOUR ASSENT TO THE
  FOLLOWING ADDITIONAL LICENSE CONDITIONS.

  These License Conditions are exlusively governed by the
  Law and Rules of the Federal Republic of Germany.

  Redistribution and use in source and binary form, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
     If the source is modified, the complete original and unmodified
     source code has to distributed with the modified version.

  2. Redistributions in binary form must reproduce the above
     copyright notice, these licence conditions and the disclaimer
     found at the end of this licence agreement in the documentation
     and/or other materials provided with the distribution.

  3. Software using this code must contain a visible line of credit to
     the Author of the conversion.

  DISCLAIMER:

  THIS CONVERSION IS PROVIDED BY THE AUTHOR 'AS IS'.

  ALL EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
  THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
  PARTICULAR PURPOSE ARE DISCLAIMED.

  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  Rudy Velthuis (rvelthuis@gmx.net)
*****************************************************************************}


// Template file that both demonstrates a POV-Ray for Windows GUI Extension
// DLL, and provides you with source to implement your own.

// REQUIREMENTS. This code must be compiled into a 32-bit Windows DLL with
// the extension .pge (for POV-Ray Gui Extension).

// you must modify the code wherever there is a #error directive to make it
// comply with our conditions. you must comply with POVEXT.TXT. here's a
// quick summary -

//  o extensions may be based on the 'extension toolkit' source code we provide.
//    that is, we explicitly permit you to re-use our demonstration source code
//    (and in fact encourage it, since it helps ensure that you comply with our
//    standards.)
//  o extensions may be written in any programming language compatible with the
//    requirements for the interface.
//  o extensions are not permitted to display splash screens or any other
//    notification that they are loaded other than functionally essential ones,
//    unless the user explicitly activates such by selecting them from the GUI
//    Extensions menu.
//  o extensions are not permitted to take any action that could jeopardise the
//    correct operation of POV-Ray.
//  o they may not show or do anything that may suggest that they are endorsed
//    by the POV team, or that they are part of POV-Ray.
//  o except by written agreement, extensions must be freeware and provide full
//    source.
//  o extension authors are required to build their real name and a valid email
//    address into the DLL.

// the above text is not meant to be definitive. if any of the above differs
// from the enclosed POVEXT.TXT, or from the current one, then the enclosed or
// current one takes precedence. the current one may be obtained by downloading
// the latest version of this toolkit from our official distribution sites.

// An extension is installed by modifying PVENGINE.INI in the following manner -
//
// [GUIExtensions]
// ExtDll16=D:\POVRAY\BETA\MODIFIED\SOURCE\WINDOWS\borland\guidemo.pge
//
// in the above example, the DLL is installed as number 16. there can be up to
// 32. numbers 00-15 are RESERVED for the POV-Team. the number determines the
// order in which DLL's are called with information, such as drag'n'drop
// filenames. REMINDER : do NOT use numbers 00-15.

//RV *********************************************************************
//   I converted all #error directives to !! "remarks". Please read them
//   carefully, and then delete them.
//RV *********************************************************************

{$A+,B-,C-,D-,E-,F-,G+,H+,I-,J+,K-,L-,M-,N+,O+,P-,Q-,R-,S-,T-,U-,V-,W-,X+,Y-,Z1}

{RV***********************************************************************

  This not a working demo! To show you agree with the license as
  described in povext.txt and povlegal.doc, you'll have to make
  changes to the source code manually. So please read the code carefully.

RV************************************************************************}

library GuiDemo;

uses
  Windows,
  SysUtils,
  CommCtrl,
  Messages,
  PVGuiExt;

{$E pge}        // Inserted by Delphi 4! Delete this if your version of Delphi
                // doesn't support this. You'll have to change the extension
                // to .pge manually then.

{$I GUIDEMOR.INC}
{$R *.RES}      // GUIDEMO.RES will not do! Propably any other name than the
                // project file name + .res would.

// this is a demonstration of a context structure. put whatever you like in here.
type
  PInstanceStruct = ^InstanceStruct;
  InstanceStruct = packed record
    Enabled: BOOL;
    hInstance: THandle;
    PixelsTraced: DWord;
    MainWindow: HWnd;
    Request: function (Req: ExternalRequests;
      ReqBlock: Pointer): ExternalRequestResult stdcall;
  end;

//RV -- Helper functions for this demo (only). --

procedure GetRelativeClientRect(hParent, hChild: HWnd; var Rect: TRect);
begin
  GetWindowRect(hChild, Rect);
  ScreenToClient(hParent, Rect.TopLeft);
  ScreenToClient(hParent, Rect.BottomRight);
end;

procedure CenterWindowRelative(hRelativeTo, hTarget: HWnd);
var
  Difference, Width, Height, X, Y: Integer;
  RelativeToRect, TargetRect: TRect;
begin
  if hRelativeTo = 0 then
    hRelativeTo := GetDesktopWindow;
  GetWindowRect(hRelativeTo, RelativeToRect);
  GetWindowRect(hTarget, TargetRect);
  Width := TargetRect.Right - TargetRect.Left;
  Height := TargetRect.Bottom - TargetRect.Top;
  Difference := RelativeToRect.Right - RelativeToRect.Left - Width;
  X := RelativeToRect.Left + Difference div 2;
  Difference := RelativeToRect.Bottom - RelativeToRect.Top - Height;
  Y := RelativeToRect.Top + Difference div 2;
  MoveWindow(hTarget, X, Y, Width, Height, True); //RV - Why not SetWindowPos?
end;

procedure FitWindowInWindow(hRelativeTo, hTarget: HWnd);
var
  RWidth, RHeight, TWidth, THeight, X, Y: Integer;
  RelativeToRect, TargetRect: TRect;
begin
  if hRelativeTo = 0 then
    hRelativeTo := GetDesktopWindow;
  GetWindowRect(hRelativeTo, RelativeToRect);
  GetWindowRect(hTarget, TargetRect);
  TWidth := TargetRect.Right - TargetRect.Left;
  THeight := TargetRect.Bottom - TargetRect.Top;
  RWidth := RelativeToRect.Right - RelativeToRect.Left;
  RHeight := RelativeToRect.Bottom - RelativeToRect.Top;
  X := TargetRect.Left;
  Y := TargetRect.Top;

  if TWidth > RWidth then
    TWidth := RWidth;
  if THeight > RHeight then
    THeight := RHeight;
  if X < RelativeToRect.Left then
    X := RelativeToRect.Left;
  if Y < RelativeToRect.Top then
    Y := RelativeToRect.Top;
  if X + TWidth > RelativeToRect.Right then
    X := RelativeToRect.Right - TWidth;
  if Y + THeight > RelativeToRect.Bottom then
    Y := RelativeToRect.Bottom - THeight;

  MoveWindow(hTarget, X, Y, TWidth, THeight, True)
end;

//RV -- Demos of required functions

// An about dialog is REQUIRED. Modify this one to suit your needs !
// Remove the pixels traced and home path stuff;
// that's just there for demonstration.
function AboutDialogProc(hDlg: HWnd; Message: UINT; wParam: WPARAM;
  lParam: LPARAM): BOOL; stdcall;
var
//  Str: array[0..255] of Char;
  Instance: PInstanceStruct;
  ExternalVars: ExternalVarStruct;
begin
  Instance := PInstanceStruct(lParam);
  Result := True;
  case Message of
    WM_INITDIALOG:
      begin
         SetDlgItemText(hDlg, ID_PIXELS,
           PChar(Format('%d pixels traced', [Instance^.PixelsTraced])));
         ExternalVars.RecSize := SizeOf(ExternalVarStruct);
         Instance^.Request(RequestGetVars, @ExternalVars);
         SetDlgItemText(hDlg, ID_HOMEPATH,
           PChar(Format('POV-Ray for Windows home path is %s',
             [ExternalVars.HomePath])));
         CenterWindowRelative(Instance^.MainWindow, hDlg) ;
         FitWindowInWindow(0, hDlg);
         Exit;
       end;
    WM_COMMAND:
      case LOWORD(wParam) of
        IDOK,
        IDCANCEL:
          begin
            EndDialog(hDlg, 1);
            Exit;
          end;
      end;
  end;
  Result := False;
end;

{*
** Possible events -
**
**  EventStartRendering             Guess ?
**  EventStopRendering              uhhh ...
**  EventDisplayInit                see POV-Ray source code (Dos, Win, Unix, whatever) for info on this.
**  EventDisplayFinished            ditto
**  EventDisplayClose               ditto
**  EventWinStartup                 ditto
**  EventWinFinish                  ditto
**  EventWinCooperate               ditto
**  EventLoadToolMenu               called BEFORE tool menu is loaded/reloaded.
**  EventTimer                      called once per second, or so. use this to avoid having your own timer/message loop.
**  EventClose                      called when the main window is closed.
**  EventDestroy                    called when the main window is destroyed.
**
*}

// return 1 (exactly 1, not just non-zero) if you process an event.
function Event(var InstanceData: IDataStruct; Event: ExternalEvents; EventVal: DWord): DWord; stdcall;
begin
  Result := 0;
end;

// see POV-Ray source.
procedure DisplayPlot(var InstanceData: IDataStruct; X, Y, Red, Green, Blue, Alpha: Integer); stdcall;
begin
end;

// see POV-Ray source.
procedure DisplayPlotRect(var InstanceData: IDataStruct; X1, Y1, X2, Y2, Red, Green, Blue, Alpha: Integer); stdcall;
begin
end;

// see POV-Ray source.
procedure WinPrePixel (var InstanceData: IDataStruct; X, Y: Integer; colour: COLOUR); stdcall;
begin
end;

// see POV-Ray source.
procedure WinPostPixel(var InstanceData: IDataStruct; X, Y: Integer; colour: COLOUR); stdcall;
begin
  // take this out if you don't need it. it's just a demonstration.
  Inc(PInstanceStruct(InstanceData.InstanceID)^.PixelsTraced);
end;

// see POV-Ray source.
procedure WinAssignPixel(var InstanceData: IDataStruct; X, Y: Integer; colour: COLOUR); stdcall;
begin
end;

{****************************************************************************************}
{*                                                                                      *}
{* This is called before POV-Ray for Windows executes a system call (i.e. runs an       *}
{* external program). If you return TRUE, POV will assume that you've handled the call. *}
{*                                                                                      *}
{* CONVENTION : External program names that start with an '!' are really GUI extensions.*}
{* For example, the line -                                                              *}
{*                                                                                      *}
{*  Post_Scene_Command=!Peter's FLC Maker %f                                            *}
{*                                                                                      *}
{* is intended to refer not to a program called 'Peter's FLC maker' but any GUI Ext     *}
{* that chooses to respond to that name. This should be either the name of the DLL,     *}
{* which should always have a .pge extension, the name of your extension, or an         *}
{* extension of it. (e.g. !Peter's FLC Maker (FLH mode) %f.)                            *}
{*                                                                                      *}
{* WARNING. If you hijack POV-Ray for Windows normal shellout commands (i.e., you       *}
{* attempt to execute ALL commands), make SURE it works properly.                       *}
{*                                                                                      *}
{****************************************************************************************}

function WinSystem(InstanceData: IDataStruct; Command: PChar;
  var ResturnVal: Integer): BOOL; stdcall;
begin
  Result := False;
end;

// do any per-instance de-initialisation here.
procedure CleanupAll(var InstanceData: IDataStruct); stdcall;
begin
end;

// messages intended for the message window. you can do things here like send them
// via the network if you've implemented network rendering, or write them to a log file.
procedure BufferMessage(var InstanceData: IDataStruct; Message_Type:
  msgtype; Message: PChar); stdcall;
begin
end;

// you can add your own escapes to tool commands by processing them here.
function ParseToolCommand(var InstanceData: IDataStruct;
  Command: TParseToolBuffer): PChar; stdcall;
begin
  Result := Command;
end;

// if an unknown file type is dropped onto POV-Ray for Windows, it will be passed
// along to here. if you want to handle it, do so here and return TRUE.
// at a later date, we will also call this function for any render for a file
// extension type it does not recognise. this will allow a user to be editing,
// for example, a file called 'myfile.myextension', and as long as you handle
// 'myextension' here, you can handle the render action. typically, this would be
// to translate the file into POV-Ray source code, then to invoke the renderer on
// it. this can be used by authors of 'shape generator' programs, for example.
// (a GUI extension version of lparser would be a perfect example.)
//
// DropType may be one of -
//
//   dfRealDrop             A file was really dropped on POV-Ray for Windows.
//   dfRenderEditor         Not a drop. A render was started with the editor selected.
//                          [That is, the tabbed control was selecting an editor page.]
//                          szFile will point to the filename that they're rendering.
//   dfRenderMessage        Ditto, but the editor wasn't selected.
//   dfRenderCommandLine    Render was selected from the Render dialog (ALT-C)
//   dfRenderSourceFile     Render was selected due to a source file selection (ALT-S)
//   dfRenderFileQueue      A render was initiated by a file moving out of the file queue
//
// In the case of dfRealDrop, Make sure you check the value of drop_to_editor before
// processing a file. You normally should let it be loaded into the editor, by returning
// false. If, however, you know something about the file (like it's not a text file), then
// you can do what you need to.
//
// Again, if you're writing some sort of LParser-like program, you can intercept render
// requests here and perform any needed processing before firing up the renderer yourself.

function DragFunction(var InstanceData: IDataStruct; szFile: PChar;
  DropType: ExternalDropType): BOOL; stdcall;
begin
  Result := False;
end;

// called whenever a menu selection is made on your menu. the code passed is the original
// menu command ID, before the offset was added to it. make sure you modify the below code
// to suit your application. note that an ABOUT and ENABLED menu entry is mandatory.
// we require that you make your enabled entry persistent by storing it in an INI file.
// the INI file should be stored wherever your DLL is ; preferably, this will be the
// <POV-Ray for Windows>\guiext\ directory. you MAY NOT write to the POV-Ray INI files.
//
// several of these entries are for demonstration. make sure you remove them.
function MenuSelect(var InstanceData: IDataStruct; Code: WPARAM): DWord; stdcall;
var
  Instance : PInstanceStruct;
  CheckCode: DWord;
begin
  Instance := PInstanceStruct(InstanceData.InstanceID);
  Result := 0;
  case Code of
    CM_ENABLED:
      begin
        Instance^.Enabled := not Instance^.Enabled;
        if Instance^.Enabled then CheckCode := MF_CHECKED else CheckCode := MF_UNCHECKED;
        CheckMenuItem(InstanceData.hMenu, CM_ENABLED + InstanceData.FirstMenuItem, CheckCode);
        Exit;
      end;
    CM_ABOUT:
      begin
        DialogBoxParam(Instance^.hInstance, MakeIntResource(IDD_ABOUT), 0,
          TFNDlgProc(@AboutDialogProc), DWord(Instance));
        Exit;
      end;
    CM_STARTRENDERING:
      begin
        Instance^.Request(RequestStartRendering, nil);
        Exit;
      end;
    CM_STOPRENDERING:
      begin
        Instance^.Request(RequestStopRendering, nil);
        Exit;
      end;
    CM_EXITPOV:
      begin
        Instance^.Request(RequestExit, nil);
        Exit;
      end;
    CM_HELP:
      begin
        MessageBox(Instance^.MainWindow,
          PChar('There is no help available'#13#13 + Contact),
          ExtName, MB_OK or MB_ICONSTOP);
        Exit;
      end;
  end;
  Result := 1;
end;

// provides the text for ToolTips. MANDATORY.
function MenuTip(var InstanceData: IDataStruct; Code: WPARAM): PChar; stdcall;
begin
  case Code of
    CM_ENABLED:
      begin
        Result := PChar('Enables/Disables the ' + ExtName);
        Exit;
      end;
    CM_ABOUT :
      begin
        Result := PChar('About the ' + ExtName);
        Exit;
      end;
    CM_STARTRENDERING:
      begin
        Result := 'Starts rendering';
        Exit;
      end;
    CM_STOPRENDERING:
      begin
        Result := 'Stops rendering';
        Exit;
      end;
    CM_EXITPOV:
      begin
        Result := 'Causes POV-Ray to exit';
        Exit;
      end;
    CM_HELP:
      begin
        Result := PChar('Help on the ' +  ExtName);
        Exit;
      end;
  end;
  Result := '';
end;

!! You need to agree. // Delete this line if you do

{**********************************************************************************************}
{*                                                                                            *}
{* This GUI extension WILL NOT LOAD unless you copy the below text, EXACTLY as it is,         *}
{* into the array 'Agreement' below. See the comment.                                         *}
{*                                                                                            *}
{*      'The author of this POV-Ray(tm) GUI Extension DLL certifies that, at the time of ' +  *}
{*      'its production or distribution, it complied with the POV-Ray Team's then current ' + *}
{*      'requirements for GUI Extensions to POV-Ray for Windows, and acknowledges that it ' + *}
{*      'is a violation of copyright to fail to do so. This text is copyright (c) the ' +     *}
{*      'POV-Team 1996. Used by permission."                                                  *}
{*                                                                                            *}
{* You may only use the above text if you comply with our terms and conditions as stated in   *}
{* the file 'POVEXT.TXT' distributed with this toolkit. While this may seem severe, we have   *}
{* good reasons for doing it, based on past experience. There are always, it seems, people    *}
{* who are willing to try to make a quick buck out of other people's hard work. You will note *}
{* that the agreement attempts to ensure the quality of GUI Extensions, and also that we, the *}
{* POV-Team, does not get our time wasted by people asking us for support on your extension.  *}
{*                                                                                            *}
{**********************************************************************************************}


function Init(InstanceID: DWord; RecSize: Integer; var InitStruct: GuiExtInitStruct): BOOL; stdcall; export;
var
  hMenu, hPopup: THandle;
  Instance: PInstanceStruct;
begin
  Instance := PInstanceStruct(InstanceID);

  Result := False;
  if RecSize <> SizeOf(GuiExtInitStruct) then
  begin
    MessageBox(0, PChar('InitStruct has invalid size ! (Probable version error)'#13#13 + Contact), ExtName, MB_OK or MB_ICONSTOP);
    Exit;
  end;
  if InitStruct.GuiInterfaceVersion div 100 <> GUI_INTERFACE_VERSION div 100 then
  begin
    MessageBox(0,
      PChar('Version error - this GUI extension cannot be used with ' +
        'your version of POV-Ray for Windows'#13#13 + Contact),
      ExtName, MB_OK or MB_ICONSTOP);
    Exit;
  end;
  Instance^.MainWindow := InitStruct.MainWindow ;
  Instance^.Request := InitStruct.ExternalRequest;
  InitStruct.Name := EXTNAME;
  InitStruct.DLLInterfaceVersion := GUI_INTERFACE_VERSION;
  InitStruct.Author := AUTHOR;
  InitStruct.AuthorEmail := EMAIL;

!! see above for information as to how to initialise this array. // Delete this line!
  StrCopy(InitStruct.Agreement, '');

  hMenu := CreateMenu;
  HPopup := CreateMenu;
  if (hMenu = 0) or (hPopup = 0) then
  begin
    MessageBox(Initstruct.MainWindow, PChar(Format('CreateMenu failed, code = %08X'#13#13'%s', [GetLastError, Contact])),
      ExtName, MB_OK or MB_ICONSTOP);
    Exit;
  end;

  // set up our menu. the allowable command ID range is InitStruct->FirstMenuItem to InitStruct->FirstMenuItem + 59.
  AppendMenu(hMenu, MF_STRING, CM_ENABLED + InitStruct.FirstMenuItem, '&Enabled');
  if Instance^.Enabled then
    CheckMenuItem(hMenu, CM_ENABLED + InitStruct.FirstMenuItem, MF_CHECKED)
  else
    CheckMenuItem(hMenu, CM_ENABLED + InitStruct.FirstMenuItem, MF_UNCHECKED);
  AppendMenu(hMenu, MF_STRING, CM_STARTRENDERING + InitStruct.FirstMenuItem, '&Start Rendering') ;
  AppendMenu(hMenu, MF_STRING, CM_STOPRENDERING + InitStruct.FirstMenuItem, 'Stop &Rendering') ;
  AppendMenu(hMenu, MF_STRING, CM_EXITPOV + InitStruct.FirstMenuItem, 'E&xit POV-Ray') ;
  AppendMenu(hMenu, MF_SEPARATOR, UINT(-1), '-') ;
  AppendMenu(hMenu, MF_POPUP, UINT(hPopup), '&Help') ;
  AppendMenu(hPopup, MF_STRING, CM_HELP + InitStruct.FirstMenuItem, '&Help on this GUI Extension');

  AppendMenu (hPopup, MF_STRING, CM_ABOUT + InitStruct.FirstMenuItem, '&About this GUI Extension') ;
  InitStruct.hMenu := hMenu ;
  Result := True;
end;

procedure DestroyInstance(var Instancedata: IDataStruct); stdcall;
var
  Instance: PInstanceStruct;
begin
  Instance := PInstanceStruct(InstanceData.InstanceID);
  DestroyMenu(Instancedata.hMenu);
  FreeMem(Instance);
end;

function PovGuiExtensionGetPointers(RecSize: Integer; var PointerBlock: GuiPointerBlock): DWord; stdcall; export;
var
  Instance: PInstanceStruct;
begin
  Result := 0;
  if RecSize <> SizeOf(GuiPointerBlock) then
  begin
    MessageBox(0, PChar('PointerBlock has invalid size ! (Probable version error)'#13#13 + Contact),
      EXTNAME, MB_OK or MB_ICONSTOP);
    Exit;
  end;
  PointerBlock.Init := Init;
  PointerBlock.Destroy := DestroyInstance;
  PointerBlock.MenuSelect := MenuSelect;
  PointerBlock.MenuTip := MenuTip;
  PointerBlock.Signature := $21434A43; //'CJC!';
  PointerBlock.CleanupAll := CleanupAll;

!! you need to choose which functions to implement. // Delete this line.
// Don't initialise ALL of these ! Only the ones that you need for your application.
//PointerBlock->Event = Event ;
//PointerBlock->DisplayPlot = DisplayPlot ;
//PointerBlock->DisplayPlotRect = DisplayPlotRect ;
//PointerBlock->WinPrePixel = WinPrePixel ;

//RV this was commented out, but I think it is neccessary for the demo dialog
//   pixel count to work.
PointerBlock.WinPostPixel := WinPostPixel;

//PointerBlock->WinSystem = WinSystem ;
//PointerBlock->BufferMessage = BufferMessage ;
//PointerBlock->ParseToolCommand = ParseToolCommand ;
//PointerBlock->DragFunction = DragFunction ;

//RV This was originally assigned, but I think WinPostPixel was meant.
//PointerBlock.AssignPixel := WinAssignPixel;

  // define whatever you need in the instance structure. POV-Ray for Windows treats is as a black box.
  // BE WARNED that you will need to be wary of multiple thread issues. don't forget that POV-Ray
  // can be loaded into memory more than once, and will link to your DLL more than once if this happens !
  GetMem(Instance, SizeOf(InstanceStruct));
  if Instance = nil then
  begin
    MessageBox(0, PChar('Cannot allocate instance data'#13#13 + Contact), EXTNAME, MB_OK or MB_ICONSTOP);
    Exit;
  end;
!! READ THIS FROM AN INI FILE ! it should be persistent. // Delete this line.
  Instance^.Enabled := TRUE ;
  Instance^.hInstance := hInstance ;
  // this is really a pointer to our InstanceStruct. don't confuse the term 'Instance' in this context
  // with Microsoft Windows's concept of an 'instance'. they're two different things.
  PointerBlock.InstanceID := DWORD(Instance);
  Result := 1;
end;

exports
  PovGuiExtensionGetPointers;

begin
!! You need to customise the AUTHOR, EMAIL and EXTNAME strings first. // Delete this line.

//RV If you don't do that, the extension will not load. See Messages window of
//   POV-Ray for Windows to see any error reports.
  Author :=  'Place Author Name Here';          // e.g. "Fu Bar"
  EMail :=   'Place Author Email Adress Here';  // e.g. fubar@somewhere.com. don't use '<' or '('.
  ExtName := 'Place the name of your extension Here';     // this is what's displayed to the users.
end.
