//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "modext.h"
//---------------------------------------------------------------------------
USEUNIT("modext.c");
USERES("modlextn.res");
USEFORM("about.cpp", AboutBox);
//---------------------------------------------------------------------------
int WINAPI DllEntryPoint(HINSTANCE hinst, unsigned long reason, void*)
{
    return 1;
}
//---------------------------------------------------------------------------
extern "C" void NotifyDisplayInit(InstanceStruct *pInstance, DWORD value)
{
    int width, height, size;

    if (pInstance->Enabled)
    {
        width = value & 0xffff;
        height = (value & 0xffff0000) >> 16;

        size = sizeof(RGBImage) + width * height * sizeof(RGBValue);

        pInstance->hFileMapping = CreateFileMapping((HANDLE)0xffffffff,
            NULL,
            PAGE_READWRITE,
            0,
            size,
            "Model Scene Editor Image");

        if (pInstance->hFileMapping)
        {
            pInstance->pImage = (RGBImage *)MapViewOfFile(pInstance->hFileMapping,
                FILE_MAP_WRITE,
                0,
                0,
                size);

            if (pInstance->pImage)
            {
                pInstance->pImage->width = width;
                pInstance->pImage->height = height;
                pInstance->pImage->active = 1;
                pInstance->pImage->x = 0;
                pInstance->pImage->y = 0;
            }
        }
    }
}
//---------------------------------------------------------------------------
extern "C" void NotifyStartRendering(InstanceStruct *pInstance)
{
    if (pInstance->Enabled && pInstance->pImage)
        pInstance->pImage->active = 2;
}
//---------------------------------------------------------------------------
extern "C" void NotifyStopRendering(InstanceStruct *pInstance)
{
    if (pInstance->Enabled && pInstance->pImage)
        pInstance->pImage->active = 3;
}
//---------------------------------------------------------------------------
extern "C" void NotifyDisplayFinished(InstanceStruct *pInstance)
{
    if (pInstance->Enabled && pInstance->pImage)
        pInstance->pImage->active = -1;

    if (pInstance->pImage)
    {
        UnmapViewOfFile(pInstance->pImage);

        pInstance->pImage = NULL;
    }

    if (pInstance->hFileMapping)
    {
        CloseHandle(pInstance->hFileMapping);

        pInstance->hFileMapping = NULL;
    }
}
//---------------------------------------------------------------------------
extern "C" void DoDisplayPlot(InstanceStruct *pInstance, int x, int y, int Red, int Green, int Blue)
{
    if (pInstance->Enabled && pInstance->pImage)
    {
        pInstance->pImage->x = x;
        pInstance->pImage->y = y;

        pInstance->pImage->bytes[x + pInstance->pImage->width * y].red = (unsigned char)Red;
        pInstance->pImage->bytes[x + pInstance->pImage->width * y].green = (unsigned char)Green;
        pInstance->pImage->bytes[x + pInstance->pImage->width * y].blue = (unsigned char)Blue;
    }
}

