typedef struct
{
    unsigned char red, green, blue;
} RGBValue;

typedef struct
{
    int active;
    int width, height;
    int x, y;
    RGBValue bytes[1];
} RGBImage;

typedef struct
{
  BOOL      Enabled ;
  HANDLE    hFileMapping;
  RGBImage  *pImage;
} InstanceStruct ;

#ifdef __cplusplus
extern "C"
{
#endif

extern void DisplayAboutBox(void);
extern void NotifyDisplayInit(InstanceStruct *pInstance, DWORD value);
extern void NotifyStartRendering(InstanceStruct *pInstance);
extern void NotifyStopRendering(InstanceStruct *pInstance);
extern void NotifyDisplayFinished(InstanceStruct *pInstance);

extern void DoDisplayPlot(InstanceStruct *pInstance, int x, int y, int Red, int Green, int Blue);

#ifdef __cplusplus
};
#endif


