#version 3.8;

#declare Radiosity = on;
#declare Level = 1;		//0 = low, 1 = high

global_settings {
	assumed_gamma 1.0
	ambient_light rgb 0
	max_trace_level 7
	
	#if (Radiosity)
		#if (Level)
			// High quality settings
			radiosity {
				adc_bailout 0.005
				always_sample off
				count 150			// 35 - 1600
				error_bound 0.25
				gray_threshold 0.2
				low_error_factor 0.25
				minimum_reuse 0.01
				maximum_reuse 0.2
				nearest_count 8
				pretrace_start 0.08
				pretrace_end   0.04 	//  0.01
				recursion_limit 5
				//brightness 1
			}  // end radiosity block
		#else
			// Low quality settings
			radiosity {
				pretrace_start 1	//  0.08
				pretrace_end   1	//  0.04 	//  0.01
				count 35  		//  150
				nearest_count 5  	//  10
				error_bound 1.8		//  0.5
				recursion_limit 2
				low_error_factor 0.5
				gray_threshold 0.0
				minimum_reuse 0.015  	//  0.005
				maximum_reuse 0.2
				brightness 1
				adc_bailout 0.01   	//  0.005
			}  // end radiosity block
		#end
	#else
	
	#end
}

// Scene to work out parametric union of triangles
// and calculation of normals for smooth_triangles

// Compare triangles, smooth triangles, bicubic_patch of different subdivisions


#declare Zoom = 450;
camera {
	orthographic
	location <0.5, 2, -20>
	right x*(image_width/Zoom)
	up y*(image_height/Zoom)
	look_at <0.5, 0.25, 1>
}

light_source {<0, 5, -1> rgb 1}
light_source {<0, -1, -3> rgb 0.5}

sky_sphere {pigment {rgb <0.6, 0.6, 1.0>}}

//cylinder {<0, 0, -100>, <0, 0, 100> 0.02 }

#include "BezierInclude.inc"
#include "math.inc"
//#include "BezierMacros.mcr"

#declare Mirror = texture {pigment {rgb 1} finish {reflection 1}}

//==========================================
#declare isophote_vector = x;		// angle reference vector
#declare IL = 0.25;				// line thickness
#declare IPscale = 40;			// line frequency
#declare Sharp = yes;			// sharp lines or fading
#declare Z = -1;   // Lighting type:  -1 white lines or 1 black lines

#declare Sr = 0.00225;	// sphere radius
#declare T_S = texture {pigment {rgb <0.5, 0, 0>} finish {specular 0.4}}	// sphere texture
#declare Cr = Sr/2;
#declare T_C = texture {pigment {rgb <0.5, 0, 0.0>} finish {specular 0.4}}	// cylinder texture
//#declare T_F = texture {pigment {rgb <0, 0, 0.5>} finish {specular 0.4}}	// face texture
#declare T_F = texture {pigment {rgb <1, 0.5, 0.0>} finish {diffuse 0.7 specular 0.3 emission 0.1} normal {agate bump_size 0.1 scale 0.01}}	// face texture
#declare T_FI = texture {pigment {rgb <0.0, 0.1, 0>} finish {diffuse 0.6 specular 0.4} normal {agate bump_size 0.1 scale 0.1}}	// face interior texture

#declare Vertices = no;
#declare Edges = yes;
#declare Faces = yes;
#declare Smooth = yes;
#declare UStep = 16;
#declare VStep = 16;
//==========================================


// Isophote texture definition
#declare T_IP =
texture {
	pigment {
		slope {isophote_vector}
			color_map {
				#for (F, 0, IPscale-1)
					[ F/IPscale rgb 0.5+0.5*Z ]
					#if (Sharp) [ (F+0.5-IL)/IPscale rgb 0.5+0.5*Z ] #end
					[ (F+0.5-IL)/IPscale rgb 0.5-0.5*Z ]
					[ (F+0.5+IL)/IPscale rgb 0.5-0.5*Z ]
					#if (Sharp) [ (F+0.5+IL)/IPscale rgb 0.5+0.5*Z ] #end
					[ (F+1)/IPscale rgb 0.5+0.5*Z ]
				#end
			}
	}
	finish {emission 1}
}

//sphere {0, 400 texture {T_IP} no_image}

#declare IP_L = texture {pigment {gradient x} finish {emission 1}}

//##############################################################

//##############################################################

#declare Lump = -z*2.5;	
#declare del = 1/7;	

#declare P1  = <0.00,  0.00,  0.00>;		// uv vector <0, 0>
#declare P2  = < 1/3,  0.00,  0.00>;
#declare P3  = < 2/3,  0.00,  0.00>;
#declare P4  = <1.00,  0.00,  0.00>;		// uv vector <1, 0> 

#declare P5  = <0.00,   1/3+del,  0.00>;
#declare P6  = < 1/3,   1/3+del,  0.00> - Lump;
#declare P7  = < 2/3,   1/3+del,  0.00> - Lump;
#declare P8  = <1.00,   1/3+del,  0.00>;

#declare P9  = <0.00,   2/3-del,  0.00>;
#declare P10 = < 1/3,   2/3-del,  0.00> + Lump;
#declare P11 = < 2/3,   2/3-del,  0.00> + Lump;
#declare P12 = <1.00,   2/3-del,  0.00>;

#declare P13 = <0.00,  1.00,  0.00>;		// uv vector <0, 1>
#declare P14 = < 1/3,  1.00,  0.00>;
#declare P15 = < 2/3,  1.00,  0.00>;
#declare P16 = <1.00,  1.00,  0.00>;		// uv vector <1, 1>



#declare ControlPoints = array [4][4] {
{ P1, P2,  P3,  P4},
{ P5, P6,  P7,  P8},
{ P9, P10, P11, P12},
{P13, P14, P15, P16}
}

#declare Bezier = function (A, B, C, D, T) {A*pow(1-T,3) + 3*B*T*pow(1-T,2) + 3*C*pow(T,2)*(1-T) + D*pow(T,3)}

#declare FastNCM = function (n, k) {prod(i, k+1, n, i) / prod(i, 1, n-k, i)}
#declare PowerFn = function(s, p) { select(p, pow(s, p), 1, pow(s, p)) }
#declare Bernstein = function (Deg, K, S) {FastNCM(Deg, K) * PowerFn(S, K) * PowerFn (1 - S, Deg - K)}

#macro F_Bezier (_Array, _Element) 
// Assembles formula for one element of Bezier patch 
// (need to run 3 times for x, y, and z)
#local Degree = 3;
	function (_U, _V) {
	#for (j, 0, 3)
		#for (i, 0, 3)
		#local _P = select (_Element, _Array [i][j].x, _Array [i][j].y, _Array [i][j].z);
		//#debug concat(Scalar(i, 0, 0), ", ", Scalar(j, 0, 1), "\n")
		Bernstein(3, i, _V) * Bernstein(3, j, _U) * _P +
		#end
	#end
	0}  // terminates equation for sum of all Bernstein polynomials in the patch
#end

// define component functions for parametric
#declare BezierX = F_Bezier (ControlPoints, -1)
#declare BezierY = F_Bezier (ControlPoints,  0)
#declare BezierZ = F_Bezier (ControlPoints,  1)

#declare UIStep = 1/UStep;
#declare VIStep = 1/VStep;
#declare MeshArray = array [UStep+1] [VStep+1];

#for (UI, 0, UStep)
	#for (VI, 0, VStep)
		#local U = UI * UIStep;	// convert to 0-1 domain for Bezier functions
		#local V = VI * VIStep;
		#declare MeshArray [UI][VI] = <BezierX (U, V), BezierY (U, V), BezierZ (U, V)>;
	#end
#end





#macro CalculateNormal (_Array, _X, _Y)
	#local _xmax = dimension_size (_Array, 1)-1;
	#local _ymax = dimension_size (_Array, 2)-1;
	
	#if (_X-1 >= 0)
		#local _L = _Array [_X-1][_Y];
	#else
		//#debug "_L\n"
		//#local _L = _Array [_X+1][_Y] - _Array [_X][_Y];
		#local _L = _Array [_X][_Y];
	#end
	
	#if (_Y < _ymax)
		#local _U = _Array [_X][_Y+1];
	#else
		//#debug "_U\n"
		#local _U = _Array [_X][_Y];
	#end
	
	#if (_X < _xmax & _Y < _ymax)
		#local _UR = _Array [_X+1][_Y+1];
	/*
	#elseif (_X < _xmax)
		#debug "_URy\n"
		#local _UR = -y*_Array [_X+1][_Y-1];
	#elseif (_Y < _ymax)
		#debug "_URx\n"
		#local _UR = -x*_Array [_X-1][_Y+1];
	*/
	#else
		//#debug "_URxy\n"
		#local _UR = _Array [_X][_Y];
	#end
	
	#if (_X < _xmax)
		#local _R = _Array [_X+1][_Y];
	#else
		//#debug "_R\n"
		//#local _R = _Array [_X][_Y] - _Array [_X-1][_Y];
		#local _R = _Array [_X][_Y];
	#end
	
	#if (_Y-1 >= 0)
		#local _D = _Array [_X][_Y-1];
	#else
		#debug "_D\n"
		#local _D = _Array [_X][_Y];
	#end
	
	#if (_X-1 >= 0 & _Y-1 >= 0)
		#local _DL = _Array [_X-1][_Y-1];
	/*
	#elseif (_X-1 < 0 & _Y-1 >= 0)
		#debug "_DLx\n"
		#local _DL = -x*_Array [_X+1][_Y-1];
	#elseif (_Y-1 < 0 & _X-1 >= 0)
		#debug "_DLy\n"
		#local _DL = -y*_Array [_X-1][_Y+1];
	*/
	#else
		//#debug "_DLxy\n"
		#local _DL = _Array [_X][_Y];
	#end
	
	#local N1 = vcross (_L, _U);
	#local N2 = vcross (_U, _UR);
	#local N3 = vcross (_UR, _R);
	#local N4 = vcross (_R, _D);
	#local N5 = vcross (_D, _DL);
	#local N6 = vcross (_DL, _L);
	
	#local Sum = N1 + N2 + N3 + N4 + N5 + N6;
	
	#local _NormalVector = vnormalize (Sum);

	_NormalVector
#end

union {
#declare N1 = dimension_size (MeshArray, 1)-1;
#declare N2 = dimension_size (MeshArray, 2)-1;
#for (U, 0, N1)
	#for (V, 0, N2)
		#if (U != N1 & V != N2)
			#if (Vertices)
				sphere {MeshArray [U][V] Sr texture {T_S}}
				sphere {MeshArray [U+1][V+1] Sr texture {T_S}}
				sphere {MeshArray [U][V+1] Sr texture {T_S}}
				
				//sphere {MeshArray [U][V+1] Sr texture {T_S}}
				sphere {MeshArray [U+1][V] Sr texture {T_S}}
				//sphere {MeshArray [U+1][V] Sr texture {T_S}}
			#end // end if Vertices
			#if (Edges)
				cylinder {MeshArray [U][V] MeshArray [U+1][V+1] Cr texture {T_C}}
				cylinder {MeshArray [U+1][V+1] MeshArray [U][V+1] Cr texture {T_C}}
				cylinder {MeshArray [U][V+1] MeshArray [U][V] Cr texture {T_C}}
				
				cylinder {MeshArray [U][V] MeshArray [U+1][V] Cr texture {T_C}}
				cylinder {MeshArray [U+1][V] MeshArray [U+1][V+1] Cr texture {T_C}}
				cylinder {MeshArray [U+1][V+1] MeshArray [U][V] Cr texture {T_C}}
			#end
			#if (Faces)
				#if (Smooth)
					//#declare N1da = vnormalize (<BezierX (U, V+d), BezierY (U, V+d), BezierZ (U, V+d)>);
					//#declare N1db = vnormalize (<BezierX (U+d, V), BezierY (U+d, V), BezierZ (U+d, V)>);
					//#declare N_1 = vnormalize (vcross (N1da-MeshArray [U][V], N1db-MeshArray [U][V]));
					//#declare N_1 = vnormalize (vcross (MeshArray [U][V+1]-MeshArray [U][V], MeshArray [U+1][V]-MeshArray [U][V]));
					#declare N_1 = CalculateNormal (MeshArray, U, V);
					//#declare N2da = vnormalize (<BezierX (U+UIStep, V+VIStep-d), BezierY (U+UIStep, V+VIStep-d), BezierZ (U+UIStep, V+VIStep-d)>);
					//#declare N2db = vnormalize (<BezierX (U+UIStep-d, V+VIStep), BezierY (U+UIStep-d, V+VIStep), BezierZ (U+UIStep-d, V+VIStep)>);
					//#declare N_2 = vnormalize (vcross (N2da-MeshArray [U+1][V+1], N2db-MeshArray [U+1][V+1]));
					//#declare N_2 = vnormalize (vcross (MeshArray [U+1][V]-MeshArray [U+1][V+1], MeshArray [U][V+1]-MeshArray [U+1][V+1]));
					#declare N_2 = CalculateNormal (MeshArray, U+1, V+1);
					//#declare N3da = vnormalize (<BezierX (U+d, V+VIStep), BezierY (U+d, V+VIStep), BezierZ (U+d, V+VIStep)>);
					//#declare N3db = vnormalize (<BezierX (U, V+VIStep-d), BezierY (U, V+VIStep-d), BezierZ (U, V+VIStep-d)>);
					//#declare N_3 = vnormalize (vcross (N3da-MeshArray [U][V+1], N3db-MeshArray [U][V+1]));
					//#declare N_3 = vnormalize (vcross (MeshArray [U+1][V+1]-MeshArray [U][V+1], MeshArray [U][V]-MeshArray [U][V+1]));
					#declare N_3 = CalculateNormal (MeshArray, U, V+1);
					smooth_triangle {
						MeshArray [U][V], N_1,
						MeshArray [U+1][V+1], N_2,
						MeshArray [U][V+1], N_3
						//texture {T_F}
						//interior_texture {T_FI}
					}
					//#declare N_4 = vnormalize (vcross (MeshArray [U][V]-MeshArray [U+1][V], MeshArray [U+1][V+1]-MeshArray [U+1][V]));
					#declare N_4 = CalculateNormal (MeshArray, U+1, V);
					smooth_triangle {
						MeshArray [U][V], N_1
						MeshArray [U+1][V], N_4 
						MeshArray [U+1][V+1], N_2
						//texture {T_F}
						//interior_texture {T_FI}
					}

				#else
					triangle {
						MeshArray [U][V], MeshArray [U+1][V+1], MeshArray [U][V+1]
						//texture {T_F}
						//interior_texture {T_FI}
					}
					
					triangle {
						MeshArray [U][V], MeshArray [U+1][V], MeshArray [U+1][V+1]
						//texture {T_F}
						//texture {IP_L}
						//interior_texture {T_FI}
					}
				#end
			#end
		#end // if U, V
	#end
#end
texture {T_F}
interior_texture {T_FI}
//texture {Mirror}
//texture {IP_L}
rotate x*60
translate -x*0.55
}

bicubic_patch {
	type 1
	//flatness 0
	u_steps 4
	v_steps 4
	//  default 
	uv_vectors <0,0>,<1,0>,<1,1>,<0,1>
	 P1, P2,  P3,  P4,
	 P5, P6,  P7,  P8,
	 P9, P10, P11, P12,
	P13, P14, P15, P16
	//uv_mapping
	texture {T_F}
	//texture {IP_L}
	//texture {Mirror}
	interior_texture {T_FI}
	rotate x*60
	translate x*0.55
}



