#declare Tan = texture {pigment {rgb <0.92, 0.60, 0.20>} finish {diffuse 0.7 specular 0.2 reflection 0.02}}

#declare Shade = 0.5;
//-----------------
#declare   _Red = texture {pigment {rgb <1, 0, 0>*Shade} finish {diffuse 0.7 specular 0.2 reflection 0.02}}
#declare _Green = texture {pigment {rgb <0, 1, 0>*Shade} finish {diffuse 0.7 specular 0.2 reflection 0.02}}
#declare  _Blue = texture {pigment {rgb <0, 0, 1>*Shade} finish {diffuse 0.7 specular 0.2 reflection 0.02}}
#declare _White = texture {pigment {rgb 1} finish {diffuse 0.7 specular 0.2 reflection 0.02}}
#declare _Gray50 = texture {pigment {rgb <0.5, 0.5, 0.5>*Shade} finish {diffuse 0.7 specular 0.2 reflection 0.02}}
#declare _Clear = texture {pigment {rgbt 1}}

#declare _BlackMarble =
texture {
	pigment {marble
		turbulence 0.6
		color_map {
			[0.0 rgb 1]
			[0.1 rgb 1]
			[0.1 rgb 0]
			[0.5 rgb 0]
			[0.5 rgb 1]
			[0.6 rgb 1]
			[0.6 rgb 0]
			[1.0 rgb 0]
		}
	}
	scale 0.05
}

#declare _WhiteMarble =
texture {
	pigment {marble
		turbulence 0.6
		color_map {
			[0.0 rgb <0, 0, 0>]
			[0.1 rgb <0, 0, 0>]
			[0.1 rgb 0.5]
			[0.5 rgb 0.5]
			[0.5 rgb <0, 0, 0>]
			[0.6 rgb <0, 0, 0>]
			[0.6 rgb 0.5]
			[1.0 rgb 0.5]
		}
	}
	scale 0.05
}

#declare _RedMarble =
texture {
	pigment {marble
		turbulence 0.6
		color_map {
			[0.0 rgb <1, 0, 0>*Shade]
			[0.1 rgb <1, 0, 0>*Shade]
			[0.1 rgb 0.5]
			[0.5 rgb 0.5]
			[0.5 rgb <1, 0, 0>]
			[0.6 rgb <1, 0, 0>]
			[0.6 rgb 0.5]
			[1.0 rgb 0.5]
		}
	}
	scale 0.05
}

#declare _GreenMarble =
texture {
	pigment {marble
		turbulence 0.6
		color_map {
			[0.0 rgb  <0, 1, 0>*Shade]
			[0.1 rgb  <0, 1, 0>*Shade]
			[0.1 rgb 0.5]
			[0.5 rgb 0.5]
			[0.5 rgb  <0, 1, 0>]
			[0.6 rgb  <0, 1, 0>]
			[0.6 rgb 0.5]
			[1.0 rgb 0.5]
		}
	}
	scale 0.05
}

#declare _MarbleNormal =
normal {marble
	turbulence 0.6
	bump_size 2
	scale 0.05
}

#declare Line = 0.01;
#declare HL = Line/2;

#macro L2Point (_P, Label, _S, _TP, _T)
	// Point, Label, Size, TextPosition, Texture
	// Automatically shows coordinates of point
	union {
	sphere {<0, 0, 0> Line*1.1*_S texture {_T}} 
	text {ttf "timrom.ttf", Label, 0.02, 0.0 
		scale 0.04 translate <-0.025, -0.15/2, 0> translate _TP pigment {rgb 0} translate -z*Line*2}
	text {ttf "timrom.ttf", concat ("<", vstr(3, _P, ", ", 0, 2), ">"), 0.02, 0.0 
		scale 0.04 translate <-0.17, -0.15, 0> translate _TP pigment {rgb 0} translate -z*Line*2} //texture {_Blue}}
	translate _P
	translate -z*Line
	}
#end

#macro LPoint (_P, Label, _S, _TP, _T)
	// Point, Label, Size, TextPosition, Texture
	union {
	sphere {<0, 0, 0> Line*1.1*_S texture {_T}} 
	text {ttf "timrom.ttf", Label, 0.02, 0.0 
		scale 0.04 translate <-0.025, -0.15/2, 0> translate _TP pigment {rgb 0} translate -z*Line*2}
	translate _P
	translate -z*Line
	}
#end

#macro Point (_P, _S, _T)
	// Point, Size, Texture
	sphere {<0, 0, 0> Line*1.1*_S texture {_T}
	translate _P
	translate -z*Line
	}
#end

#macro Lerp (_P1, _P2, T)
	#local _Pmid = (1-T)*_P1 + (T*_P2);
	_Pmid
#end


#declare Origin = sphere {<0,0,0> Line*1.0 texture {_WhiteMarble} normal {_MarbleNormal}} 
#declare AH = 0.125;
#declare ArrowHead = prism {
    conic_sweep
    linear_spline
    0, // height 1
    1, // height 2
    5, // the number of points making up the shape...
    <Line, Line>, <-Line, Line>, <-Line, -Line>, <Line, -Line>, <Line, Line>, 
    rotate <180, 0, 0>
    translate <0, 1, 0>
    scale <1, 1, 1>
  }
  
//#declare Xaxis = cylinder {<0, 0, 0>, <1, 0, 0> Line texture {_Red}}
#declare Xaxis = union {
	box {<0, -HL, -HL>, <1, HL, HL>}
	object {ArrowHead rotate -z*90 scale <AH, 1, 1> translate x}
	texture {_RedMarble} normal {_MarbleNormal}
}

//#declare Yaxis = cylinder {<0, 0, 0>, <0, 1, 0> Line texture {_Green}}
#declare Yaxis = union {
	box {<-HL, 0, -HL>, <HL, 1, HL>}
	object {ArrowHead scale <1, AH, 1> translate y}
	texture {_GreenMarble} normal {_MarbleNormal}
}

#macro ColorCodedRound_Box(A, B, EdgeRadius, UseMerge)
	#local Shade = 0.5;
	#local SC = pigment {rgb <1, 0, 0>*Shade}
	#local CC = pigment {rgb <0, 1, 0>*Shade}
	#local PC = pigment {rgb <0, 0, 1>*Shade}
   #local AA = <min(A.x, B.x), min(A.y, B.y), min(A.z, B.z)>;
   #local BB = <max(A.x, B.x), max(A.y, B.y), max(A.z, B.z)>;

   #local Delta=abs(BB.x-AA.x)/2;
   #if (Delta<EdgeRadius)
      #warning "\nRound_Box() macro called with x-size < Radius,\nresults may not be as expected\n"

      #local AA = <AA.x+Delta, AA.y, AA.z>;
      #local BB = <BB.x-Delta, BB.y, BB.z>;
   #else
      #local AA = <AA.x+EdgeRadius, AA.y, AA.z>;
      #local BB = <BB.x-EdgeRadius, BB.y, BB.z>;
   #end

   #local Delta=abs(BB.y-AA.y)/2;
   #if (Delta<EdgeRadius)
      #warning "\nRound_Box() macro called with y-size < Radius,\nresults may not be as expected\n"

      #local AA = <AA.x, AA.y+Delta, AA.z>;
      #local BB = <BB.x, BB.y-Delta, BB.z>;
   #else
      #local AA = <AA.x, AA.y+EdgeRadius, AA.z>;
      #local BB = <BB.x, BB.y-EdgeRadius, BB.z>;
   #end

   #local Delta=abs(BB.z-AA.z)/2;
   #if (Delta<EdgeRadius)
      #warning "\nRound_Box() macro called with z-size < Radius,\nresults may not be as expected\n"

      #local AA = <AA.x, AA.y, AA.z+Delta>;
      #local BB = <BB.x, BB.y, BB.z-Delta>;
   #else
      #local AA = <AA.x, AA.y, AA.z+EdgeRadius>;
      #local BB = <BB.x, BB.y, BB.z-EdgeRadius>;
   #end

   #local LBF = AA;
   #local RBF = < BB.x, AA.y, AA.z>;
   #local RBB = < BB.x, AA.y, BB.z>;
   #local LBB = < AA.x, AA.y, BB.z>;
   #local LTF = < AA.x, BB.y, AA.z>;
   #local RTF = < BB.x, BB.y, AA.z>;
   #local RTB = BB;
   #local LTB = < AA.x, BB.y, BB.z>;

   #if(UseMerge)
      merge {
   #else
      union {
   #end
   	union {
      sphere {LBF, EdgeRadius}

      #if (AA.x != BB.x)
         sphere {RBF, EdgeRadius}
      #end
      #if ((AA.x != BB.x) & (AA.z != BB.z))
         sphere {RBB, EdgeRadius}
      #end
      #if (AA.z != BB.z)
         sphere {LBB, EdgeRadius}
      #end

      #if (AA.y != BB.y)
         sphere {LTF, EdgeRadius}
      #end
      #if ((AA.x != BB.x) & (AA.y != BB.y))
         sphere {RTF, EdgeRadius}
      #end
      #if ((AA.x != BB.x) & (AA.y != BB.y) & (AA.z != BB.z))
         sphere {RTB, EdgeRadius}
      #end
      #if ((AA.y != BB.y) & (AA.z != BB.z))
         sphere {LTB, EdgeRadius}
      #end
       pigment {SC}
	}
	union {
      #if (AA.x != BB.x)
         cylinder {LBF, RBF, EdgeRadius}
         cylinder {LBB, RBB, EdgeRadius}
         cylinder {LTB, RTB, EdgeRadius}
         cylinder {LTF, RTF, EdgeRadius}
      #end

      #if (AA.y != BB.y)
         cylinder {LBF, LTF, EdgeRadius}
         cylinder {RBF, RTF, EdgeRadius}
         cylinder {RBB, RTB, EdgeRadius}
         cylinder {LBB, LTB, EdgeRadius}
      #end

      #if (AA.z != BB.z)
         cylinder {LTB, LTF, EdgeRadius}
         cylinder {LBB, LBF, EdgeRadius}
         cylinder {RTB, RTF, EdgeRadius}
         cylinder {RBB, RBF, EdgeRadius}
      #end
	 pigment {CC}
	 }
	 union {
      box {AA-EdgeRadius*x, BB+EdgeRadius*x}
      box {AA-EdgeRadius*y, BB+EdgeRadius*y}
      box {AA-EdgeRadius*z, BB+EdgeRadius*z}
       pigment {PC}
      }
   }
#end