//#include "BillsArrayMacros.pov"   // for printing out array data to debug
//#include "Fmod.inc"

// Fast NChooseM
#declare FastNCM = function (n, k) {prod(i, k+1, n, i) / prod(i, 1, n-k, i)}

#macro Choose (_N, _Array)
	// returns an element from an array
	// uses mod () to cycle through array no matter the size of _N or _Array
	
	// *** Add optional dimension to access other than 1

	
	#local _Size = dimension_size (_Array,1);
	#local __N = select (_N, (_Size + _N), 0, _N);
	#local _Item = mod (__N, _Size);
	#local _Result = _Array [_Item];
	
	_Result
#end

#declare Round = function (Value) {ceil(Value - 0.5)}

#declare PowerFn = function(s, p) { select(p, pow(s, p), 1, pow(s, p)) }

#declare Bernstein = function (Deg, K, S) {FastNCM(Deg, K) * PowerFn(S, K) * PowerFn (1 - S, Deg - K)}

#macro Interpolate (Vec1, Vec2, Vec3)
	// this interpolates points based on a slope between two edge corners and the far corner of an adjacent patch
    
	#local LengthA  = vlength (Vec1 - Vec3);
	#local LengthB  = vlength (Vec2 - Vec3);
	#local Length  = min (LengthA, LengthB);
	#local NVector = vnormalize (Vec1 - Vec2);
	#local _Vector  = (Length * NVector) / 3;
	_Vector
#end

#macro Point (_U, _V, _Array)   // calculates point on bezier patch based on <U, V> coordinates
#local Degree = 3;
	#local P =
	#for (j, 0, 3)
		#for (i, 0, 3)
		//#debug concat(Scalar(i, 0, 0), ", ", Scalar(j, 0, 1), "\n")
		Bernstein(Degree, i, _V) * Bernstein(Degree, j, _U) * _Array [i][j] +
		#end
	#end
	0;  // terminates equation for sum of all Bernstein polynomials in the patch
	P
#end
