
#macro mecStructQuadriPlaneBoundOutside(_vB, _vC, _vD)
  #local _minX = 0.0;
  #local _maxX = 0.0;
  #local _minZ = 0.0;
  #local _maxZ = 0.0;
  #if (_vD.x < _minX)
    #local _minX = _vD.x;
  #end
  #if (_vC.x > _maxX)
    #local _maxX = _vC.x;
  #end
  #if (_vB.x > _maxX)
    #local _maxX = _vB.x;
  #end
  #if (_vB.y < _minZ)
    #local _minZ = _vB.y;
  #end
  #if (_vC.y > _maxZ)
    #local _maxZ = _vC.y;
  #end
  #if (_vD.y > _maxZ)
    #local _maxZ = _vD.y;
  #end
  #local _res = array[4];
  #local _res[0] = _minX;
  #local _res[1] = _maxX;
  #local _res[2] = _minZ;
  #local _res[3] = _maxZ;
  _res
#end

#macro mecStructQuadriPlaneBoundInside(_vB, _vC, _vD)
  #local _minX = 0.0;
  #local _maxX = 100000.0;
  #local _minZ = 0.0;
  #local _maxZ = 100000.0;
  #if (_vD.x > _minX)
    #local _minX = _vD.x;
  #end
  #if (_vC.x < _maxX)
    #local _maxX = _vC.x;
  #end
  #if (_vB.x < _maxX)
    #local _maxX = _vB.x;
  #end
  #if (_vB.y > _minZ)
    #local _minZ = _vB.y;
  #end
  #if (_vC.y < _maxZ)
    #local _maxZ = _vC.y;
  #end
  #if (_vD.y < _maxZ)
    #local _maxZ = _vD.y;
  #end
  #local _res = array[4];
  #local _res[0] = _minX;
  #local _res[1] = _maxX;
  #local _res[2] = _minZ;
  #local _res[3] = _maxZ;
  _res
#end

// plate in plane x,z, corner A at (0,0)
// counterclockwise : ABCD
// along y : from 0.0+roundness to -thickness
#macro mecStructQuadriPlane(_vB, _vC, _vD, _thickness, _roundness, _hasStripe, _material)
  #local _minMax = mecStructQuadriPlaneBoundOutside(_vB, _vC, _vD);
  #local _minX = _minMax[0];
  #local _maxX = _minMax[1];
  #local _minZ = _minMax[2];
  #local _maxZ = _minMax[3];
  union {
    difference {
      union {
        box {
          <_minX, _roundness, _minZ>
          <_maxX, -_thickness, _maxZ>
        }
        #if (_roundness > 0.001)
          box { <_minX - _roundness, 0.0, _minZ> <_maxX + _roundness, -_thickness, _maxZ> }
          box { <_minX, 0.0, _minZ - _roundness> <_maxX, -_thickness, _maxZ + _roundness> }
        #end
        material {_material}
      }
      union {
        #if (abs(_vB.x) > 0.001)
          #local _theta = -1.0 * degrees(atan(_vB.y / _vB.x));
        #else
          #local _theta = 0.0;
        #end
        #if (_roundness > 0.001)
          box {
            <-1.0, -0.001, 0.0> <100000.0, 100000.0, -100000.0>
            rotate _theta*y
          }
          box {
            <0.0, 0.001, 0.0> <-100000.0, -100000.0, -100000.0>
            rotate _theta*y
          }
          #declare _l = sqrt(_vB.x * _vB.x + _vB.y * _vB.y);
          box {
            <_l, 0.001, 0.0> <_l + 100000.0, -100000.0, -100000.0>
            rotate _theta*y
          }
        #end
        box {
          <-1.0, 0.001, -_roundness-0.00001> <100000.0, -100000.0, -100000.0>
          rotate _theta*y
        }
        #if (abs(_vD.y) > 0.001)
          #local _theta = degrees(atan(_vD.x / _vD.y));
        #else
          #local _theta = 0.0;
        #end
        #if (_roundness > 0.001)
          box {
            <0.0, -0.001, -100000.0> <-100000.0, 100000.0, 100000.0>
            rotate _theta*y
          }
          box {
            <0.0, 0.001, 0.0> <-100000.0, -100000.0, -100000.0>
            rotate _theta*y
          }
          #declare _l = sqrt(_vD.x * _vD.x + _vD.y * _vD.y);
          box {
            <0.0, 0.001, _l> <-100000.0, -100000.0, _l + 100000.0>
            rotate _theta*y
          }
        #end
        box {
          <-_roundness-0.00001, 0.001, -100000.0> <-100000.0, -100000.0, 100000.0>
          rotate _theta*y
        }
        #if (abs(_vC.x - _vD.x) > 0.001)
          #local _theta = -degrees(atan((_vC.y - _vD.y) / (_vC.x - _vD.x)));
        #else
          #local _theta = 0.0;
        #end
        #if (_roundness > 0.001)
          box {
            <-1.0, -0.001, 0.0> <100000.0, 100000.0, 100000.0>
            rotate _theta*y
            translate <_vD.x, 0.0, _vD.y>
          }
          box {
            <0.0, 0.001, 0.0> <-100000.0, -100000.0, 100000.0>
            rotate _theta*y
            translate <_vD.x, 0.0, _vD.y>
          }
          #declare _l = sqrt((_vC.x - _vD.x) * (_vC.x - _vD.x) + (_vC.y - _vD.y) * (_vC.y - _vD.y));
          box {
            <_l, 0.001, 0.0> <_l + 100000.0, -100000.0, 100000.0>
            rotate _theta*y
            translate <_vD.x, 0.0, _vD.y>
          }
        #end
        box {
          <-1.0, 0.001, _roundness+0.00001> <100000.0, -100000.0, 100000.0>
          rotate _theta*y
          translate <_vD.x, 0.0, _vD.y>
        }
        #if (abs(_vC.y - _vB.y) > 0.001)
          #local _theta = degrees(atan((_vC.x - _vB.x) / (_vC.y - _vB.y)));
        #else
          #local _theta = 0.0;
        #end
        #if (_roundness > 0.001)
          box {
            <0.0, -0.001, -100000.0> <100000.0, 100000.0, 100000.0>
            rotate _theta*y
            translate <_vB.x, 0.0, _vB.y>
          }
          box {
            <0.0, 0.001, 0.0> <100000.0, -100000.0, -100000.0>
            rotate _theta*y
            translate <_vB.x, 0.0, _vB.y>
          }
          #declare _l = sqrt((_vC.x - _vB.x) * (_vC.x - _vB.x) + (_vC.y - _vB.y) * (_vC.y - _vB.y));
          box {
            <0.0, 0.001, _l> <100000.0, -100000.0, _l + 100000.0>
            rotate _theta*y
            translate <_vB.x, 0.0, _vB.y>
          }
        #end
        box {
          <_roundness+0.00001, 0.001, -100000.0> <100000.0, -100000.0, 100000.0>
          rotate _theta*y
          translate <_vB.x, 0.0, _vB.y>
        }
        material {_material}
      }
    }
    #if (_roundness > 0.001)
      union {
        cylinder { <0.0, 0.0, 0.0>, <_vB.x, 0.0, _vB.y>, _roundness }
        cylinder { <0.0, 0.0, 0.0>, <_vD.x, 0.0, _vD.y>, _roundness }
        cylinder { <_vB.x, 0.0, _vB.y>, <_vC.x, 0.0, _vC.y>, _roundness }
        cylinder { <_vD.x, 0.0, _vD.y>, <_vC.x, 0.0, _vC.y>, _roundness }
        cylinder { <0.0, 0.0, 0.0>, <0.0, -_thickness, 0.0>, _roundness }
        cylinder { <_vB.x, 0.0, _vB.y>, <_vB.x, -_thickness, _vB.y>, _roundness }
        cylinder { <_vC.x, 0.0, _vC.y>, <_vC.x, -_thickness, _vC.y>, _roundness }
        cylinder { <_vD.x, 0.0, _vD.y>, <_vD.x, -_thickness, _vD.y>, _roundness }
        sphere { <0.0, 0.0, 0.0>, _roundness }
        sphere { <_vB.x, 0.0, _vB.y>, _roundness }
        sphere { <_vC.x, 0.0, _vC.y>, _roundness }
        sphere { <_vD.x, 0.0, _vD.y>, _roundness }
        #if (_hasStripe = 0)
          material {_material}
        #else
          material {
            texture {
              pigment {
                gradient y
                color_map {
                  [0.0 color rgb <1.0, 1.0, 1.0>]
                  [0.5 color rgb <1.0, 1.0, 1.0>]
                  [0.5 color rgb <1.0, 0.0, 0.0>]
                  [1.0 color rgb <1.0, 0.0, 0.0>]
                }
                scale 0.025
              }
              rotate 45.0*x
              rotate 45.0*y
            }
          }
        #end
      }
    #end
  }
#end

#macro mecStructQuadriPlaneWithoutMaterial(_vB, _vC, _vD, _thickness, _roundness)
  #local _minMax = mecStructQuadriPlaneBoundOutside(_vB, _vC, _vD);
  #local _minX = _minMax[0];
  #local _maxX = _minMax[1];
  #local _minZ = _minMax[2];
  #local _maxZ = _minMax[3];
  union {
    difference {
      union {
        box {
          <_minX, _roundness, _minZ>
          <_maxX, -_thickness, _maxZ>
        }
        #if (_roundness > 0.001)
          box { <_minX - _roundness, 0.0, _minZ> <_maxX + _roundness, -_thickness, _maxZ> }
          box { <_minX, 0.0, _minZ - _roundness> <_maxX, -_thickness, _maxZ + _roundness> }
        #end
      }
      union {
        #if (abs(_vB.x) > 0.001)
          #local _theta = -1.0 * degrees(atan(_vB.y / _vB.x));
        #else
          #local _theta = 0.0;
        #end
        #if (_roundness > 0.001)
          box {
            <-1.0, -0.001, 0.0> <100000.0, 100000.0, -100000.0>
            rotate _theta*y
          }
          box {
            <0.0, 0.001, 0.0> <-100000.0, -100000.0, -100000.0>
            rotate _theta*y
          }
          #declare _l = sqrt(_vB.x * _vB.x + _vB.y * _vB.y);
          box {
            <_l, 0.001, 0.0> <_l + 100000.0, -100000.0, -100000.0>
            rotate _theta*y
          }
        #end
        box {
          <-1.0, 0.001, -_roundness-0.00001> <100000.0, -100000.0, -100000.0>
          rotate _theta*y
        }
        #if (abs(_vD.y) > 0.001)
          #local _theta = degrees(atan(_vD.x / _vD.y));
        #else
          #local _theta = 0.0;
        #end
        #if (_roundness > 0.001)
          box {
            <0.0, -0.001, -100000.0> <-100000.0, 100000.0, 100000.0>
            rotate _theta*y
          }
          box {
            <0.0, 0.001, 0.0> <-100000.0, -100000.0, -100000.0>
            rotate _theta*y
          }
          #declare _l = sqrt(_vD.x * _vD.x + _vD.y * _vD.y);
          box {
            <0.0, 0.001, _l> <-100000.0, -100000.0, _l + 100000.0>
            rotate _theta*y
          }
        #end
        box {
          <-_roundness-0.00001, 0.001, -100000.0> <-100000.0, -100000.0, 100000.0>
          rotate _theta*y
        }
        #if (abs(_vC.x - _vD.x) > 0.001)
          #local _theta = -degrees(atan((_vC.y - _vD.y) / (_vC.x - _vD.x)));
        #else
          #local _theta = 0.0;
        #end
        #if (_roundness > 0.001)
          box {
            <-1.0, -0.001, 0.0> <100000.0, 100000.0, 100000.0>
            rotate _theta*y
            translate <_vD.x, 0.0, _vD.y>
          }
          box {
            <0.0, 0.001, 0.0> <-100000.0, -100000.0, 100000.0>
            rotate _theta*y
            translate <_vD.x, 0.0, _vD.y>
          }
          #declare _l = sqrt((_vC.x - _vD.x) * (_vC.x - _vD.x) + (_vC.y - _vD.y) * (_vC.y - _vD.y));
          box {
            <_l, 0.001, 0.0> <_l + 100000.0, -100000.0, 100000.0>
            rotate _theta*y
            translate <_vD.x, 0.0, _vD.y>
          }
        #end
        box {
          <-1.0, 0.001, _roundness+0.00001> <100000.0, -100000.0, 100000.0>
          rotate _theta*y
          translate <_vD.x, 0.0, _vD.y>
        }
        #if (abs(_vC.y - _vB.y) > 0.001)
          #local _theta = degrees(atan((_vC.x - _vB.x) / (_vC.y - _vB.y)));
        #else
          #local _theta = 0.0;
        #end
        #if (_roundness > 0.001)
          box {
            <0.0, -0.001, -100000.0> <100000.0, 100000.0, 100000.0>
            rotate _theta*y
            translate <_vB.x, 0.0, _vB.y>
          }
          box {
            <0.0, 0.001, 0.0> <100000.0, -100000.0, -100000.0>
            rotate _theta*y
            translate <_vB.x, 0.0, _vB.y>
          }
          #declare _l = sqrt((_vC.x - _vB.x) * (_vC.x - _vB.x) + (_vC.y - _vB.y) * (_vC.y - _vB.y));
          box {
            <0.0, 0.001, _l> <100000.0, -100000.0, _l + 100000.0>
            rotate _theta*y
            translate <_vB.x, 0.0, _vB.y>
          }
        #end
        box {
          <_roundness+0.00001, 0.001, -100000.0> <100000.0, -100000.0, 100000.0>
          rotate _theta*y
          translate <_vB.x, 0.0, _vB.y>
        }
      }
    }
    #if (_roundness > 0.001)
      union {
        cylinder { <0.0, 0.0, 0.0>, <_vB.x, 0.0, _vB.y>, _roundness }
        cylinder { <0.0, 0.0, 0.0>, <_vD.x, 0.0, _vD.y>, _roundness }
        cylinder { <_vB.x, 0.0, _vB.y>, <_vC.x, 0.0, _vC.y>, _roundness }
        cylinder { <_vD.x, 0.0, _vD.y>, <_vC.x, 0.0, _vC.y>, _roundness }
        cylinder { <0.0, 0.0, 0.0>, <0.0, -_thickness, 0.0>, _roundness }
        cylinder { <_vB.x, 0.0, _vB.y>, <_vB.x, -_thickness, _vB.y>, _roundness }
        cylinder { <_vC.x, 0.0, _vC.y>, <_vC.x, -_thickness, _vC.y>, _roundness }
        cylinder { <_vD.x, 0.0, _vD.y>, <_vD.x, -_thickness, _vD.y>, _roundness }
        sphere { <0.0, 0.0, 0.0>, _roundness }
        sphere { <_vB.x, 0.0, _vB.y>, _roundness }
        sphere { <_vC.x, 0.0, _vC.y>, _roundness }
        sphere { <_vD.x, 0.0, _vD.y>, _roundness }
      }
    #end
  }
#end

#macro mecStructQuadriPlaneIsInside(_vB, _vC, _vD, _x, _z, _safeBorder)
  #local _minX = _z / _vD.y * _vD.x + _safeBorder;
  #local _maxX = _vB.x + (_z - _vB.y) / (_vC.y - _vB.y) * (_vC.x - _vB.x) - _safeBorder;
  #local _minZ = _x / _vB.x * _vB.y + _safeBorder;
  #local _maxZ = _vD.y + (_x - _vD.x) / (_vC.x - _vD.x) * (_vC.y - _vD.y) - _safeBorder;
  #if (_x < _minX)
    #local _ret = false;
  #else
    #if (_x > _maxX)
      #local _ret = false;
    #else
      #if (_z < _minZ)
        #local _ret = false;
      #else
        #if (_z > _maxZ)
          #local _ret = false;
        #else
          #local _ret = true;
        #end
      #end
    #end
  #end
  _ret
#end

#macro mecStructQuadriPlaneGetXInsideAtZ(_vB, _vC, _vD, _x, _z, _safeBorder)
  #local _minX = _z / _vD.y * _vD.x + _safeBorder;
  #local _maxX = _vB.x + (_z - _vB.y) / (_vC.y - _vB.y) * (_vC.x - _vB.x) - _safeBorder;
  #if (_x < _minX)
    #local _ret = _minX;
  #else
    #if (_x > _maxX)
      #local _ret = _maxX;
    #else
      #local _ret = _x;
    #end
  #end
  _ret
#end

#macro mecStructQuadriPlaneGetZInsideAtX(_vB, _vC, _vD, _x, _z, _safeBorder)
  #local _minZ = _x / _vB.x * _vB.y + _safeBorder;
  #local _maxZ = _vD.y + (_x - _vD.x) / (_vC.x - _vD.x) * (_vC.y - _vD.y) - _safeBorder;
  #if (_z < _minZ)
    #local _ret = _minZ;
  #else
    #if (_z > _maxZ)
      #local _ret = _maxZ;
    #else
      #local _ret = _z;
    #end
  #end
  _ret
#end

#macro mecStructQuadriPlaneEquipped(_vB, _vC, _vD, _paramStruct, _texStruct)
  #local _thickness = _paramStruct[0];
  #local _roundness = _paramStruct[1];
  #local _seed = _paramStruct[2];
  #local _safeBorder = _paramStruct[3];
  #local _nbBox = _paramStruct[4];
  #local _boxMaxHeight = _paramStruct[5];
  #local _boxMaxSize = _paramStruct[6];
  #local _nbTube = _paramStruct[7];
  #local _tubeMaxSize = _paramStruct[8];
  #local _nbPlate = _paramStruct[9];
  #local _plateInterstice = _paramStruct[10];
  #local _nbTorn = _paramStruct[11];
  #local _seedTex = _paramStruct[12];
  #local _propStripe = _paramStruct[13];
  #local _texPlate = _texStruct[0];
  #local _texTubeA = _texStruct[1];
  #local _texTubeB = _texStruct[2];
  #local _texBoxA = _texStruct[3];
  #local _texBoxB = _texStruct[4];
  #local _texSignA = _texStruct[5];
  #local _texSignB = _texStruct[6];
  #local _rndSeedTex = seed(_seedTex);
  union {
    #local _bound = mecStructQuadriPlaneBoundOutside(_vB, _vC, _vD);
    #local _rndSeed = seed(_seed);

    // MAIN PLATE AND SUBPLATES

    #local _iPlate = 0;
    #if (_nbPlate > 0)
      #local _plA = array[_nbPlate];
      #local _plB = array[_nbPlate];
      #local _plC = array[_nbPlate];
      #local _plD = array[_nbPlate];
    #end
    #while (_iPlate < _nbPlate)
      #local _vX = (0.1 + 0.9 * rand(_rndSeed)) * _boxMaxSize;
      #local _vZ = (0.1 + 0.9 * rand(_rndSeed)) * _boxMaxSize;
      #local _plA[_iPlate] = array[2];
      #local _plA[_iPlate][0] = _bound[0] + rand(_rndSeed) * (_bound[1] - _bound[0] - _vX);
      #local _plA[_iPlate][1] = _bound[2] + rand(_rndSeed) * (_bound[3] - _bound[2] - _vZ);
      #local _plA[_iPlate][0] = mecStructQuadriPlaneGetXInsideAtZ(_vB, _vC, _vD, _plA[_iPlate][0], _plA[_iPlate][1], _safeBorder);
      #local _plA[_iPlate][1] = mecStructQuadriPlaneGetZInsideAtX(_vB, _vC, _vD, _plA[_iPlate][0], _plA[_iPlate][1], _safeBorder);
      #local _plB[_iPlate] = array[2];
      #local _plB[_iPlate][0] = mecStructQuadriPlaneGetXInsideAtZ(_vB, _vC, _vD, _plA[_iPlate][0] + _vX, _plA[_iPlate][1], _safeBorder);
      #local _plB[_iPlate][1] = mecStructQuadriPlaneGetZInsideAtX(_vB, _vC, _vD, _plB[_iPlate][0], _plA[_iPlate][1], _safeBorder);
      #local _plC[_iPlate] = array[2];
      #local _plC[_iPlate][0] = mecStructQuadriPlaneGetXInsideAtZ(_vB, _vC, _vD, _plA[_iPlate][0] + _vX, _plA[_iPlate][1] + _vZ, _safeBorder);
      #local _plC[_iPlate][1] = mecStructQuadriPlaneGetZInsideAtX(_vB, _vC, _vD, _plC[_iPlate][0], _plA[_iPlate][1] + _vZ, _safeBorder);
      #local _plD[_iPlate] = array[2];
      #local _plD[_iPlate][0] = mecStructQuadriPlaneGetXInsideAtZ(_vB, _vC, _vD, _plA[_iPlate][0], _plA[_iPlate][1] + _vZ, _safeBorder);
      #local _plD[_iPlate][1] = mecStructQuadriPlaneGetZInsideAtX(_vB, _vC, _vD, _plD[_iPlate][0], _plA[_iPlate][1] + _vZ, _safeBorder);
      #if ((_plA[_iPlate][0] != _plB[_iPlate][0] | _plA[_iPlate][1] != _plB[_iPlate][1]) &
           (_plA[_iPlate][0] != _plD[_iPlate][0] | _plA[_iPlate][1] != _plD[_iPlate][1]) &
           (_plB[_iPlate][0] != _plC[_iPlate][0] | _plB[_iPlate][1] != _plC[_iPlate][1]) &
           (_plB[_iPlate][0] != _plD[_iPlate][0] | _plB[_iPlate][1] != _plD[_iPlate][1]) &
           (_plC[_iPlate][0] != _plD[_iPlate][0] | _plC[_iPlate][1] != _plD[_iPlate][1]))
        #declare _iPlate = _iPlate + 1;
      #end
    #end

    //difference {
      union {
        difference {
          #local _hasStripe = 0;
          #local _material = material { _texPlate }
          mecStructQuadriPlane(_vB, _vC, _vD, _thickness, _roundness, _hasStripe, _material)
          union {
            #local _iPlate = 0;
            #while (_iPlate < _nbPlate)
              object {
                mecStructQuadriPlane(<_plB[_iPlate][0]-_plA[_iPlate][0], _plB[_iPlate][1]-_plA[_iPlate][1]>, <_plC[_iPlate][0]-_plA[_iPlate][0], _plC[_iPlate][1]-_plA[_iPlate][1]>, <_plD[_iPlate][0]-_plA[_iPlate][0], _plD[_iPlate][1]-_plA[_iPlate][1]>, _thickness, 0.0, _hasStripe, _material)
                scale <1.0+2.0*_plateInterstice/(_plB[_iPlate][0]-_plA[_iPlate][0]),1.0,1.0+2.0*_plateInterstice/(_plD[_iPlate][1]-_plA[_iPlate][1])>
                translate <_plA[_iPlate][0], _roundness + 0.0001, _plA[_iPlate][1]>
              }
              #declare _iPlate = _iPlate + 1;
            #end
          }
        }
        union {
          #local _iPlate = 0;
          #local _flagSign = 0;
          #while (_iPlate < _nbPlate)
            object {
              mecStructQuadriPlaneWithoutMaterial(<_plB[_iPlate][0]-_plA[_iPlate][0], _plB[_iPlate][1]-_plA[_iPlate][1]>, <_plC[_iPlate][0]-_plA[_iPlate][0], _plC[_iPlate][1]-_plA[_iPlate][1]>, <_plD[_iPlate][0]-_plA[_iPlate][0], _plD[_iPlate][1]-_plA[_iPlate][1]>, _thickness, 0.0)
              #local _randVal = rand(_rndSeedTex);
              #if (_flagSign = 0 & _randVal < 0.1)
                #local _flagSign = 1;
                scale y * 1.001
                material {_texSignA scale 0.1}
              #else
                #if (_flagSign = 0 & _randVal > 0.8)
                  #local _flagSign = 1;
                  scale y * 1.001
                  material {_texSignB scale 0.1}
                #else
                  material { _texPlate }
                #end
              #end
              translate <_plA[_iPlate][0] + _plateInterstice, _roundness, _plA[_iPlate][1] + _plateInterstice>
            }
            #declare _iPlate = _iPlate + 1;
          #end
        }
      }

      // TORN
      /*#local _iTorn = 0;
      #local _center = (_B + _C + _D) / 4.0;
      #if (abs(_B.x) > abs(_B.y))
        #local _n = ceil(_nbTorn * abs(_B.x) * abs(_D.y));
      #else
        #local _n = ceil(_nbTorn * abs(_B.y) * abs(_D.x));
      #end
      #if (_n < _nbTorn)
        #local _n = _nbTorn;
      #end
      union {
      #while (_iTorn < _n)
        #local _pA = rand(_rndSeed);
        #local _pB = rand(_rndSeed);
        #local _pC = rand(_rndSeed);
        #local _pD = rand(_rndSeed);
        #local _pTot = _pA + _pB + _pC + _pD;
        #local _pA = _pA / _pTot;
        #local _pB = _pB / _pTot;
        #local _pC = _pC / _pTot;
        #local _pD = _pD / _pTot;
        #local _pos = (_pB * _B + _pC * _C + _pD * _D);
        #local _v = _pos - _center;
        #local _m = sqrt(_center.x * _center.x + _center.y * _center.y);
        #local _l = sqrt(_v.x * _v.x + _v.y * _v.y);
        #local _a = _l / _m;
        #local _pos = _center + (1.0 + _a * _a) * _v;
        sphere {
          <0.0, 0.0, 0.0>
          1.0
          #local _prof = 0.001 + 0.009 * rand(_rndSeed);
          scale <0.001 + 0.009 * rand(_rndSeed), _prof, 0.001 + 0.099 * rand(_rndSeed)>
          rotate y * 360.0 * rand(_rndSeed)
          translate <_pos.x, _roundness + _prof * 0.5 * rand(_rndSeed), _pos.y>
        }
        #local _iTorn = _iTorn + 1;
      #end
      }
    }*/


    // BOXES

    union {
    #local _iBox = 0;
    #while (_iBox < _nbBox)
      #local _vX = (0.1 + 0.9 * rand(_rndSeed)) * _boxMaxSize;
      #local _vZ = (0.1 + 0.9 * rand(_rndSeed)) * _boxMaxSize;
      #local _Ap = array[2];
      #local _Ap[0] = _bound[0] + rand(_rndSeed) * (_bound[1] - _bound[0] - _vX);
      #local _Ap[1] = _bound[2] + rand(_rndSeed) * (_bound[3] - _bound[2] - _vZ);
      #local _Ap[0] = mecStructQuadriPlaneGetXInsideAtZ(_vB, _vC, _vD, _Ap[0], _Ap[1], _safeBorder);
      #local _Ap[1] = mecStructQuadriPlaneGetZInsideAtX(_vB, _vC, _vD, _Ap[0], _Ap[1], _safeBorder);
      #local _Bp = array[2];
      #local _Bp[0] = mecStructQuadriPlaneGetXInsideAtZ(_vB, _vC, _vD, _Ap[0] + _vX, _Ap[1], _safeBorder);
      #local _Bp[1] = mecStructQuadriPlaneGetZInsideAtX(_vB, _vC, _vD, _Bp[0], _Ap[1], _safeBorder);
      #local _Cp = array[2];
      #local _Cp[0] = mecStructQuadriPlaneGetXInsideAtZ(_vB, _vC, _vD, _Ap[0] + _vX, _Ap[1] + _vZ, _safeBorder);
      #local _Cp[1] = mecStructQuadriPlaneGetZInsideAtX(_vB, _vC, _vD, _Cp[0], _Ap[1] + _vZ, _safeBorder);
      #local _Dp = array[2];
      #local _Dp[0] = mecStructQuadriPlaneGetXInsideAtZ(_vB, _vC, _vD, _Ap[0], _Ap[1] + _vZ, _safeBorder);
      #local _Dp[1] = mecStructQuadriPlaneGetZInsideAtX(_vB, _vC, _vD, _Dp[0], _Ap[1] + _vZ, _safeBorder);
      #local _height = (0.1 + 0.9 * rand(_rndSeed)) * _boxMaxHeight;
      #local _round = (0.75 + 0.25 * rand(_rndSeed)) * _roundness;
      #if (_round > abs(_Bp[0]-_Ap[0]))
        #local _round = abs(_Bp[0]-_Ap[0]);
      #end
      #if (_round > abs(_Dp[1]-_Ap[1]))
        #local _round = abs(_Dp[1]-_Ap[1]);
      #end
      #if ((_Ap[0] != _Bp[0] | _Ap[1] != _Bp[1]) &
           (_Ap[0] != _Dp[0] | _Ap[1] != _Dp[1]) &
           (_Bp[0] != _Cp[0] | _Bp[1] != _Cp[1]) &
           (_Bp[0] != _Dp[0] | _Bp[1] != _Dp[1]) &
           (_Cp[0] != _Dp[0] | _Cp[1] != _Dp[1]))
        #if (rand(_rndSeedTex) < _propStripe)
          #local _hasStripe = 1;
        #else
          #local _hasStripe = 0;
        #end
        #local _randVal = rand(_rndSeedTex);
        #if (_randVal < 0.3)
          #local _material = material { _texBoxA }
        #else
          #if (_randVal > 0.7)
            #local _material = material { _texBoxB }
          #else
            #local _material = material { _texPlate }
          #end
        #end
        object {
          mecStructQuadriPlane(<_Bp[0]-_Ap[0], _Bp[1]-_Ap[1]>, <_Cp[0]-_Ap[0], _Cp[1]-_Ap[1]>, <_Dp[0]-_Ap[0], _Dp[1]-_Ap[1]>, _height, _round, _hasStripe, _material)
          translate <_Ap[0], _roundness + _height, _Ap[1]>
        }
        #local _iBox = _iBox + 1;
      #end
    #end
    }

    // TUBES

    union {
    #local _iTube = 0;
    #while (_iTube < _nbTube)
      #local _vX = (0.1 + 0.9 * rand(_rndSeed)) * (_bound[1] - _bound[0]);
      #local _vZ = (0.1 + 0.9 * rand(_rndSeed)) * (_bound[3] - _bound[2]);
      #local _Ap = array[2];
      #local _Ap[0] = _bound[0] + rand(_rndSeed) * (_bound[1] - _bound[0] - _vX);
      #local _Ap[1] = _bound[2] + rand(_rndSeed) * (_bound[3] - _bound[2] - _vZ);
      #local _Ap[0] = mecStructQuadriPlaneGetXInsideAtZ(_vB, _vC, _vD, _Ap[0], _Ap[1], _safeBorder);
      #local _Ap[1] = mecStructQuadriPlaneGetZInsideAtX(_vB, _vC, _vD, _Ap[0], _Ap[1], _safeBorder);
      #local _Bp = array[2];
      #local _Bp[0] = _Ap[0] + _vX;
      #local _Bp[1] = _Ap[1] + _vZ;
      #local _Bp[0] = mecStructQuadriPlaneGetXInsideAtZ(_vB, _vC, _vD, _Bp[0], _Bp[1], _safeBorder);
      #local _Bp[1] = mecStructQuadriPlaneGetZInsideAtX(_vB, _vC, _vD, _Bp[0], _Bp[1], _safeBorder);
      #local _round = (0.1 + 0.9 * rand(_rndSeed)) * _tubeMaxSize;
      #local _height = _round * (0.5 + 0.2 * rand(_rndSeed));
      #local _type = rand(_rndSeed);
      #local _cond = true;
      #if (_type < 0.5 & mecStructQuadriPlaneIsInside(_vB, _vC, _vD, _Ap[0], _Bp[1], _safeBorder) = false) 
        #declare _cond = false;
      #end
      #if (_type >= 0.5 & mecStructQuadriPlaneIsInside(_vB, _vC, _vD, _Bp[0], _Ap[1], _safeBorder) = false) 
        #declare _cond = false;
      #end
      #if (_cond = true)
        #if (_type < 0.5)
          cylinder {
            <_Ap[0], _roundness + _height, _Ap[1]>, <_Ap[0], _roundness + _height, _Bp[1]>, _round * 0.5
          }
          cylinder {
            <_Ap[0], _roundness + _height, _Bp[1]>, <_Bp[0], _roundness + _height, _Bp[1]>, _round * 0.5
          }
          sphere {
            <_Ap[0], _roundness + _height, _Bp[1]>, _round * 0.5
          }
        #else
          cylinder {
            <_Ap[0], _roundness + _height, _Ap[1]>, <_Bp[0], _roundness + _height, _Ap[1]>, _round * 0.5
          }
          cylinder {
            <_Bp[0], _roundness + _height, _Ap[1]>, <_Bp[0], _roundness + _height, _Bp[1]>, _round * 0.5
          }
          sphere {
            <_Bp[0], _roundness + _height, _Ap[1]>, _round * 0.5
          }
        #end
        cylinder {
          <_Ap[0], _roundness + _height, _Ap[1]>, <_Ap[0], -_thickness, _Ap[1]>, _round * 0.5
        }
        cylinder {
          <_Bp[0], _roundness + _height, _Bp[1]>, <_Bp[0], -_thickness, _Bp[1]>, _round * 0.5
        }
        sphere {
          <_Ap[0], _roundness + _height, _Ap[1]>, _round * 0.5
        }
        sphere {
          <_Bp[0], _roundness + _height, _Bp[1]>, _round * 0.5
        }
        #local _iTube = _iTube + 1; 
      #end
    #end
    #if (rand(_rndSeedTex) > 0.2)
      material {_texTubeA}
    #else
      material {_texTubeB}
    #end
    }

  }
#end







