#include "colors.inc"
#include "textures.inc"
#include "mechanicalStructures.inc"

// Random seed
#declare RndSeed = 3;

// Coordinates of the corner of the element
// _A is at <0,0>
#declare _w1 = 1.0;
#declare _d1 = 1.0;
#declare _B = <_w1, 0.0>;
#declare _C = <_w1, _d1>;
#declare _D = <0.0, _d1>;

// Get the number of details on the element
// nb box, tube, plate
#declare _detail = array[3];
#declare _detail[0] = 7;
#declare _detail[1] = 3;
#declare _detail[2] = 20;

// Parameters controlling the details
#declare _boxMaxHeight = 0.05;
#declare _boxMaxSize = 0.3;
#declare _tubeMaxSize = 0.05;
#declare _plateInterstice = 0.01;
#declare _thickness = 0.0001;
#declare _roundness = 0.02;
#declare _safeBorder = 0.01;
#declare _propStripe = 0.0;
#declare _nbTorn = 1.0;

// Put all the parameters into an array
#declare _paramStruct = array[14];
#declare _paramStruct[0] = _thickness;
#declare _paramStruct[1] = _roundness;
#declare _paramStruct[2] = RndSeed;
#declare _paramStruct[3] = _safeBorder;
#declare _paramStruct[4] = _detail[0];
#declare _paramStruct[5] = _boxMaxHeight;
#declare _paramStruct[6] = _boxMaxSize;
#declare _paramStruct[7] = _detail[1];
#declare _paramStruct[8] = _tubeMaxSize;
#declare _paramStruct[9] = _detail[2];
#declare _paramStruct[10] = _plateInterstice;
#declare _paramStruct[11] = _nbTorn;
#declare _paramStruct[12] = RndSeed+1;
#declare _paramStruct[13] = _propStripe;

// Put various textures in an array to be applied to the details
#declare _texStruct = array[7];
#declare _texStruct[0] = material {texture {Aluminum}};
#declare _texStruct[1] = material {texture {Aluminum}};
#declare _texStruct[2] = material {texture {Bright_Bronze}};
#declare _texStruct[3] = material {texture {Aluminum}};
#declare _texStruct[4] = material {texture {Bright_Bronze}};
#declare _texStruct[5] = material {texture {Bright_Bronze}};
#declare _texStruct[6] = material {texture {Aluminum}};

// Create the element
#declare element = object {
  mecStructQuadriPlaneEquipped(_B, _C, _D, _paramStruct, _texStruct)
};

light_source {
  10.0 * y
  color rgb 1.0
}

camera {
  location 0.5*(x+z)+2*y
  look_at 0.5*(x+z)
}

object { element }
